/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.ChestContainer;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.IPriorityHost;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import appeng.tile.storage.ChestTileEntity;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

final class AESubScreen {
    private final AEBaseScreen<?> gui;
    private final ContainerType<?> previousContainerType;
    private final ItemStack previousContainerIcon;

    public AESubScreen(AEBaseScreen<?> gui, Object containerTarget) {
        this.gui = gui;
        IDefinitions definitions = Api.instance().definitions();
        IParts parts = definitions.parts();
        if (containerTarget instanceof ChestTileEntity) {
            IPriorityHost priorityHost = (IPriorityHost)containerTarget;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = ChestContainer.TYPE;
        } else if (containerTarget instanceof IPriorityHost) {
            IPriorityHost priorityHost = (IPriorityHost)containerTarget;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = priorityHost.getContainerType();
        } else if (containerTarget instanceof WirelessTerminalGuiObject) {
            this.previousContainerIcon = definitions.items().wirelessTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = WirelessTermContainer.TYPE;
        } else if (containerTarget instanceof TerminalPart) {
            this.previousContainerIcon = parts.terminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = MEMonitorableContainer.TYPE;
        } else if (containerTarget instanceof CraftingTerminalPart) {
            this.previousContainerIcon = parts.craftingTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = CraftingTermContainer.TYPE;
        } else if (containerTarget instanceof PatternTerminalPart) {
            this.previousContainerIcon = parts.patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = PatternTermContainer.TYPE;
        } else {
            this.previousContainerIcon = null;
            this.previousContainerType = null;
        }
    }

    public TabButton addBackButton(Consumer<TabButton> buttonAdder, int x, int y) {
        return this.addBackButton(buttonAdder, x, y, null);
    }

    public TabButton addBackButton(Consumer<TabButton> buttonAdder, int x, int y, @Nullable ITextComponent label) {
        if (this.previousContainerType != null && !this.previousContainerIcon.func_190926_b()) {
            if (label == null) {
                label = this.previousContainerIcon.func_200301_q();
            }
            ItemRenderer itemRenderer = this.gui.getMinecraft().func_175599_af();
            TabButton button = new TabButton(this.gui.getGuiLeft() + x, this.gui.getGuiTop() + y, this.previousContainerIcon, label, itemRenderer, btn -> this.goBack());
            buttonAdder.accept(button);
            return button;
        }
        return null;
    }

    public void goBack() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(this.previousContainerType));
    }
}

