/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.container.implementations.CellWorkbenchContainer;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public class CellWorkbenchScreen
extends UpgradeableScreen<CellWorkbenchContainer> {
    private ToggleButton copyMode;

    public CellWorkbenchScreen(CellWorkbenchContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_147000_g = 251;
    }

    @Override
    protected void addButtons() {
        this.fuzzyMode = (SettingToggleButton)this.func_230480_a_((Widget)new SettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 68, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL, this::toggleFuzzyMode));
        this.func_230480_a_((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 28, ActionItems.WRENCH, act1 -> this.action("Partition")));
        this.func_230480_a_((Widget)new ActionButton(this.field_147003_i - 18, this.field_147009_r + 8, ActionItems.CLOSE, act -> this.action("Clear")));
        this.copyMode = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_147003_i - 18, this.field_147009_r + 48, 181, 197, GuiText.CopyMode.getLocal(), GuiText.CopyModeDesc.getLocal(), act -> this.action("CopyMode")));
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_238474_b_(matrixStack, offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            if (((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() <= 8) {
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY, 177, 0, 35, 7 + ((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() * 18);
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY + (7 + ((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() * 18), 177, 151, 35, 7);
            } else if (((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() <= 16) {
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY, 177, 0, 35, 151);
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY + 151, 177, 151, 35, 7);
                int dx = ((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() - 8;
                this.func_238474_b_(matrixStack, offsetX + 177 + 27, offsetY, 186, 0, 27, 7 + dx * 18);
                if (dx == 8) {
                    this.func_238474_b_(matrixStack, offsetX + 177 + 27, offsetY + (7 + dx * 18), 186, 151, 27, 7);
                } else {
                    this.func_238474_b_(matrixStack, offsetX + 177 + 27 + 4, offsetY + (7 + dx * 18), 190, 151, 27, 7);
                }
            } else {
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY, 177, 0, 35, 151);
                this.func_238474_b_(matrixStack, offsetX + 177, offsetY + 151, 177, 151, 35, 7);
                this.func_238474_b_(matrixStack, offsetX + 177 + 27, offsetY, 186, 0, 27, 151);
                this.func_238474_b_(matrixStack, offsetX + 177 + 27, offsetY + 151, 186, 151, 27, 7);
                int dx = ((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() - 16;
                this.func_238474_b_(matrixStack, offsetX + 177 + 27 + 18, offsetY, 186, 0, 27, 7 + dx * 18);
                if (dx == 8) {
                    this.func_238474_b_(matrixStack, offsetX + 177 + 27 + 18, offsetY + (7 + dx * 18), 186, 151, 27, 7);
                } else {
                    this.func_238474_b_(matrixStack, offsetX + 177 + 27 + 18 + 4, offsetY + (7 + dx * 18), 190, 151, 27, 7);
                }
            }
        }
        if (this.hasToolbox()) {
            this.func_238474_b_(matrixStack, offsetX + 178, offsetY + this.field_147000_g - 90, 178, 161, 68, 68);
        }
    }

    @Override
    protected void handleButtonVisibility() {
        this.copyMode.setState(((CellWorkbenchContainer)this.field_147002_h).getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        boolean hasFuzzy = false;
        IItemHandler inv = ((CellWorkbenchContainer)this.field_147002_h).getCellUpgradeInventory();
        for (int x = 0; x < inv.getSlots(); ++x) {
            ItemStack is = inv.getStackInSlot(x);
            if (is.func_190926_b() || !(is.func_77973_b() instanceof IUpgradeModule) || ((IUpgradeModule)is.func_77973_b()).getType(is) != Upgrades.FUZZY) continue;
            hasFuzzy = true;
        }
        this.fuzzyMode.setVisibility(hasFuzzy);
    }

    @Override
    protected String getBackground() {
        return "guis/cellworkbench.png";
    }

    @Override
    protected boolean drawUpgrades() {
        return ((CellWorkbenchContainer)this.field_147002_h).availableUpgrades() > 0;
    }

    @Override
    protected GuiText getName() {
        return GuiText.CellWorkbench;
    }

    private void action(String type) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("CellWorkbench.Action", type));
    }

    private void toggleFuzzyMode(SettingToggleButton<FuzzyMode> button, boolean backwards) {
        FuzzyMode fz = button.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("CellWorkbench.Fuzzy", fz.name()));
    }
}

