/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.google.common.base.Joiner;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class CraftingCPUScreen<T extends CraftingCPUContainer>
extends AEBaseScreen<T>
implements ISortSource {
    private static final int GUI_HEIGHT = 184;
    private static final int GUI_WIDTH = 238;
    private static final int DISPLAYED_ROWS = 6;
    private static final int TEXT_COLOR = 0x404040;
    private static final int BACKGROUND_ALPHA = 0x5A000000;
    private static final int SECTION_LENGTH = 67;
    private static final int SCROLLBAR_TOP = 19;
    private static final int SCROLLBAR_LEFT = 218;
    private static final int SCROLLBAR_HEIGHT = 137;
    private static final int CANCEL_LEFT_OFFSET = 163;
    private static final int CANCEL_TOP_OFFSET = 25;
    private static final int CANCEL_HEIGHT = 20;
    private static final int CANCEL_WIDTH = 50;
    private static final int TITLE_TOP_OFFSET = 7;
    private static final int TITLE_LEFT_OFFSET = 8;
    private static final int ITEMSTACK_LEFT_OFFSET = 9;
    private static final int ITEMSTACK_TOP_OFFSET = 22;
    private IItemList<IAEItemStack> storage = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private IItemList<IAEItemStack> active = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private IItemList<IAEItemStack> pending = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private Button cancel;
    private int tooltip = -1;

    public CraftingCPUScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_147000_g = 184;
        this.field_146999_f = 238;
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
    }

    public void clearItems() {
        this.storage = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.active = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.pending = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
        this.visual = new ArrayList<IAEItemStack>();
    }

    private void cancel() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("TileCrafting.Cancel", "Cancel"));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.setScrollBar();
        this.cancel = new Button(this.field_147003_i + 163, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.text(), btn -> this.cancel());
        this.func_230480_a_((Widget)this.cancel);
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(137);
        this.getScrollBar().setRange(0, (size + 2) / 3 - 6, 1);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float btn) {
        this.cancel.field_230693_o_ = !this.visual.isEmpty();
        int gx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int gy = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        String title = this.getGuiDisplayName(GuiText.CraftingStatus.text()).getString();
        if (((CraftingCPUContainer)this.field_147002_h).getEstimatedTime() > 0L && !this.visual.isEmpty()) {
            long etaInMilliseconds = TimeUnit.MILLISECONDS.convert(((CraftingCPUContainer)this.field_147002_h).getEstimatedTime(), TimeUnit.NANOSECONDS);
            String etaTimeText = DurationFormatUtils.formatDuration((long)etaInMilliseconds, (String)GuiText.ETAFormat.getLocal());
            title = title + " - " + etaTimeText;
        }
        this.field_230712_o_.func_238421_b_(matrixStack, title, 8.0f, 7.0f, 0x404040);
        int x = 0;
        int y = 0;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 18;
        String dspToolTip = "";
        ArrayList<String> lineList = new ArrayList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        int offY = 23;
        ReadableNumberConverter converter = ReadableNumberConverter.INSTANCE;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack activeStack = this.active.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            boolean active = false;
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                ++lines;
                active = true;
            }
            boolean scheduled = false;
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
                scheduled = true;
            }
            if (AEConfig.instance().isUseColoredCraftingStatus() && (active || scheduled)) {
                int bgColor = (active ? AEColor.GREEN.blackVariant : AEColor.YELLOW.blackVariant) | 0x5A000000;
                int startX = (x * 68 + 9) * 2;
                int startY = (y * 23 + 22 - 3) * 2;
                CraftingCPUScreen.func_238467_a_((MatrixStack)matrixStack, (int)startX, (int)startY, (int)(startX + 134), (int)(startY + 46 - 2), (int)bgColor);
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = GuiText.Stored.getLocal() + ": " + converter.toWideReadableForm(stored.getStackSize());
                w = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Stored.getLocal() + ": " + Long.toString(stored.getStackSize()));
                }
                downY += 5;
            }
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                String str = GuiText.Crafting.getLocal() + ": " + converter.toWideReadableForm(activeStack.getStackSize());
                w = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Crafting.getLocal() + ": " + Long.toString(activeStack.getStackSize()));
                }
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = GuiText.Scheduled.getLocal() + ": " + converter.toWideReadableForm(pendingStack.getStackSize());
                w = 4 + this.field_230712_o_.func_78256_a(str);
                this.field_230712_o_.func_238421_b_(matrixStack, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Scheduled.getLocal() + ": " + Long.toString(pendingStack.getStackSize()));
                }
            }
            RenderSystem.popMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.asItemStackRepresentation();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(refStack).getString();
                if (lineList.size() > 0) {
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
            }
            this.drawItem(posX, posY, is);
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && !dspToolTip.isEmpty()) {
            this.drawTooltip(matrixStack, toolPosX, toolPosY + 10, (ITextComponent)new StringTextComponent(dspToolTip));
        }
    }

    @Override
    public void drawBG(MatrixStack matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/craftingcpu.png");
        this.func_238474_b_(matrices, offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.active, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack b = this.active.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (b != null) {
            total += b.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    @Override
    public SortOrder getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public SortDir getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public ViewItems getSortDisplay() {
        return ViewItems.ALL;
    }
}

