/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.core.localization.GuiText;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.ImportBusPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class UpgradeableScreen<T extends UpgradeableContainer>
extends AEBaseScreen<T> {
    protected final UpgradeableContainer cvb;
    protected final IUpgradeableHost bc;
    protected SettingToggleButton<RedstoneMode> redstoneMode;
    protected SettingToggleButton<FuzzyMode> fuzzyMode;
    protected SettingToggleButton<YesNo> craftMode;
    protected SettingToggleButton<SchedulingMode> schedulingMode;

    public UpgradeableScreen(T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.cvb = container;
        this.bc = (IUpgradeableHost)((AEBaseContainer)((Object)container)).getTarget();
        this.field_146999_f = this.hasToolbox() ? 246 : 211;
        this.field_147000_g = 184;
    }

    protected boolean hasToolbox() {
        return ((UpgradeableContainer)this.field_147002_h).hasToolbox();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addButtons();
    }

    protected void addButtons() {
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_147003_i - 18, this.field_147009_r + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.func_230480_a_((Widget)this.redstoneMode);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_147003_i - 18, this.field_147009_r + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.func_230480_a_((Widget)this.fuzzyMode);
        this.craftMode = new ServerSettingToggleButton<YesNo>(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.func_230480_a_((Widget)this.craftMode);
        this.schedulingMode = new ServerSettingToggleButton<SchedulingMode>(this.field_147003_i - 18, this.field_147009_r + 68, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.func_230480_a_((Widget)this.schedulingMode);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.getGuiDisplayName(this.getName().text()).getString(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, GuiText.inventory.getLocal(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.getRedStoneMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.getCraftingMode());
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(this.cvb.getSchedulingMode());
        }
    }

    @Override
    public void drawBG(MatrixStack matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_238474_b_(matrices, offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            this.func_238474_b_(matrices, offsetX + 177, offsetY, 177, 0, 35, 14 + this.cvb.availableUpgrades() * 18);
        }
        if (this.hasToolbox()) {
            this.func_238474_b_(matrices, offsetX + 178, offsetY + this.field_147000_g - 90, 178, this.field_147000_g - 90, 68, 68);
        }
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CAPACITY) > 0 && this.bc instanceof ExportBusPart);
        }
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected GuiText getName() {
        return this.bc instanceof ImportBusPart ? GuiText.ImportBus : GuiText.ExportBus;
    }
}

