/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class IconButton
extends Button
implements ITooltip {
    public static final ResourceLocation TEXTURE_STATES = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    public IconButton(int x, int y, Button.IPressable onPress) {
        super(x, y, 16, 16, StringTextComponent.field_240750_d_, onPress);
    }

    public void setVisibility(boolean vis) {
        this.field_230694_p_ = vis;
        this.field_230693_o_ = vis;
    }

    public void func_230988_a_(SoundHandler soundHandler) {
        if (!this.disableClickSound) {
            super.func_230988_a_(soundHandler);
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.field_230694_p_) {
            int iconIndex = this.getIconIndex();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(TEXTURE_STATES);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.halfSize) {
                this.field_230688_j_ = 8;
                this.field_230689_k_ = 8;
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                if (this.field_230693_o_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                if (!this.disableBackground) {
                    this.func_238474_b_(matrixStack, 0, 0, 240, 240, 16, 16);
                }
                this.func_238474_b_(matrixStack, 0, 0, uv_x * 16, uv_y * 16, 16, 16);
                RenderSystem.popMatrix();
            } else {
                if (this.field_230693_o_) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                }
                int uv_y = iconIndex / 16;
                int uv_x = iconIndex - uv_y * 16;
                if (!this.disableBackground) {
                    this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 240, 240, 16, 16);
                }
                this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, uv_x * 16, uv_y * 16, 16, 16);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }
    }

    protected abstract int getIconIndex();

    @Override
    public ITextComponent getTooltipMessage() {
        return this.func_230458_i_();
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.field_230694_p_;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

