/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.overlay;

import appeng.client.render.overlay.IOverlayDataSource;
import appeng.client.render.overlay.OverlayRenderType;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Set;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;

public class OverlayRenderer {
    private IOverlayDataSource source;

    OverlayRenderer(IOverlayDataSource source) {
        this.source = source;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        RenderType typeFaces = OverlayRenderType.getBlockHilightFace();
        this.render(matrixStack, buffer.getBuffer(typeFaces), false);
        OverlayRenderType.finishBuffer(buffer, typeFaces);
        RenderType typeLines = OverlayRenderType.getBlockHilightLine();
        this.render(matrixStack, buffer.getBuffer(typeLines), true);
        OverlayRenderType.finishBuffer(buffer, typeLines);
    }

    private void render(MatrixStack matrixStack, IVertexBuilder builder, boolean renderLines) {
        int[] cols = OverlayRenderType.decomposeColor(this.source.getOverlayColor());
        for (ChunkPos pos : this.source.getOverlayChunks()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)pos.func_180334_c(), 0.0, (double)pos.func_180333_d());
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            this.addVertices(builder, posMat, pos, cols, renderLines);
            matrixStack.func_227865_b_();
        }
    }

    private void addVertices(IVertexBuilder wr, Matrix4f posMat, ChunkPos pos, int[] cols, boolean renderLines) {
        boolean noEast;
        Set<ChunkPos> chunks = this.source.getOverlayChunks();
        float x1 = 0.0f;
        float x2 = 16.0f;
        float y1 = 0.0f;
        float y2 = 256.0f;
        float z1 = 0.0f;
        float z2 = 16.0f;
        boolean noNorth = !chunks.contains(new ChunkPos(pos.field_77276_a, pos.field_77275_b - 1));
        boolean noSouth = !chunks.contains(new ChunkPos(pos.field_77276_a, pos.field_77275_b + 1));
        boolean noWest = !chunks.contains(new ChunkPos(pos.field_77276_a - 1, pos.field_77275_b));
        boolean bl = noEast = !chunks.contains(new ChunkPos(pos.field_77276_a + 1, pos.field_77275_b));
        if (noNorth) {
            wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
        if (noSouth) {
            wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
        if (noWest) {
            wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
        if (noEast) {
            wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
        if (renderLines) {
            if (noNorth || noWest) {
                wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            }
            if (noNorth || noEast) {
                wr.func_227888_a_(posMat, x2, y2, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            }
            if (noSouth || noEast) {
                wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x2, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            }
            if (noSouth || noWest) {
                wr.func_227888_a_(posMat, x1, y2, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
                wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            }
        } else {
            wr.func_227888_a_(posMat, x1, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y1, z1).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x2, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
            wr.func_227888_a_(posMat, x1, y1, z2).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_181675_d();
        }
    }
}

