/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.Platform;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public final class ContainerHelper<C extends AEBaseContainer, I> {
    private final Class<I> interfaceClass;
    private final ContainerFactory<C, I> factory;
    private final SecurityPermissions requiredPermission;
    private Function<I, ITextComponent> containerTitleStrategy = this::getDefaultContainerTitle;

    public ContainerHelper(ContainerFactory<C, I> factory, Class<I> interfaceClass) {
        this(factory, interfaceClass, null);
    }

    public ContainerHelper(ContainerFactory<C, I> factory, Class<I> interfaceClass, SecurityPermissions requiredPermission) {
        this.requiredPermission = requiredPermission;
        this.interfaceClass = interfaceClass;
        this.factory = factory;
    }

    public ContainerHelper<C, I> withContainerTitle(Function<I, ITextComponent> containerTitleStrategy) {
        this.containerTitleStrategy = containerTitleStrategy;
        return this;
    }

    public C fromNetwork(int windowId, PlayerInventory inv, PacketBuffer packetBuf) {
        return (C)((Object)this.fromNetwork(windowId, inv, packetBuf, (accessObj, container, buffer) -> {}));
    }

    public C fromNetwork(int windowId, PlayerInventory inv, PacketBuffer packetBuf, InitialDataDeserializer<C, I> initialDataDeserializer) {
        I host = this.getHostFromLocator(inv.field_70458_d, ContainerLocator.read(packetBuf));
        if (host != null) {
            AEBaseContainer container = (AEBaseContainer)((Object)this.factory.create(windowId, inv, host));
            initialDataDeserializer.deserializeInitialData(host, container, packetBuf);
            return (C)((Object)container);
        }
        return null;
    }

    public boolean open(PlayerEntity player, ContainerLocator locator) {
        return this.open(player, locator, (accessObj, buffer) -> {});
    }

    public boolean open(PlayerEntity player, ContainerLocator locator, InitialDataSerializer<I> initialDataSerializer) {
        if (!(player instanceof ServerPlayerEntity)) {
            return false;
        }
        Object accessInterface = this.getHostFromLocator(player, locator);
        if (accessInterface == null) {
            return false;
        }
        if (!this.checkPermission(player, accessInterface)) {
            return false;
        }
        ITextComponent title = this.containerTitleStrategy.apply(accessInterface);
        SimpleNamedContainerProvider container = new SimpleNamedContainerProvider((wnd, p, pl) -> {
            AEBaseContainer c = (AEBaseContainer)((Object)((Object)this.factory.create(wnd, p, accessInterface)));
            c.setLocator(locator);
            return c;
        }, title);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)container, buffer -> {
            locator.write((PacketBuffer)buffer);
            initialDataSerializer.serializeInitialData(accessInterface, (PacketBuffer)buffer);
        });
        return true;
    }

    private I getHostFromLocator(PlayerEntity player, ContainerLocator locator) {
        if (locator.hasItemIndex()) {
            return this.getHostFromPlayerInventory(player, locator);
        }
        if (!locator.hasBlockPos()) {
            return null;
        }
        TileEntity tileEntity = player.field_70170_p.func_175625_s(locator.getBlockPos());
        if (this.interfaceClass.isInstance(tileEntity)) {
            return this.interfaceClass.cast(tileEntity);
        }
        if (!locator.hasSide()) {
            return null;
        }
        if (tileEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)tileEntity;
            IPart part = partHost.getPart(locator.getSide());
            if (part == null) {
                return null;
            }
            if (this.interfaceClass.isInstance(part)) {
                return this.interfaceClass.cast(part);
            }
            AELog.debug("Trying to open a container @ %s for a %s, but the container requires %s", locator, part.getClass(), this.interfaceClass);
            return null;
        }
        return null;
    }

    private I getHostFromPlayerInventory(PlayerEntity player, ContainerLocator locator) {
        IWirelessTermHandler wh;
        ItemStack it = player.field_71071_by.func_70301_a(locator.getItemIndex());
        if (it.func_190926_b()) {
            AELog.debug("Cannot open container for player %s since they no longer hold the item in slot %d", player, locator.hasItemIndex());
            return null;
        }
        if (it.func_77973_b() instanceof IGuiItem) {
            IGuiItem guiItem = (IGuiItem)it.func_77973_b();
            BlockPos blockPos = locator.hasBlockPos() ? locator.getBlockPos() : null;
            IGuiItemObject guiObject = guiItem.getGuiObject(it, locator.getItemIndex(), player.field_70170_p, blockPos);
            if (this.interfaceClass.isInstance(guiObject)) {
                return this.interfaceClass.cast(guiObject);
            }
        }
        if (this.interfaceClass.isAssignableFrom(WirelessTerminalGuiObject.class) && (wh = Api.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return this.interfaceClass.cast(new WirelessTerminalGuiObject(wh, it, player, locator.getItemIndex()));
        }
        return null;
    }

    private boolean checkPermission(PlayerEntity player, Object accessInterface) {
        if (this.requiredPermission != null) {
            return Platform.checkPermissions(player, accessInterface, this.requiredPermission, true);
        }
        return true;
    }

    private ITextComponent getDefaultContainerTitle(I accessInterface) {
        ICustomNameObject customNameObject;
        if (accessInterface instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)accessInterface).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        return StringTextComponent.field_240750_d_;
    }

    @FunctionalInterface
    public static interface InitialDataDeserializer<C, I> {
        public void deserializeInitialData(I var1, C var2, PacketBuffer var3);
    }

    @FunctionalInterface
    public static interface InitialDataSerializer<I> {
        public void serializeInitialData(I var1, PacketBuffer var2);
    }

    @FunctionalInterface
    public static interface ContainerFactory<C, I> {
        public C create(int var1, PlayerInventory var2, I var3);
    }
}

