/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.INetworkEncodable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.SecurityStationTileEntity;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class SecurityStationContainer
extends MEMonitorableContainer
implements IAEAppEngInventory {
    public static ContainerType<SecurityStationContainer> TYPE;
    private static final ContainerHelper<SecurityStationContainer, ITerminalHost> helper;
    private final RestrictedInputSlot configSlot;
    private final AppEngInternalInventory wirelessEncoder = new AppEngInternalInventory(this, 2);
    private final RestrictedInputSlot wirelessIn;
    private final OutputSlot wirelessOut;
    private final SecurityStationTileEntity securityBox;
    @GuiSync(value=0)
    public int permissionMode = 0;

    public SecurityStationContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        this.securityBox = (SecurityStationTileEntity)monitorable;
        this.configSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BIOMETRIC_CARD, (IItemHandler)this.securityBox.getConfigSlot(), 0, 37, -33, ip);
        this.func_75146_a(this.configSlot);
        this.wirelessIn = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODABLE_ITEM, (IItemHandler)this.wirelessEncoder, 0, 212, 10, ip);
        this.func_75146_a(this.wirelessIn);
        this.wirelessOut = new OutputSlot((IItemHandler)this.wirelessEncoder, 1, 212, 68, -1);
        this.func_75146_a(this.wirelessOut);
        this.bindPlayerInventory(ip, 0, 0);
    }

    public static SecurityStationContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public void toggleSetting(String value, PlayerEntity player) {
        try {
            SecurityPermissions permission = SecurityPermissions.valueOf(value);
            ItemStack a = this.configSlot.func_75211_c();
            if (!a.func_190926_b() && a.func_77973_b() instanceof IBiometricCard) {
                IBiometricCard bc = (IBiometricCard)a.func_77973_b();
                if (bc.hasPermission(a, permission)) {
                    bc.removePermission(a, permission);
                } else {
                    bc.addPermission(a, permission);
                }
            }
        }
        catch (EnumConstantNotPresentException enumConstantNotPresentException) {
            // empty catch block
        }
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.SECURITY, false);
        this.setPermissionMode(0);
        ItemStack a = this.configSlot.func_75211_c();
        if (!a.func_190926_b() && a.func_77973_b() instanceof IBiometricCard) {
            IBiometricCard bc = (IBiometricCard)a.func_77973_b();
            for (SecurityPermissions sp : bc.getPermissions(a)) {
                this.setPermissionMode(this.getPermissionMode() | 1 << sp.ordinal());
            }
        }
        this.updatePowerStatus();
        super.func_75142_b();
    }

    @Override
    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this.wirelessIn.func_75216_d()) {
            player.func_71019_a(this.wirelessIn.func_75211_c(), false);
        }
        if (this.wirelessOut.func_75216_d()) {
            player.func_71019_a(this.wirelessOut.func_75211_c(), false);
        }
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (!this.wirelessOut.func_75216_d() && this.wirelessIn.func_75216_d()) {
            IWirelessTermHandler wTermHandler;
            ItemStack term = this.wirelessIn.func_75211_c().func_77946_l();
            INetworkEncodable networkEncodable = null;
            if (term.func_77973_b() instanceof INetworkEncodable) {
                networkEncodable = (INetworkEncodable)term.func_77973_b();
            }
            if ((wTermHandler = Api.instance().registries().wireless().getWirelessTerminalHandler(term)) != null) {
                networkEncodable = wTermHandler;
            }
            if (networkEncodable != null) {
                networkEncodable.setEncryptionKey(term, String.valueOf(this.securityBox.getSecurityKey()), "");
                this.wirelessIn.func_75215_d(ItemStack.field_190927_a);
                this.wirelessOut.func_75215_d(term);
                for (IContainerListener listener : this.field_75149_d) {
                    listener.func_71111_a((Container)this, this.wirelessIn.field_75222_d, this.wirelessIn.func_75211_c());
                    listener.func_71111_a((Container)this, this.wirelessOut.field_75222_d, this.wirelessOut.func_75211_c());
                }
            }
        }
    }

    public int getPermissionMode() {
        return this.permissionMode;
    }

    private void setPermissionMode(int permissionMode) {
        this.permissionMode = permissionMode;
    }

    static {
        helper = new ContainerHelper<SecurityStationContainer, ITerminalHost>(SecurityStationContainer::new, ITerminalHost.class, SecurityPermissions.SECURITY);
    }
}

