/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.me.GridAccessException;
import appeng.me.cache.StatisticsCache;
import appeng.tile.spatial.SpatialAnchorTileEntity;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SpatialAnchorContainer
extends AEBaseContainer {
    public static ContainerType<SpatialAnchorContainer> TYPE;
    private static final ContainerHelper<SpatialAnchorContainer, SpatialAnchorTileEntity> helper;
    private static final int UPDATE_DELAY = 20;
    private IGrid network;
    private int delay = 20;
    @GuiSync(value=0)
    public long powerConsumption;
    @GuiSync(value=1)
    public int loadedChunks;
    @GuiSync(value=2)
    public YesNo overlayMode = YesNo.NO;
    @GuiSync(value=10)
    public int allLoadedWorlds;
    @GuiSync(value=11)
    public int allLoadedChunks;
    @GuiSync(value=20)
    public int allWorlds;
    @GuiSync(value=21)
    public int allChunks;

    public SpatialAnchorContainer(int id, PlayerInventory ip, SpatialAnchorTileEntity spatialAnchor) {
        super(TYPE, id, ip, spatialAnchor, null);
        if (this.isServer()) {
            this.network = spatialAnchor.getGridNode(AEPartLocation.INTERNAL).getGrid();
        }
    }

    public static SpatialAnchorContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.isServer()) {
            SpatialAnchorTileEntity anchor = (SpatialAnchorTileEntity)this.getTileEntity();
            this.setOverlayMode((YesNo)anchor.getConfigManager().getSetting(Settings.OVERLAY_MODE));
            ++this.delay;
            if (this.delay > 20 && this.network != null) {
                StatisticsCache statistics = (StatisticsCache)this.network.getCache(StatisticsCache.class);
                this.powerConsumption = (long)anchor.getProxy().getIdlePowerUsage();
                this.loadedChunks = ((SpatialAnchorTileEntity)this.getTileEntity()).countLoadedChunks();
                try {
                    HashMap<World, Integer> stats = new HashMap<World, Integer>();
                    IMachineSet anchors = anchor.getProxy().getGrid().getMachines(SpatialAnchorTileEntity.class);
                    for (IGridNode machine : anchors) {
                        SpatialAnchorTileEntity a = (SpatialAnchorTileEntity)machine.getMachine();
                        World world = machine.getGridBlock().getLocation().getWorld();
                        stats.merge(world, a.countLoadedChunks(), (left, right) -> Math.max(left, right));
                    }
                    this.allLoadedChunks = stats.values().stream().reduce((left, right) -> left + right).orElse(0);
                    this.allLoadedWorlds = stats.keySet().size();
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
                this.allWorlds = statistics.getChunks().size();
                this.allChunks = 0;
                for (Map.Entry<IWorld, Multiset<ChunkPos>> entry : statistics.getChunks().entrySet()) {
                    this.allChunks += entry.getValue().elementSet().size();
                }
                this.delay = 0;
            }
        }
        super.func_75142_b();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setOverlayMode((YesNo)cm.getSetting(Settings.OVERLAY_MODE));
    }

    public YesNo getOverlayMode() {
        return this.overlayMode;
    }

    public void setOverlayMode(YesNo mode) {
        this.overlayMode = mode;
    }

    static {
        helper = new ContainerHelper<SpatialAnchorContainer, SpatialAnchorTileEntity>(SpatialAnchorContainer::new, SpatialAnchorTileEntity.class, SecurityPermissions.BUILD);
    }
}

