/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.container.AEBaseContainer;
import appeng.util.helpers.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class AppEngSlot
extends Slot {
    private static final IInventory EMPTY_INVENTORY = new Inventory(0);
    private final IItemHandler itemHandler;
    private final int invSlot;
    private final int defX;
    private final int defY;
    private boolean isDraggable = true;
    private boolean isPlayerSide = false;
    private AEBaseContainer myContainer = null;
    private int IIcon = -1;
    private CalculatedValidity isValid;
    private boolean isDisplay = false;

    public AppEngSlot(IItemHandler inv, int invSlot, int x, int y) {
        super(EMPTY_INVENTORY, invSlot, x, y);
        this.itemHandler = inv;
        this.invSlot = invSlot;
        this.defX = x;
        this.defY = y;
        this.setIsValid(CalculatedValidity.NotAvailable);
    }

    public Slot setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public Slot setPlayerSide() {
        this.isPlayerSide = true;
        return this;
    }

    public String getTooltip() {
        return null;
    }

    public void clearStack() {
        ItemHandlerUtil.setStackInSlot(this.itemHandler, this.invSlot, ItemStack.field_190927_a);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        if (this.isSlotEnabled()) {
            return this.itemHandler.isItemValid(this.invSlot, stack);
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        if (!this.isSlotEnabled()) {
            return ItemStack.field_190927_a;
        }
        if (this.itemHandler.getSlots() <= this.getSlotIndex()) {
            return ItemStack.field_190927_a;
        }
        if (this.isDisplay()) {
            this.setDisplay(false);
            return this.getDisplayStack();
        }
        return this.itemHandler.getStackInSlot(this.invSlot);
    }

    public void func_75215_d(ItemStack stack) {
        if (this.isSlotEnabled()) {
            ItemHandlerUtil.setStackInSlot(this.itemHandler, this.invSlot, stack);
            this.func_75218_e();
        }
    }

    private void notifyContainerSlotChanged() {
        if (this.getContainer() != null) {
            this.getContainer().onSlotChange(this);
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.setIsValid(CalculatedValidity.NotAvailable);
        this.notifyContainerSlotChanged();
    }

    public int func_75219_a() {
        return this.itemHandler.getSlotLimit(this.invSlot);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return Math.min(this.func_75219_a(), stack.func_77976_d());
    }

    public boolean func_82869_a(PlayerEntity player) {
        if (this.isSlotEnabled()) {
            return !this.itemHandler.extractItem(this.invSlot, 1, true).func_190926_b();
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.itemHandler.extractItem(this.invSlot, amount, false);
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof AppEngSlot && ((AppEngSlot)other).itemHandler == this.itemHandler;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_111238_b() {
        return this.isSlotEnabled();
    }

    public boolean isSlotEnabled() {
        return true;
    }

    public ItemStack getDisplayStack() {
        return this.itemHandler.getStackInSlot(this.invSlot);
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public int getIcon() {
        return this.getIIcon();
    }

    public boolean isPlayerSide() {
        return this.isPlayerSide;
    }

    public boolean shouldDisplay() {
        return this.isSlotEnabled();
    }

    public int getX() {
        return this.defX;
    }

    public int getY() {
        return this.defY;
    }

    private int getIIcon() {
        return this.IIcon;
    }

    public void setIIcon(int iIcon) {
        this.IIcon = iIcon;
    }

    private boolean isDisplay() {
        return this.isDisplay;
    }

    public void setDisplay(boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    void setPlayerSide(boolean isPlayerSide) {
        this.isPlayerSide = isPlayerSide;
    }

    public CalculatedValidity getIsValid() {
        return this.isValid;
    }

    public void setIsValid(CalculatedValidity isValid) {
        this.isValid = isValid;
    }

    protected AEBaseContainer getContainer() {
        return this.myContainer;
    }

    public void setContainer(AEBaseContainer myContainer) {
        this.myContainer = myContainer;
    }

    protected boolean isRemote() {
        return this.myContainer == null || this.myContainer.isRemote();
    }

    public static enum CalculatedValidity {
        NotAvailable,
        Valid,
        Invalid;

    }
}

