/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.slot;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.core.Api;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CraftingTermSlot
extends AppEngCraftingSlot {
    private final IItemHandler craftInv;
    private final IItemHandler pattern;
    private final IActionSource mySrc;
    private final IEnergySource energySrc;
    private final IStorageMonitorable storage;
    private final IContainerCraftingPacket container;

    public CraftingTermSlot(PlayerEntity player, IActionSource mySrc, IEnergySource energySrc, IStorageMonitorable storage, IItemHandler cMatrix, IItemHandler secondMatrix, IItemHandler output, int x, int y, IContainerCraftingPacket ccp) {
        super(player, cMatrix, output, 0, x, y);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.container = ccp;
    }

    public IItemHandler getCraftingMatrix() {
        return this.craftInv;
    }

    @Override
    public boolean func_82869_a(PlayerEntity player) {
        return false;
    }

    @Override
    public ItemStack func_190901_a(PlayerEntity p, ItemStack is) {
        return is;
    }

    public void doClick(InventoryAction action, PlayerEntity who) {
        if (this.func_75211_c().func_190926_b()) {
            return;
        }
        if (this.isRemote()) {
            return;
        }
        IMEMonitor<IAEItemStack> inv = this.storage.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        int howManyPerCraft = this.func_75211_c().func_190916_E();
        int maxTimesToCraft = 0;
        InventoryAdaptor ia = null;
        if (action == InventoryAction.CRAFT_SHIFT) {
            ia = InventoryAdaptor.getAdaptor(who);
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else if (action == InventoryAction.CRAFT_STACK) {
            ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(who.field_71071_by));
            maxTimesToCraft = (int)Math.floor((double)this.func_75211_c().func_77976_d() / (double)howManyPerCraft);
        } else {
            ia = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(who.field_71071_by));
            maxTimesToCraft = 1;
        }
        maxTimesToCraft = this.capCraftingAttempts(maxTimesToCraft);
        if (ia == null) {
            return;
        }
        ItemStack rs = this.func_75211_c().func_77946_l();
        if (rs.func_190926_b()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            IItemList<IAEItemStack> all;
            ItemStack extra;
            if (!ia.simulateAdd(rs).func_190926_b() || (extra = ia.addItems(this.craftItem(who, rs, inv, all = inv.getStorageList()))).func_190926_b()) continue;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(extra);
            Platform.spawnDrops(who.field_70170_p, new BlockPos((int)who.func_226277_ct_(), (int)who.func_226278_cu_(), (int)who.func_226281_cx_()), drops);
            return;
        }
    }

    protected IRecipe<CraftingInventory> findRecipe(CraftingInventory ic, World world) {
        CraftingTermContainer containerTerminal;
        IRecipe<CraftingInventory> recipe;
        if (this.container instanceof CraftingTermContainer && (recipe = (containerTerminal = (CraftingTermContainer)this.container).getCurrentRecipe()) != null && recipe.func_77569_a((IInventory)ic, world)) {
            return containerTerminal.getCurrentRecipe();
        }
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, world).orElse(null);
    }

    @Override
    protected NonNullList<ItemStack> getRemainingItems(CraftingInventory ic, World world) {
        CraftingTermContainer containerTerminal;
        IRecipe<CraftingInventory> recipe;
        if (this.container instanceof CraftingTermContainer && (recipe = (containerTerminal = (CraftingTermContainer)this.container).getCurrentRecipe()) != null && recipe.func_77569_a((IInventory)ic, world)) {
            return containerTerminal.getCurrentRecipe().func_179532_b((IInventory)ic);
        }
        return super.getRemainingItems(ic, world);
    }

    private int capCraftingAttempts(int maxTimesToCraft) {
        return maxTimesToCraft;
    }

    private ItemStack craftItem(PlayerEntity p, ItemStack request, IMEMonitor<IAEItemStack> inv, IItemList all) {
        ItemStack is = this.func_75211_c();
        if (!is.func_190926_b() && ItemStack.func_179545_c((ItemStack)request, (ItemStack)is)) {
            Object[] set = new ItemStack[this.getPattern().getSlots()];
            Arrays.fill(set, ItemStack.field_190927_a);
            World world = p.field_70170_p;
            if (!world.func_201670_d()) {
                CraftingInventory ic = new CraftingInventory((Container)new ContainerNull(), 3, 3);
                for (int x = 0; x < 9; ++x) {
                    ic.func_70299_a(x, this.getPattern().getStackInSlot(x));
                }
                IRecipe<CraftingInventory> r = this.findRecipe(ic, world);
                if (r == null) {
                    Item target = request.func_77973_b();
                    if (target.func_77645_m() && target.isRepairable(request)) {
                        boolean isBad = false;
                        for (int x = 0; x < ic.func_70302_i_(); ++x) {
                            ItemStack pis = ic.func_70301_a(x);
                            if (pis.func_190926_b() || pis.func_77973_b() == target) continue;
                            isBad = true;
                        }
                        if (!isBad) {
                            super.func_190901_a(p, is);
                            p.field_71070_bA.func_75130_a((IInventory)new WrapperInvItemHandler(this.craftInv));
                            return request;
                        }
                    }
                    return ItemStack.field_190927_a;
                }
                is = r.func_77572_b((IInventory)ic);
                if (inv != null) {
                    for (int x = 0; x < this.getPattern().getSlots(); ++x) {
                        if (this.getPattern().getStackInSlot(x).func_190926_b()) continue;
                        set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, world, r, is, ic, this.getPattern().getStackInSlot(x), x, all, Actionable.MODULATE, ViewCellItem.createFilter(this.container.getViewCells()));
                        ic.func_70299_a(x, (ItemStack)set[x]);
                    }
                }
            }
            if (this.preCraft(p, inv, (ItemStack[])set, is)) {
                this.makeItem(p, is);
                this.postCraft(p, inv, (ItemStack[])set, is);
            }
            p.field_71070_bA.func_75130_a((IInventory)new WrapperInvItemHandler(this.craftInv));
            return is;
        }
        return ItemStack.field_190927_a;
    }

    private boolean preCraft(PlayerEntity p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        return true;
    }

    private void makeItem(PlayerEntity p, ItemStack is) {
        super.func_190901_a(p, is);
    }

    private void postCraft(PlayerEntity p, IMEMonitor<IAEItemStack> inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!p.func_130014_f_().func_201670_d()) {
            for (int x = 0; x < this.craftInv.getSlots(); ++x) {
                IAEItemStack fail;
                if (this.craftInv.getStackInSlot(x).func_190926_b()) {
                    ItemHandlerUtil.setStackInSlot(this.craftInv, x, set[x]);
                    continue;
                }
                if (set[x].func_190926_b() || (fail = inv.injectItems(AEItemStack.fromItemStack(set[x]), Actionable.MODULATE, this.mySrc)) == null) continue;
                drops.add(fail.createItemStack());
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.field_70170_p, new BlockPos((int)p.func_226277_ct_(), (int)p.func_226278_cu_(), (int)p.func_226281_cx_()), drops);
        }
    }

    IItemHandler getPattern() {
        return this.pattern;
    }
}

