/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.security.IActionHost;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.CraftAmountContainer;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Future;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class CraftRequestPacket
extends BasePacket {
    private final long amount;
    private final boolean heldShift;

    public CraftRequestPacket(PacketBuffer stream) {
        this.heldShift = stream.readBoolean();
        this.amount = stream.readLong();
    }

    public CraftRequestPacket(int craftAmt, boolean shift) {
        this.amount = craftAmt;
        this.heldShift = shift;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        data.writeLong(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        CraftAmountContainer cca;
        Object target;
        if (player.field_71070_bA instanceof CraftAmountContainer && (target = (cca = (CraftAmountContainer)player.field_71070_bA).getTarget()) instanceof IActionHost) {
            IActionHost ah = (IActionHost)target;
            IGridNode gn = ah.getActionableNode();
            if (gn == null) {
                return;
            }
            IGrid g = gn.getGrid();
            if (g == null || cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future<ICraftingJob> futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                ContainerLocator locator = cca.getLocator();
                if (locator != null) {
                    ContainerOpener.openContainer(CraftConfirmContainer.TYPE, player, locator);
                    if (player.field_71070_bA instanceof CraftConfirmContainer) {
                        CraftConfirmContainer ccc = (CraftConfirmContainer)player.field_71070_bA;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.info(e);
            }
        }
    }
}

