/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.implementations.PatternTermContainer;
import appeng.core.Api;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperInvItemHandler;
import appeng.util.item.AEItemStack;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.IItemHandler;

public class JEIRecipePacket
extends BasePacket {
    private static final int INLINE_RECIPE_NONE = 1;
    private static final int INLINE_RECIPE_SHAPED = 2;
    private ResourceLocation recipeId;
    @Nullable
    private IRecipe<?> recipe;
    private boolean crafting;

    public JEIRecipePacket(PacketBuffer stream) {
        this.crafting = stream.readBoolean();
        String id = stream.func_150789_c(Short.MAX_VALUE);
        this.recipeId = new ResourceLocation(id);
        int inlineRecipeType = stream.func_150792_a();
        switch (inlineRecipeType) {
            case 1: {
                break;
            }
            case 2: {
                this.recipe = IRecipeSerializer.field_222157_a.func_199426_a_(this.recipeId, stream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid inline recipe type.");
            }
        }
    }

    public JEIRecipePacket(ResourceLocation recipeId, boolean crafting) {
        PacketBuffer data = this.createCommonHeader(recipeId, crafting, 1);
        this.configureWrite(data);
    }

    public JEIRecipePacket(ShapedRecipe recipe, boolean crafting) {
        PacketBuffer data = this.createCommonHeader(recipe.func_199560_c(), crafting, 2);
        IRecipeSerializer.field_222157_a.func_199427_a_(data, (IRecipe)recipe);
        this.configureWrite(data);
    }

    private PacketBuffer createCommonHeader(ResourceLocation recipeId, boolean crafting, int inlineRecipeType) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(crafting);
        data.func_192572_a(recipeId);
        data.func_150787_b(inlineRecipeType);
        return data;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        ServerPlayerEntity pmp = (ServerPlayerEntity)player;
        Container con = pmp.field_71070_bA;
        Preconditions.checkArgument((boolean)(con instanceof IContainerCraftingPacket));
        IRecipe<?> recipe = player.func_130014_f_().func_199532_z().func_215367_a(this.recipeId).orElse(null);
        if (recipe == null && this.recipe != null) {
            recipe = this.recipe;
        }
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0);
        IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
        IGridNode node = cct.getNetworkNode();
        Preconditions.checkArgument((node != null ? 1 : 0) != 0);
        IGrid grid = node.getGrid();
        Preconditions.checkArgument((grid != null ? 1 : 0) != 0);
        IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
        Preconditions.checkArgument((inv != null ? 1 : 0) != 0);
        ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        Preconditions.checkArgument((security != null ? 1 : 0) != 0);
        IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IItemHandler craftMatrix = cct.getInventoryByName("crafting");
        IItemHandler playerInventory = cct.getInventoryByName("player");
        IMEMonitor<IAEItemStack> storage = inv.getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        IPartitionList<IAEItemStack> filter = ViewCellItem.createFilter(cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.ensure3by3CraftingMatrix(recipe);
        for (int x = 0; x < craftMatrix.getSlots(); ++x) {
            ItemStack newItem;
            ItemStack currentItem = craftMatrix.getStackInSlot(x);
            Ingredient ingredient = (Ingredient)ingredients.get(x);
            if (!currentItem.func_190926_b() && (newItem = this.canUseInSlot(ingredient, currentItem)) != currentItem && security.hasPermission(player, SecurityPermissions.INJECT)) {
                AEItemStack in = AEItemStack.fromItemStack(currentItem);
                IAEItemStack out = cct.useRealItems() ? (IAEItemStack)Platform.poweredInsert(energy, storage, in, cct.getActionSource()) : null;
                currentItem = out != null ? out.createItemStack() : ItemStack.field_190927_a;
            }
            if (currentItem.func_190926_b() && security.hasPermission(player, SecurityPermissions.EXTRACT)) {
                IAEItemStack out;
                if (cct.useRealItems()) {
                    IAEItemStack request = this.findBestMatchingItemStack(ingredient, filter, storage, cct);
                    out = request != null ? Platform.poweredExtraction(energy, storage, request.setStackSize(1L), cct.getActionSource()) : null;
                } else {
                    out = this.findBestMatchingPattern(ingredient, filter, crafting, storage, cct);
                    if (out == null) {
                        out = this.findBestMatchingItemStack(ingredient, filter, storage, cct);
                    }
                    if (out == null && ingredient.func_193365_a().length > 0) {
                        out = AEItemStack.fromItemStack(ingredient.func_193365_a()[0]);
                    }
                }
                if (out != null) {
                    currentItem = out.createItemStack();
                }
            }
            if (currentItem.func_190926_b()) {
                ItemStack[] matchingStacks;
                for (ItemStack matchingStack : matchingStacks = ingredient.func_193365_a()) {
                    if (!currentItem.func_190926_b()) continue;
                    AdaptorItemHandler ad = new AdaptorItemHandler(playerInventory);
                    currentItem = cct.useRealItems() ? ad.removeItems(1, matchingStack, null) : ad.simulateRemove(1, matchingStack, null);
                }
            }
            ItemHandlerUtil.setStackInSlot(craftMatrix, x, currentItem);
        }
        if (!this.crafting) {
            this.handleProcessing(con, cct, recipe);
        }
        con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
    }

    private NonNullList<Ingredient> ensure3by3CraftingMatrix(IRecipe<?> recipe) {
        NonNullList ingredients = recipe.func_192400_c();
        NonNullList expandedIngredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            int width = shapedRecipe.getRecipeWidth();
            int height = shapedRecipe.getRecipeHeight();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    expandedIngredients.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, ingredients.get(i));
            }
        }
        return expandedIngredients;
    }

    private ItemStack canUseInSlot(Ingredient ingredient, ItemStack is) {
        return Arrays.stream(ingredient.func_193365_a()).filter(p -> p.func_77969_a(is)).findFirst().orElse(ItemStack.field_190927_a);
    }

    private IAEItemStack findBestMatchingItemStack(Ingredient ingredients, IPartitionList<IAEItemStack> filter, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        Stream<AEItemStack> stacks = Arrays.stream(ingredients.func_193365_a()).map(AEItemStack::fromItemStack).filter(r -> r != null && (filter == null || filter.isListed((IAEItemStack)r)));
        return JEIRecipePacket.getMostStored(stacks, storage, cct);
    }

    private IAEItemStack findBestMatchingPattern(Ingredient ingredients, IPartitionList<IAEItemStack> filter, ICraftingGrid crafting, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        Stream<IAEItemStack> stacks = Arrays.stream(ingredients.func_193365_a()).map(AEItemStack::fromItemStack).filter(r -> r != null && (filter == null || filter.isListed((IAEItemStack)r))).map(s -> (IAEItemStack)s.setCraftable(!crafting.getCraftingFor((IAEItemStack)s, null, 0, null).isEmpty())).filter(IAEStack::isCraftable);
        return JEIRecipePacket.getMostStored(stacks, storage, cct);
    }

    private static IAEItemStack getMostStored(Stream<? extends IAEItemStack> stacks, IMEMonitor<IAEItemStack> storage, IContainerCraftingPacket cct) {
        return stacks.map(s -> {
            IAEItemStack stored = (IAEItemStack)storage.extractItems((IAEItemStack)s.copy().setStackSize(Long.MAX_VALUE), Actionable.SIMULATE, cct.getActionSource());
            return Pair.of((Object)s, (Object)(stored != null ? stored.getStackSize() : 0L));
        }).min((left, right) -> Long.compare((Long)right.getSecond(), (Long)left.getSecond())).map(Pair::getFirst).orElse(null);
    }

    private void handleProcessing(Container con, IContainerCraftingPacket cct, IRecipe<?> recipe) {
        if (con instanceof PatternTermContainer) {
            PatternTermContainer patternTerm = (PatternTermContainer)con;
            if (!patternTerm.craftingMode) {
                IItemHandler output = cct.getInventoryByName("output");
                ItemHandlerUtil.setStackInSlot(output, 0, recipe.func_77571_b());
                ItemHandlerUtil.setStackInSlot(output, 1, ItemStack.field_190927_a);
                ItemHandlerUtil.setStackInSlot(output, 2, ItemStack.field_190927_a);
            }
        }
    }
}

