/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventoryHandler;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.CableBusBlock;
import appeng.block.paint.PaintSplotchesBlock;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.BlockRecolorer;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.BaseActionSource;
import appeng.tile.misc.PaintSplotchesTileEntity;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SnowballItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class ColorApplicatorItem
extends AEBasePoweredItem
implements IStorageCell<IAEItemStack>,
IBlockTool,
IMouseWheelItem {
    private static final Map<ResourceLocation, AEColor> TAG_TO_COLOR = ImmutableMap.builder().put((Object)new ResourceLocation("forge:dyes/black"), (Object)AEColor.BLACK).put((Object)new ResourceLocation("forge:dyes/blue"), (Object)AEColor.BLUE).put((Object)new ResourceLocation("forge:dyes/brown"), (Object)AEColor.BROWN).put((Object)new ResourceLocation("forge:dyes/cyan"), (Object)AEColor.CYAN).put((Object)new ResourceLocation("forge:dyes/gray"), (Object)AEColor.GRAY).put((Object)new ResourceLocation("forge:dyes/green"), (Object)AEColor.GREEN).put((Object)new ResourceLocation("forge:dyes/light_blue"), (Object)AEColor.LIGHT_BLUE).put((Object)new ResourceLocation("forge:dyes/light_gray"), (Object)AEColor.LIGHT_GRAY).put((Object)new ResourceLocation("forge:dyes/lime"), (Object)AEColor.LIME).put((Object)new ResourceLocation("forge:dyes/magenta"), (Object)AEColor.MAGENTA).put((Object)new ResourceLocation("forge:dyes/orange"), (Object)AEColor.ORANGE).put((Object)new ResourceLocation("forge:dyes/pink"), (Object)AEColor.PINK).put((Object)new ResourceLocation("forge:dyes/purple"), (Object)AEColor.PURPLE).put((Object)new ResourceLocation("forge:dyes/red"), (Object)AEColor.RED).put((Object)new ResourceLocation("forge:dyes/white"), (Object)AEColor.WHITE).put((Object)new ResourceLocation("forge:dyes/yellow"), (Object)AEColor.YELLOW).build();
    private static final String TAG_COLOR = "color";

    public ColorApplicatorItem(Item.Properties props) {
        super(AEConfig.instance().getColorApplicatorBattery(), props);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World w = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack is = context.func_195996_i();
        Direction side = context.func_196000_l();
        PlayerEntity p = context.func_195999_j();
        if (p == null && w instanceof ServerWorld) {
            p = Platform.getPlayer((ServerWorld)w);
        }
        Block blk = w.func_180495_p(pos).func_177230_c();
        ItemStack paintBall = this.getColor(is);
        ICellInventoryHandler<IAEItemStack> inv = Api.instance().registries().cell().getCellInventory(is, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        if (inv != null) {
            AEColor color;
            IAEItemStack option = inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.createItemStack();
                paintBall.func_190920_e(1);
            } else {
                paintBall = ItemStack.field_190927_a;
            }
            if (p != null && !Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
                return ActionResultType.FAIL;
            }
            double powerPerUse = 100.0;
            if (!paintBall.func_190926_b() && paintBall.func_77973_b() instanceof SnowballItem) {
                TileEntity te = w.func_175625_s(pos);
                if (te instanceof IColorableTile && p != null && this.getAECurrentPower(is) > 100.0 && ((IColorableTile)te).getColor() != AEColor.TRANSPARENT && ((IColorableTile)te).recolourBlock(side, AEColor.TRANSPARENT, p)) {
                    inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0, Actionable.MODULATE);
                    return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
                }
                Block testBlk = w.func_180495_p(pos.func_177972_a(side)).func_177230_c();
                TileEntity painted = w.func_175625_s(pos.func_177972_a(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof PaintSplotchesBlock && painted instanceof PaintSplotchesTileEntity) {
                    inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0, Actionable.MODULATE);
                    ((PaintSplotchesTileEntity)painted).cleanSide(side.func_176734_d());
                    return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
                }
            } else if (!paintBall.func_190926_b() && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, w, pos, color, p)) {
                inv.extractItems(AEItemStack.fromItemStack(paintBall), Actionable.MODULATE, new BaseActionSource());
                this.extractAEPower(is, 100.0, Actionable.MODULATE);
                return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
            }
        }
        if (p != null && InteractionUtil.isInAlternateUseMode(p)) {
            this.cycleColors(is, paintBall, 1);
        }
        return ActionResultType.FAIL;
    }

    public ITextComponent func_200295_i(ItemStack is) {
        ITextComponent extra = GuiText.Empty.text();
        AEColor selected = this.getActiveColor(is);
        if (selected != null && Platform.isClient()) {
            extra = new TranslationTextComponent(selected.translationKey);
        }
        return super.func_200295_i(is).func_230532_e_().func_240702_b_(" - ").func_230529_a_(extra);
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        if (paintBall.func_190926_b()) {
            return null;
        }
        if (paintBall.func_77973_b() instanceof SnowballItem) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall.func_77973_b() instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)paintBall.func_77973_b();
            return ipb.getColor();
        }
        for (Map.Entry<ResourceLocation, AEColor> entry : TAG_TO_COLOR.entrySet()) {
            ITag tag = ItemTags.func_199903_a().func_199910_a(entry.getKey());
            if (tag == null || !paintBall.func_77973_b().func_206844_a(tag)) continue;
            return entry.getValue();
        }
        return null;
    }

    public ItemStack getColor(ItemStack is) {
        CompoundNBT color;
        ItemStack oldColor;
        CompoundNBT c = is.func_77978_p();
        if (c != null && c.func_74764_b(TAG_COLOR) && !(oldColor = ItemStack.func_199557_a((CompoundNBT)(color = c.func_74775_l(TAG_COLOR)))).func_190926_b()) {
            return oldColor;
        }
        return this.findNextColor(is, ItemStack.field_190927_a, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = ItemStack.field_190927_a;
        ICellInventoryHandler<IAEItemStack> inv = Api.instance().registries().cell().getCellInventory(is, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        if (inv != null) {
            IItemList itemList = inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList());
            if (anchor.func_190926_b()) {
                IAEItemStack firstItem = (IAEItemStack)itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.asItemStackRepresentation();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                if (list.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                list.sort(Comparator.comparingInt(a -> {
                    AEColor color = this.getColorFromItem(a.getDefinition());
                    return color != null ? color.ordinal() : Integer.MAX_VALUE;
                }));
                IAEItemStack where = (IAEItemStack)list.getFirst();
                AEColor anchorColor = this.getColorFromItem(anchor);
                for (int cycles = 1 + list.size(); cycles > 0 && this.getColorFromItem(where.getDefinition()) != anchorColor; --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).asItemStackRepresentation();
            }
        }
        if (!newColor.func_190926_b()) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        CompoundNBT data = is.func_196082_o();
        if (newColor.func_190926_b()) {
            data.func_82580_o(TAG_COLOR);
        } else {
            CompoundNBT color = new CompoundNBT();
            newColor.func_77955_b(color);
            data.func_218657_a(TAG_COLOR, (INBT)color);
        }
    }

    private boolean recolourBlock(Block blk, Direction side, World w, BlockPos pos, AEColor newColor, @Nullable PlayerEntity p) {
        BlockState state = w.func_180495_p(pos);
        Block recolored = BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            BlockState newState = recolored.func_176223_P();
            for (Property prop : newState.func_235904_r_()) {
                newState = ColorApplicatorItem.copyProp(state, newState, prop);
            }
            return w.func_175656_a(pos, newState);
        }
        if (blk instanceof CableBusBlock && p != null) {
            return ((CableBusBlock)blk).recolorBlock((IBlockReader)w, pos, side, newColor.dye, p);
        }
        TileEntity be = w.func_175625_s(pos);
        if (be instanceof IColorableTile) {
            IColorableTile ct = (IColorableTile)be;
            AEColor c = ct.getColor();
            if (c != newColor) {
                ct.recolourBlock(side, newColor, p);
                return true;
            }
            return false;
        }
        return false;
    }

    private static <T extends Comparable<T>> BlockState copyProp(BlockState oldState, BlockState newState, Property<T> prop) {
        if (newState.func_235901_b_(prop)) {
            return (BlockState)newState.func_206870_a(prop, oldState.func_177229_b(prop));
        }
        return newState;
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall.func_190926_b()) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        super.func_77624_a(stack, world, lines, advancedTooltips);
        ICellInventoryHandler<IAEItemStack> cdi = Api.instance().registries().cell().getCellInventory(stack, null, Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
        Api.instance().client().addCellInformation(cdi, lines);
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        if (requestedAddition != null) {
            return this.getColorFromItem(requestedAddition.getDefinition()) == null;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = is.func_196082_o().func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.func_196082_o().func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }
}

