/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.util.DimensionalCoord;
import appeng.block.misc.TinyTNTBlock;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntropyManipulatorItem
extends AEBasePoweredItem
implements IBlockTool {
    private static final int ENERGY_PER_USE = 1600;

    public EntropyManipulatorItem(Item.Properties props) {
        super(AEConfig.instance().getEntropyManipulatorBattery(), props);
    }

    public boolean func_77644_a(ItemStack item, LivingEntity target, LivingEntity hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            target.func_70015_d(8);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World w, PlayerEntity p, Hand hand) {
        BlockRayTraceResult target = EntropyManipulatorItem.func_219968_a((World)w, (PlayerEntity)p, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (target.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.FAIL, (Object)p.func_184586_b(hand));
        }
        BlockPos pos = target.func_216350_a();
        BlockState state = w.func_180495_p(pos);
        if (!state.func_204520_s().func_206888_e() && Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
            ItemUseContext context = new ItemUseContext(p, hand, target);
            this.func_195939_a(context);
        }
        return new ActionResult(ActionResultType.func_233537_a_((boolean)w.func_201670_d()), (Object)p.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockRayTraceResult target;
        World w = context.func_195991_k();
        ItemStack item = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        PlayerEntity p = context.func_195999_j();
        boolean tryBoth = false;
        if (p == null) {
            if (w.field_72995_K) {
                return ActionResultType.FAIL;
            }
            p = Platform.getPlayer((ServerWorld)w);
            tryBoth = true;
        }
        if ((target = EntropyManipulatorItem.func_219968_a((World)w, (PlayerEntity)p, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            pos = target.func_216350_a();
        }
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.func_175151_a(pos, side, item)) {
                return ActionResultType.FAIL;
            }
            if (!w.func_201670_d() && !this.tryApplyEffect(w, item, pos, side, p, tryBoth)) {
                return ActionResultType.FAIL;
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    private boolean tryApplyEffect(World w, ItemStack item, BlockPos pos, Direction side, PlayerEntity p, boolean tryBoth) {
        EntropyRecipe coolRecipe;
        BlockState blockState = w.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        FluidState fluidState = w.func_204610_c(pos);
        if ((tryBoth || InteractionUtil.isInAlternateUseMode(p)) && (coolRecipe = EntropyManipulatorItem.findRecipe(w, EntropyMode.COOL, blockState, fluidState)) != null) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            EntropyManipulatorItem.applyRecipe(coolRecipe, w, pos, blockState, fluidState);
            return true;
        }
        if (tryBoth || !InteractionUtil.isInAlternateUseMode(p)) {
            if (block instanceof TNTBlock) {
                w.func_217377_a(pos, false);
                block.catchFire(w.func_180495_p(pos), w, pos, side, (LivingEntity)p);
                return true;
            }
            if (block instanceof TinyTNTBlock) {
                w.func_217377_a(pos, false);
                ((TinyTNTBlock)block).startFuse(w, pos, (LivingEntity)p);
                return true;
            }
            EntropyRecipe heatRecipe = EntropyManipulatorItem.findRecipe(w, EntropyMode.HEAT, blockState, fluidState);
            if (heatRecipe != null) {
                this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                EntropyManipulatorItem.applyRecipe(heatRecipe, w, pos, blockState, fluidState);
                return true;
            }
            if (this.performInWorldSmelting(item, w, p, pos, block)) {
                return true;
            }
            if (this.applyFlintAndSteelEffect(w, item, pos, side, p)) {
                return true;
            }
        }
        return false;
    }

    private boolean applyFlintAndSteelEffect(World w, ItemStack item, BlockPos pos, Direction side, PlayerEntity p) {
        BlockPos offsetPos = pos.func_177972_a(side);
        if (!p.func_175151_a(offsetPos, side, item)) {
            return false;
        }
        if (w.func_175623_d(offsetPos)) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            w.func_184148_a(p, (double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.5, (double)offsetPos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            w.func_175656_a(offsetPos, Blocks.field_150480_ab.func_176223_P());
        }
        return true;
    }

    private boolean performInWorldSmelting(ItemStack item, World w, PlayerEntity p, BlockPos pos, Block block) {
        ItemStack[] stack = Platform.getBlockDrops(w, pos);
        BlockState smeltedBlockState = null;
        ArrayList<ItemStack> smeltedDrops = new ArrayList<ItemStack>();
        CraftingInventory tempInv = new CraftingInventory((Container)new ContainerNull(), 1, 1);
        for (ItemStack i : stack) {
            tempInv.func_70299_a(0, i);
            Optional recipe = w.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)tempInv, w);
            if (!recipe.isPresent()) {
                return false;
            }
            ItemStack result = ((FurnaceRecipe)recipe.get()).func_77572_b((IInventory)tempInv);
            if (result.func_77973_b() instanceof BlockItem) {
                Block smeltedBlock = Block.func_149634_a((Item)result.func_77973_b());
                if (smeltedBlock == block) {
                    return false;
                }
                if (smeltedBlockState == null && smeltedBlock != Blocks.field_150350_a && smeltedBlock.func_176223_P().func_185904_a() != Material.field_151579_a) {
                    smeltedBlockState = smeltedBlock.func_176223_P();
                    continue;
                }
            }
            smeltedDrops.add(result);
        }
        if (smeltedBlockState == null && smeltedDrops.isEmpty()) {
            return false;
        }
        this.extractAEPower(item, 1600.0, Actionable.MODULATE);
        w.func_184148_a(p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
        if (smeltedBlockState == null) {
            w.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        } else {
            w.func_180501_a(pos, smeltedBlockState, 3);
        }
        Platform.spawnDrops(w, pos, smeltedDrops);
        return true;
    }

    @Nullable
    private static EntropyRecipe findRecipe(World world, EntropyMode mode, BlockState blockState, FluidState fluidState) {
        for (IRecipe recipe : world.func_199532_z().func_215366_a(EntropyRecipe.TYPE).values()) {
            EntropyRecipe entropyRecipe = (EntropyRecipe)recipe;
            if (!entropyRecipe.matches(mode, blockState, fluidState)) continue;
            return entropyRecipe;
        }
        return null;
    }

    private static void applyRecipe(EntropyRecipe recipe, World w, BlockPos pos, BlockState blockState, FluidState fluidState) {
        BlockState outputBlockState = recipe.getOutputBlockState(blockState);
        if (outputBlockState != null) {
            w.func_180501_a(pos, outputBlockState, 3);
        } else {
            FluidState outputFluidState = recipe.getOutputFluidState(fluidState);
            if (outputFluidState != null) {
                w.func_180501_a(pos, outputFluidState.func_206883_i(), 3);
            } else {
                w.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
        }
        if (!recipe.getDrops().isEmpty()) {
            Platform.spawnDrops(w, pos, recipe.getDrops());
        }
        if (recipe.getMode() == EntropyMode.HEAT && !w.func_201670_d()) {
            w.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (w.field_73012_v.nextFloat() - w.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                w.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }
}

