/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.capabilities.Capabilities;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class FEP2PTunnelPart
extends P2PTunnelPart<FEP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fe");
    private static final IEnergyStorage NULL_ENERGY_STORAGE = new NullEnergyStorage();
    private final IEnergyStorage inputHandler = new InputEnergyStorage();
    private final IEnergyStorage outputHandler = new OutputEnergyStorage();

    public FEP2PTunnelPart(ItemStack is) {
        super(is);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    private IEnergyStorage getAttachedEnergyStorage() {
        TileEntity self;
        TileEntity te;
        LazyOptional energyStorageOpt = LazyOptional.empty();
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null) {
            energyStorageOpt = te.getCapability(Capabilities.FORGE_ENERGY, this.getSide().getOpposite().getFacing());
        }
        return (IEnergyStorage)energyStorageOpt.orElse((Object)NULL_ENERGY_STORAGE);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (capability == Capabilities.FORGE_ENERGY) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler);
            }
            return LazyOptional.of(() -> this.inputHandler);
        }
        return super.getCapability(capability);
    }

    private static class NullEnergyStorage
    implements IEnergyStorage {
        private NullEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }

    private class OutputEnergyStorage
    implements IEnergyStorage {
        private OutputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int total = FEP2PTunnelPart.this.getAttachedEnergyStorage().extractEnergy(maxExtract, simulate);
            if (!simulate) {
                FEP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, total);
            }
            return total;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return FEP2PTunnelPart.this.getAttachedEnergyStorage().canExtract();
        }

        public boolean canReceive() {
            return false;
        }

        public int getMaxEnergyStored() {
            return FEP2PTunnelPart.this.getAttachedEnergyStorage().getMaxEnergyStored();
        }

        public int getEnergyStored() {
            return FEP2PTunnelPart.this.getAttachedEnergyStorage().getEnergyStored();
        }
    }

    private class InputEnergyStorage
    implements IEnergyStorage {
        private InputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int total = 0;
            try {
                int outputTunnels = FEP2PTunnelPart.this.getOutputs().size();
                if (outputTunnels == 0 | maxReceive == 0) {
                    return 0;
                }
                int amountPerOutput = maxReceive / outputTunnels;
                int overflow = amountPerOutput == 0 ? maxReceive : maxReceive % amountPerOutput;
                for (FEP2PTunnelPart target : FEP2PTunnelPart.this.getOutputs()) {
                    IEnergyStorage output = target.getAttachedEnergyStorage();
                    int toSend = amountPerOutput + overflow;
                    int received = output.receiveEnergy(toSend, simulate);
                    overflow = toSend - received;
                    total += received;
                }
                if (!simulate) {
                    FEP2PTunnelPart.this.queueTunnelDrain(PowerUnits.RF, total);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return total;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            int total = 0;
            try {
                for (FEP2PTunnelPart t : FEP2PTunnelPart.this.getOutputs()) {
                    total += t.getAttachedEnergyStorage().getMaxEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }

        public int getEnergyStored() {
            int total = 0;
            try {
                for (FEP2PTunnelPart t : FEP2PTunnelPart.this.getOutputs()) {
                    total += t.getAttachedEnergyStorage().getEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }
    }
}

