/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.parts.reporting.ReportingModelData;
import appeng.util.InteractionUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;

public abstract class AbstractReportingPart
extends AEBasePart
implements IMonitorPart,
IPowerChannelState {
    protected static final int POWERED_FLAG = 4;
    protected static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;
    private byte spin = 0;
    private int clientFlags = 0;
    private int opacity = -1;

    public AbstractReportingPart(ItemStack is) {
        this(is, false);
    }

    protected AbstractReportingPart(ItemStack is, boolean requireChannel) {
        super(is);
        if (requireChannel) {
            this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getProxy().setIdlePowerUsage(0.5);
        } else {
            this.getProxy().setIdlePowerUsage(0.0625);
        }
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        if (!this.isLightSource()) {
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged(IBlockReader w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(CompoundNBT data) {
        super.readFromNBT(data);
        this.spin = data.func_74771_c("spin");
    }

    @Override
    public void writeToNBT(CompoundNBT data) {
        super.writeToNBT(data);
        data.func_74774_a("spin", this.getSpin());
    }

    @Override
    public void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = this.getSpin() & 3;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags = this.getClientFlags() | 4;
            }
            if (this.getProxy().getPath().isNetworkBooting()) {
                this.clientFlags = this.getClientFlags() | 8;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags = this.getClientFlags() | 0x10;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(PacketBuffer data) throws IOException {
        super.readFromStream(data);
        int oldFlags = this.getClientFlags();
        int oldOpacity = this.opacity;
        this.clientFlags = data.readByte();
        this.opacity = data.readInt();
        this.spin = (byte)(this.getClientFlags() & 3);
        return this.getClientFlags() != oldFlags || this.opacity != oldOpacity;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(PlayerEntity player, Hand hand, Vector3d pos) {
        TileEntity te = this.getTile();
        if (InteractionUtil.isWrench(player, player.field_71071_by.func_70448_g(), te.func_174877_v())) {
            if (!this.isRemote()) {
                this.spin = (byte)((this.spin + 1) % 4);
                this.getHost().markForUpdate();
                this.saveChanges();
            }
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public final void onPlacement(PlayerEntity player, Hand hand, ItemStack held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        byte rotation = (byte)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3);
        if (side == AEPartLocation.UP) {
            this.spin = rotation;
        } else if (side == AEPartLocation.DOWN) {
            this.spin = rotation;
        }
    }

    private int blockLight(int emit) {
        if (this.opacity < 0) {
            TileEntity te = this.getTile();
            World world = te.func_145831_w();
            BlockPos pos = te.func_174877_v().func_177972_a(this.getSide().getFacing());
            this.opacity = 255 - world.func_180495_p(pos).func_200016_a((IBlockReader)world, pos);
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    @Override
    public final boolean isPowered() {
        try {
            if (!this.isRemote()) {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            return (this.getClientFlags() & 4) == 4;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public final boolean isActive() {
        if (!this.isLightSource()) {
            return (this.getClientFlags() & 0x14) == 20;
        }
        return this.isPowered();
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        if (this.isActive()) {
            return hasChannelModels;
        }
        if (this.isPowered()) {
            return onModels;
        }
        return offModels;
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new ReportingModelData(this.getSpin());
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract boolean isLightSource();
}

