/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.core.Api;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.crafting.CraftingCubeModelData;
import appeng.tile.grid.AENetworkTileEntity;
import appeng.util.Platform;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;

public class CraftingTileEntity
extends AENetworkTileEntity
implements IAEMultiBlock<CraftingCPUCluster>,
IPowerChannelState {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private CompoundNBT previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;

    public CraftingTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
    }

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        Optional<ItemStack> is = ((CraftingTileEntity)obj).isAccelerator() ? Api.instance().definitions().blocks().craftingAccelerator().maybeStack(1) : Api.instance().definitions().blocks().craftingUnit().maybeStack(1);
        return is.orElseGet(() -> super.getItemFromTile(obj));
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public boolean isAccelerator() {
        if (this.field_145850_b == null) {
            return false;
        }
        AbstractCraftingUnitBlock unit = (AbstractCraftingUnitBlock)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        return unit.type == AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getProxy().setVisualRepresentation(this.getItemFromTile(this));
        this.calc.calculateMultiblock(this.field_145850_b, this.field_174879_c);
    }

    public void updateMultiBlock(BlockPos changedPos) {
        this.calc.updateMultiblockAfterNeighborUpdate(this.field_145850_b, this.field_174879_c, changedPos);
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateMeta(true);
    }

    public void updateMeta(boolean updateFormed) {
        BlockState newState;
        BlockState current;
        if (this.field_145850_b == null || this.notLoaded() || this.func_145837_r()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = false;
        if (this.getProxy().isReady()) {
            power = this.getProxy().isActive();
        }
        if ((current = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof AbstractCraftingUnitBlock && current != (newState = (BlockState)((BlockState)current.func_206870_a((Property)AbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).func_206870_a((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed)))) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
        }
        if (updateFormed) {
            if (formed) {
                this.getProxy().setValidSides(EnumSet.allOf(Direction.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(Direction.class));
            }
        }
    }

    public boolean isFormed() {
        if (this.isRemote()) {
            return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)AbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_74757_a("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.setCoreBlock(data.func_74767_n("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.func_74737_b());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateMeta(true);
            }
        }
    }

    @Override
    public CraftingCPUCluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkChannelsChanged ev) {
        this.updateMeta(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkPowerStatusChange ev) {
        this.updateMeta(false);
    }

    public boolean isStatus() {
        return false;
    }

    public boolean isStorage() {
        return false;
    }

    public int getStorageBytes() {
        return 0;
    }

    public void breakCluster() {
        this.func_145836_u();
        if (this.cluster != null) {
            this.cluster.cancel();
            IMEInventory<IAEItemStack> inv = this.cluster.getInventory();
            LinkedList<BlockPos> places = new LinkedList<BlockPos>();
            Iterator<CraftingTileEntity> i = this.cluster.getTiles();
            while (i.hasNext()) {
                CraftingTileEntity h = i.next();
                if (h == this) {
                    places.add(this.field_174879_c);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = h.field_174879_c.func_177972_a(d);
                    if (!this.field_145850_b.func_175623_d(p)) continue;
                    places.add(p);
                }
            }
            Collections.shuffle(places);
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (IAEItemStack ais : inv.getAvailableItems(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList())) {
                IAEItemStack g;
                ais = ais.copy();
                ais.setStackSize(ais.getDefinition().func_77976_d());
                while ((g = inv.extractItems(ais.copy(), Actionable.MODULATE, this.cluster.getActionSource())) != null) {
                    BlockPos pos = (BlockPos)places.poll();
                    places.add(pos);
                    Platform.spawnDrops(this.field_145850_b, pos, Collections.singletonList(g.createItemStack()));
                }
            }
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (this.isRemote()) {
            return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)AbstractCraftingUnitBlock.POWERED);
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isActive() {
        if (!this.isRemote()) {
            return this.getProxy().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public CompoundNBT getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundNBT previousState) {
        this.previousState = previousState;
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        return new CraftingCubeModelData(this.getUp(), this.getForward(), this.getConnections());
    }

    protected EnumSet<Direction> getConnections() {
        if (this.field_145850_b == null) {
            return EnumSet.noneOf(Direction.class);
        }
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!this.isConnected((IBlockReader)this.field_145850_b, this.field_174879_c, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(IBlockReader world, BlockPos pos, Direction side) {
        BlockPos adjacentPos = pos.func_177972_a(side);
        return world.func_180495_p(adjacentPos).func_177230_c() instanceof AbstractCraftingUnitBlock;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.requestModelDataUpdate();
    }
}

