/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.storage.data.IAEStack;

public abstract class AEStack<T extends IAEStack<T>>
implements IAEStack<T> {
    private boolean isCraftable;
    private long stackSize;
    private long countRequestable;

    @Override
    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public T setStackSize(long ss) {
        this.stackSize = ss;
        return (T)this;
    }

    @Override
    public long getCountRequestable() {
        return this.countRequestable;
    }

    @Override
    public T setCountRequestable(long countRequestable) {
        this.countRequestable = countRequestable;
        return (T)this;
    }

    @Override
    public boolean isCraftable() {
        return this.isCraftable;
    }

    @Override
    public T setCraftable(boolean isCraftable) {
        this.isCraftable = isCraftable;
        return (T)this;
    }

    @Override
    public T reset() {
        this.stackSize = 0L;
        this.setCountRequestable(0L);
        this.setCraftable(false);
        return (T)this;
    }

    @Override
    public T empty() {
        Object dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public boolean isMeaningful() {
        return this.stackSize != 0L || this.countRequestable > 0L || this.isCraftable;
    }

    @Override
    public void incStackSize(long i) {
        this.stackSize += i;
    }

    @Override
    public void decStackSize(long i) {
        this.stackSize -= i;
    }

    @Override
    public void incCountRequestable(long i) {
        this.countRequestable += i;
    }

    @Override
    public void decCountRequestable(long i) {
        this.countRequestable -= i;
    }

    protected abstract boolean hasTagCompound();
}

