/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public enum Upgrades {
    CAPACITY(0),
    REDSTONE(0),
    CRAFTING(0),
    FUZZY(1),
    SPEED(1),
    INVERTER(1);

    private final int tier;
    private final List<Supported> supported = new ArrayList<Supported>();
    private List<class_2561> supportedTooltipLines;

    private Upgrades(int tier) {
        this.tier = tier;
    }

    public List<Supported> getSupported() {
        return this.supported;
    }

    public void registerItem(class_1935 item, int maxSupported) {
        this.registerItem(item, maxSupported, null);
    }

    public void registerItem(class_1935 item, int maxSupported, @Nullable String tooltipGroup) {
        Preconditions.checkNotNull((Object)item);
        this.supported.add(new Supported(item.method_8389(), maxSupported, tooltipGroup));
        this.supportedTooltipLines = null;
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTooltipLines() {
        if (this.supportedTooltipLines == null) {
            this.supported.sort(Comparator.comparingInt(o -> ((Supported)o).maxCount));
            this.supportedTooltipLines = new ArrayList<class_2561>(this.supported.size());
            HashSet<class_2561> namesAdded = new HashSet<class_2561>();
            for (int i = 0; i < this.supported.size(); ++i) {
                Supported supported = this.supported.get(i);
                class_2561 name = supported.item.method_7848();
                if (supported.getTooltipGroup() != null && namesAdded.contains(supported.getTooltipGroup())) continue;
                if (supported.getTooltipGroup() != null) {
                    for (int j = i + 1; j < this.supported.size(); ++j) {
                        class_2561 otherGroup = this.supported.get(j).getTooltipGroup();
                        if (!supported.getTooltipGroup().equals(otherGroup)) continue;
                        name = supported.getTooltipGroup();
                        break;
                    }
                }
                if (!namesAdded.add(name)) continue;
                if (supported.maxCount > 1) {
                    name = name.method_27662().method_27693(" (" + supported.maxCount + ")");
                }
                this.supportedTooltipLines.add(name);
            }
        }
        return this.supportedTooltipLines;
    }

    public int getTier() {
        return this.tier;
    }

    public static class Supported {
        private final class_1792 item;
        private final class_2248 block;
        private final int maxCount;
        @Nullable
        private final String tooltipGroup;

        public Supported(class_1792 item, int maxCount, @Nullable String tooltipGroup) {
            this.item = item;
            this.block = item instanceof class_1747 ? ((class_1747)item).method_7711() : null;
            this.maxCount = maxCount;
            this.tooltipGroup = tooltipGroup;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public boolean isSupported(class_2248 block) {
            return block != null && this.block == block;
        }

        public boolean isSupported(class_1792 item) {
            return item != null && this.item == item;
        }

        public class_2561 getTooltipGroup() {
            return this.tooltipGroup != null ? new class_2588(this.tooltipGroup) : null;
        }
    }
}

