/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseBlockItem;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import java.text.MessageFormat;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class AEBaseBlockItemChargeable
extends AEBaseBlockItem
implements IAEItemPowerStorage {
    public AEBaseBlockItemChargeable(class_2248 id, class_1792.class_1793 props) {
        super(id, props);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addCheckedInformation(class_1799 stack, class_1937 world, List<class_2561> lines, class_1836 advancedTooltips) {
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMaxEnergyCapacity();
        if (internalMaxPower > 0.0) {
            class_2487 tag = stack.method_7969();
            if (tag != null) {
                internalCurrentPower = tag.method_10574("internalCurrentPower");
            }
            double percent = internalCurrentPower / internalMaxPower;
            lines.add((class_2561)GuiText.StoredEnergy.text().method_27662().method_27693(':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower)).method_10852((class_2561)new class_2588(PowerUnits.AE.unlocalizedName)).method_27693(" - " + MessageFormat.format("{0,number,#.##%}", percent)));
        }
    }

    @Override
    public double injectAEPower(class_1799 is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getAEMaxPower(is);
        double required = internalMaxPower - internalCurrentPower;
        double overflow = Math.max(0.0, amount - required);
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(required, amount);
            double newPowerStored = internalCurrentPower + toAdd;
            this.setInternal(is, newPowerStored);
        }
        return overflow;
    }

    @Override
    public double extractAEPower(class_1799 is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double fulfillable = Math.min(amount, internalCurrentPower);
        if (mode == Actionable.MODULATE) {
            double newPowerStored = internalCurrentPower - fulfillable;
            this.setInternal(is, newPowerStored);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(class_1799 is) {
        return this.getMaxEnergyCapacity();
    }

    @Override
    public double getAECurrentPower(class_1799 is) {
        return this.getInternal(is);
    }

    @Override
    public AccessRestriction getPowerFlow(class_1799 is) {
        return AccessRestriction.WRITE;
    }

    private double getMaxEnergyCapacity() {
        class_2248 blockID = class_2248.method_9503((class_1792)this);
        ITileDefinition energyCell = Api.instance().definitions().blocks().energyCell();
        return energyCell.maybeBlock().map(block -> {
            if (blockID == block) {
                return 200000;
            }
            return 1600000;
        }).orElse(0).intValue();
    }

    private double getInternal(class_1799 is) {
        class_2487 nbt = is.method_7948();
        return nbt.method_10574("internalCurrentPower");
    }

    private void setInternal(class_1799 is, double amt) {
        class_2487 nbt = is.method_7948();
        nbt.method_10549("internalCurrentPower", amt);
    }
}

