/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.AttributeProvider;
import alexiil.mc.lib.attributes.item.FixedItemInv;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.networking.CableBusBlock;
import appeng.tile.AEBaseBlockEntity;
import appeng.tile.AEBaseInvBlockEntity;
import appeng.tile.networking.CableBusBlockEntity;
import appeng.tile.storage.SkyChestBlockEntity;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class AEBaseTileBlock<T extends AEBaseBlockEntity>
extends AEBaseBlock
implements class_2343,
AttributeProvider {
    @Nonnull
    private Class<T> blockEntityClass;
    @Nonnull
    private Supplier<T> tileEntityFactory;

    public AEBaseTileBlock(class_4970.class_2251 props) {
        super(props);
    }

    public void setTileEntity(Class<T> tileEntityClass, Supplier<T> factory) {
        this.blockEntityClass = tileEntityClass;
        this.tileEntityFactory = factory;
        this.setInventory(AEBaseInvBlockEntity.class.isAssignableFrom(tileEntityClass));
    }

    public Class<T> getBlockEntityClass() {
        return this.blockEntityClass;
    }

    @Nullable
    public T getBlockEntity(class_1922 w, int x, int y, int z) {
        return this.getBlockEntity(w, new class_2338(x, y, z));
    }

    @Nullable
    public T getBlockEntity(class_1922 w, class_2338 pos) {
        class_2586 te = w.method_8321(pos);
        if (this.blockEntityClass != null && this.blockEntityClass.isInstance(te)) {
            return (T)((AEBaseBlockEntity)this.blockEntityClass.cast(te));
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_1922 world) {
        return (class_2586)this.tileEntityFactory.get();
    }

    public void method_9536(class_2680 state, class_1937 w, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (newState.method_26204() == state.method_26204()) {
            return;
        }
        T te = this.getBlockEntity((class_1922)w, pos);
        if (te != null) {
            ArrayList<class_1799> drops = new ArrayList<class_1799>();
            if (((AEBaseBlockEntity)te).dropItems()) {
                ((AEBaseBlockEntity)te).getDrops(w, pos, drops);
            } else {
                ((AEBaseBlockEntity)te).getNoDrops(w, pos, drops);
            }
            Platform.spawnDrops(w, pos, drops);
        }
        super.method_9536(state, w, pos, newState, isMoving);
    }

    @Override
    public int method_9572(class_2680 state, class_1937 w, class_2338 pos) {
        AEBaseInvBlockEntity invTile;
        T te = this.getBlockEntity((class_1922)w, pos);
        if (te instanceof AEBaseInvBlockEntity && (invTile = (AEBaseInvBlockEntity)te).getInternalInventory().getSlotCount() > 0) {
            return this.getRedstoneFromFixedItemInv(invTile.getInternalInventory());
        }
        return 0;
    }

    private int getRedstoneFromFixedItemInv(FixedItemInv inv) {
        boolean foundAnything = false;
        float fillRatio = 0.0f;
        for (int i = 0; i < inv.getSlotCount(); ++i) {
            class_1799 stack = inv.getInvStack(i);
            if (stack.method_7960()) continue;
            int slotMaxCount = inv.getMaxAmount(i, stack);
            fillRatio += (float)stack.method_7947() / (float)Math.min(slotMaxCount, stack.method_7914());
            foundAnything = true;
        }
        return (foundAnything ? 1 : 0) + class_3532.method_15375((float)((fillRatio /= (float)inv.getSlotCount()) * 14.0f));
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        super.method_9592(state, world, pos, type, data);
        class_2586 tileentity = world.method_8321(pos);
        return tileentity != null && tileentity.method_11004(type, data);
    }

    public void method_9567(class_1937 w, class_2338 pos, class_2680 state, class_1309 placer, class_1799 is) {
        class_2561 displayName;
        T te = this.getBlockEntity((class_1922)w, pos);
        if (te != null && is.method_7938() && (displayName = is.method_7964()) instanceof class_2585) {
            ((AEBaseBlockEntity)te).setName(((class_2585)displayName).method_10993());
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player != null && !player.method_5998(hand).method_7960()) {
            class_1799 heldItem = player.method_5998(hand);
            if (Platform.isWrench(player, heldItem, pos) && player.method_18276()) {
                class_2680 blockState = world.method_8320(pos);
                class_2248 block = blockState.method_26204();
                T tile = this.getBlockEntity((class_1922)world, pos);
                if (tile == null) {
                    return class_1269.field_5814;
                }
                if (tile instanceof CableBusBlockEntity || tile instanceof SkyChestBlockEntity) {
                    return class_1269.field_5814;
                }
                Object[] itemDropCandidates = Platform.getBlockDrops(world, pos);
                class_1799 op = new class_1799((class_1935)this);
                for (class_1799 class_17992 : itemDropCandidates) {
                    class_2487 tag;
                    if (!Platform.itemComparisons().isEqualItemType(class_17992, op) || (tag = ((AEBaseBlockEntity)tile).downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                    class_17992.method_7980(tag);
                }
                block.method_9576(world, pos, blockState, player);
                boolean bl = world.method_8650(pos, false);
                if (bl) {
                    block.method_9585((class_1936)world, pos, blockState);
                    ArrayList itemsToDrop = Lists.newArrayList((Object[])itemDropCandidates);
                    Platform.spawnDrops(world, pos, itemsToDrop);
                }
                return class_1269.field_5812;
            }
            if (heldItem.method_7909() instanceof IMemoryCard && !(this instanceof CableBusBlock)) {
                IMemoryCard memoryCard = (IMemoryCard)heldItem.method_7909();
                T tileEntity = this.getBlockEntity((class_1922)world, pos);
                if (tileEntity == null) {
                    return class_1269.field_5814;
                }
                String name = this.method_9539();
                if (player.method_18276()) {
                    class_2487 data = ((AEBaseBlockEntity)tileEntity).downloadSettings(SettingsFrom.MEMORY_CARD);
                    if (data != null) {
                        memoryCard.setMemoryCardContents(heldItem, name, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    }
                } else {
                    String savedName = memoryCard.getSettingsName(heldItem);
                    class_2487 data = memoryCard.getData(heldItem);
                    if (this.method_9539().equals(savedName)) {
                        ((AEBaseBlockEntity)tileEntity).uploadSettings(SettingsFrom.MEMORY_CARD, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return this.onActivated(world, pos, player, hand, player.method_5998(hand), hit);
    }

    public class_1269 onActivated(class_1937 w, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        return class_1269.field_5811;
    }

    @Override
    public IOrientable getOrientable(class_1922 w, class_2338 pos) {
        return this.getBlockEntity(w, pos);
    }

    public final class_2680 getBlockEntityBlockState(class_2680 current, class_2586 te) {
        if (current.method_26204() != this || !this.blockEntityClass.isInstance(te)) {
            return current;
        }
        return this.updateBlockStateFromTileEntity(current, (AEBaseBlockEntity)this.blockEntityClass.cast(te));
    }

    protected class_2680 updateBlockStateFromTileEntity(class_2680 currentState, T te) {
        return currentState;
    }

    public void addAllAttributes(class_1937 world, class_2338 pos, class_2680 state, AttributeList<?> to) {
        T te = this.getBlockEntity((class_1922)world, pos);
        if (te != null) {
            ((AEBaseBlockEntity)te).addAllAttributes(world, pos, state, to);
        }
    }
}

