/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.block.AEBaseTileBlock;
import appeng.core.stats.AeStats;
import appeng.tile.AEBaseBlockEntity;
import appeng.tile.grindstone.CrankBlockEntity;
import appeng.util.FakePlayer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class CrankBlock
extends AEBaseTileBlock<CrankBlockEntity> {
    public CrankBlock(class_4970.class_2251 props) {
        super(props);
    }

    @Override
    public class_1269 onActivated(class_1937 w, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        if (FakePlayer.isFakePlayer(player) || player == null) {
            this.dropCrank(w, pos);
            return class_1269.field_5812;
        }
        CrankBlockEntity tile = (CrankBlockEntity)this.getBlockEntity((class_1922)w, pos);
        if (tile != null) {
            if (tile.power()) {
                AeStats.TurnedCranks.addToPlayer(player, 1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void dropCrank(class_1937 world, class_2338 pos) {
        world.method_22352(pos, true);
        world.method_8413(pos, this.method_9564(), world.method_8320(pos), 3);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        Object tile = this.getBlockEntity((class_1922)world, pos);
        if (tile != null) {
            class_2350 mnt = this.findCrankable((class_1922)world, pos);
            class_2350 forward = class_2350.field_11036;
            if (mnt == class_2350.field_11036 || mnt == class_2350.field_11033) {
                forward = class_2350.field_11035;
            }
            ((AEBaseBlockEntity)tile).setOrientation(forward, mnt.method_10153());
        } else {
            this.dropCrank(world, pos);
        }
    }

    @Override
    public boolean isValidOrientation(class_1936 w, class_2338 pos, class_2350 forward, class_2350 up) {
        class_2586 te = w.method_8321(pos);
        return !(te instanceof CrankBlockEntity) || this.isCrankable((class_1922)w, pos, up.method_10153());
    }

    private class_2350 findCrankable(class_1922 world, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!this.isCrankable(world, pos, dir)) continue;
            return dir;
        }
        return null;
    }

    private boolean isCrankable(class_1922 world, class_2338 pos, class_2350 offset) {
        class_2338 o = pos.method_10093(offset);
        class_2586 te = world.method_8321(o);
        return te instanceof ICrankable && ((ICrankable)te).canCrankAttach(offset.method_10153());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        Object tile = this.getBlockEntity((class_1922)world, pos);
        if (tile != null) {
            if (!this.isCrankable((class_1922)world, pos, ((AEBaseBlockEntity)tile).getUp().method_10153())) {
                this.dropCrank(world, pos);
            }
        } else {
            this.dropCrank(world, pos);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 w, class_2338 pos) {
        return this.findCrankable((class_1922)w, pos) != null;
    }

    private class_2350 getUp(class_1922 world, class_2338 pos) {
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity(world, pos);
        return crank != null ? crank.getUp() : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 up = this.getUp(world, pos);
        if (up == null) {
            return class_259.method_1073();
        }
        double xOff = -0.15 * (double)up.method_10148();
        double yOff = -0.15 * (double)up.method_10164();
        double zOff = -0.15 * (double)up.method_10165();
        return class_259.method_1078((class_238)new class_238(xOff + 0.15, yOff + 0.15, zOff + 0.15, xOff + 0.85, yOff + 0.85, zOff + 0.85));
    }

    @Override
    protected boolean hasCustomRotation() {
        return true;
    }
}

