/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.helpers.MetaRotation;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class QuartzFixtureBlock
extends AEBaseBlock
implements IOrientableBlock {
    private static final Map<class_2350, class_265> SHAPES = new EnumMap<class_2350, class_265>(class_2350.class);
    public static final class_2753 FACING;
    public static final class_2746 ODD;

    public QuartzFixtureBlock() {
        super((class_4970.class_2251)QuartzFixtureBlock.defaultProps(class_3614.field_15924).noCollision().strength(0.0f).lightLevel(14).sounds(class_2498.field_11537));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ODD});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350[] adirection;
        class_2680 blockstate = super.method_9605(context);
        class_2338 pos = context.method_8037();
        boolean oddPlacement = (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 != 0;
        blockstate = (class_2680)blockstate.method_11657((class_2769)ODD, (Comparable)Boolean.valueOf(oddPlacement));
        class_1937 iworldreader = context.method_8045();
        for (class_2350 direction : adirection = context.method_7718()) {
            if (!this.canPlaceAt((class_4538)iworldreader, pos, direction)) continue;
            return (class_2680)blockstate.method_11657((class_2769)FACING, (Comparable)direction.method_10153());
        }
        return null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 pos, class_2338 facingPos) {
        class_2350 fixtureFacing = (class_2350)state.method_11654((class_2769)FACING);
        if (facing.method_10153() == fixtureFacing && !this.canPlaceAt((class_4538)worldIn, pos, facing)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    public boolean isValidOrientation(class_1936 w, class_2338 pos, class_2350 forward, class_2350 up) {
        return this.canPlaceAt((class_4538)w, pos, up.method_10153());
    }

    private boolean canPlaceAt(class_4538 w, class_2338 pos, class_2350 dir) {
        class_2338 test = pos.method_10093(dir);
        class_2680 blockstate = w.method_8320(test);
        return blockstate.method_26206((class_1922)w, test, dir.method_10153());
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        return SHAPES.get(facing);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 w, class_2338 pos, Random r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        class_2350 up = this.getOrientable((class_1922)w, pos).getUp();
        double xOff = -0.3 * (double)up.method_10148();
        double yOff = -0.3 * (double)up.method_10164();
        double zOff = -0.3 * (double)up.method_10165();
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (!AppEng.instance().shouldAddParticles(r)) continue;
            w.method_8406((class_2394)ParticleTypes.LIGHTNING, xOff + 0.5 + (double)pos.method_10263(), yOff + 0.5 + (double)pos.method_10264(), zOff + 0.5 + (double)pos.method_10260(), 0.0, 0.0, 0.0);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        class_2350 up = this.getOrientable((class_1922)world, pos).getUp();
        if (!this.canPlaceAt((class_4538)world, pos, up.method_10153())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(class_1937 w, class_2338 pos) {
        class_2680 prev = w.method_8320(pos);
        w.method_22352(pos, true);
        w.method_8413(pos, prev, w.method_8320(pos), 3);
    }

    public boolean method_9558(class_2680 state, class_4538 w, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!this.canPlaceAt(w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOrientable getOrientable(class_1922 w, class_2338 pos) {
        return new MetaRotation(w, pos, FACING);
    }

    static {
        for (class_2350 facing : class_2350.values()) {
            double xOff = -0.3 * (double)facing.method_10148();
            double yOff = -0.3 * (double)facing.method_10164();
            double zOff = -0.3 * (double)facing.method_10165();
            class_265 shape = class_259.method_1078((class_238)new class_238(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = class_2741.field_12525;
        ODD = class_2746.method_11825((String)"odd");
    }
}

