/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableBusBreakingParticle;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ClickPacket;
import appeng.helpers.AEMaterials;
import appeng.integration.abstraction.IAEFacade;
import appeng.parts.CableBusContainer;
import appeng.parts.ICableBusContainer;
import appeng.parts.NullCableBusContainer;
import appeng.tile.networking.CableBusBlockEntity;
import appeng.util.Platform;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;

public class CableBusBlock
extends AEBaseTileBlock<CableBusBlockEntity>
implements IAEFacade {
    private static final ICableBusContainer NULL_CABLE_BUS = new NullCableBusContainer();
    private static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);

    public CableBusBlock() {
        super((class_4970.class_2251)CableBusBlock.defaultProps(AEMaterials.GLASS).nonOpaque().dropsNothing().dynamicBounds().luminance(state -> (Integer)state.method_11654((class_2769)LIGHT_LEVEL)));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 worldIn, class_2338 pos, Random rand) {
        this.cb((class_1922)worldIn, pos).randomDisplayTick(worldIn, pos, rand);
    }

    public int method_9524(class_2680 state, class_1922 w, class_2338 pos, class_2350 side) {
        return this.cb(w, pos).isProvidingWeakPower(side.method_10153());
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void method_9548(class_2680 state, class_1937 w, class_2338 pos, class_1297 entityIn) {
        this.cb((class_1922)w, pos).onEntityCollision(entityIn);
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.cb(world, pos).isProvidingStrongPower(direction.method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LIGHT_LEVEL});
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return super.method_9616(state, context) && this.cb((class_1922)context.method_8045(), context.method_8037()).isEmpty();
    }

    public class_1799 getPickBlock(class_2680 state, class_239 target, class_1922 world, class_2338 pos, class_1657 player) {
        class_243 v3 = target.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        SelectedPart sp = this.cb(world, pos).selectPart(v3);
        if (sp.part != null) {
            return sp.part.getItemStack(PartItemStack.PICK);
        }
        if (sp.facade != null) {
            return sp.facade.getItemStack();
        }
        return class_1799.field_8037;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 effectRenderer) {
        if (Platform.getRandom().nextBoolean()) {
            return true;
        }
        if (target.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_2338 blockPos = new class_2338(target.method_17784().field_1352, target.method_17784().field_1351, target.method_17784().field_1350);
        ICableBusContainer cb = this.cb((class_1922)world, blockPos);
        class_1087 model = class_310.method_1551().method_1541().method_3349(this.method_9564());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        class_1058 texture = Platform.pickRandom(cableBusModel.getParticleTextures(renderState));
        if (texture != null) {
            double x = target.method_17784().field_1352;
            double y = target.method_17784().field_1351;
            double z = target.method_17784().field_1350;
            effectRenderer.method_3058(new CableBusBreakingParticle((class_638)world, x, y, z, texture).method_3087(0.8f));
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addDestroyEffects(class_2680 state, class_1937 world, class_2338 pos, class_702 effectRenderer) {
        ICableBusContainer cb = this.cb((class_1922)world, pos);
        class_1087 model = class_310.method_1551().method_1541().method_3349(this.method_9564());
        if (!(model instanceof CableBusBakedModel)) {
            return true;
        }
        CableBusBakedModel cableBusModel = (CableBusBakedModel)model;
        CableBusRenderState renderState = cb.getRenderState();
        List<class_1058> textures = cableBusModel.getParticleTextures(renderState);
        if (!textures.isEmpty()) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        class_1058 texture = Platform.pickRandom(textures);
                        double x = (double)pos.method_10263() + ((double)j + 0.5) / 4.0;
                        double y = (double)pos.method_10264() + ((double)k + 0.5) / 4.0;
                        double z = (double)pos.method_10260() + ((double)l + 0.5) / 4.0;
                        CableBusBreakingParticle effect = new CableBusBreakingParticle((class_638)world, x, y, z, x - (double)pos.method_10263() - 0.5, y - (double)pos.method_10264() - 0.5, z - (double)pos.method_10260() - 0.5, texture);
                        effectRenderer.method_3058((class_703)effect);
                    }
                }
            }
        }
        return true;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (Platform.isServer()) {
            this.cb((class_1922)world, pos).onneighborUpdate((class_1922)world, pos, fromPos);
        }
    }

    private ICableBusContainer cb(class_1922 w, class_2338 pos) {
        class_2586 te = w.method_8321(pos);
        CableBusContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus();
        }
        return out == null ? NULL_CABLE_BUS : out;
    }

    @Nullable
    private IFacadeContainer fc(class_1922 w, class_2338 pos) {
        class_2586 te = w.method_8321(pos);
        IFacadeContainer out = null;
        if (te instanceof CableBusBlockEntity) {
            out = ((CableBusBlockEntity)te).getCableBus().getFacadeContainer();
        }
        return out;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9606(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player) {
        class_3965 brtr;
        class_239 rtr;
        if (worldIn.method_8608() && (rtr = AppEng.instance().getRTR()) instanceof class_3965 && (brtr = (class_3965)rtr).method_17777().equals((Object)pos)) {
            class_243 hitVec = rtr.method_17784().method_1020(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
            if (this.cb((class_1922)worldIn, pos).clicked(player, class_1268.field_5808, hitVec)) {
                NetworkHandler.instance().sendToServer(new ClickPacket(pos, brtr.method_17780(), (float)hitVec.field_1352, (float)hitVec.field_1351, (float)hitVec.field_1350, class_1268.field_5808, true));
            }
        }
    }

    public void onBlockClickPacket(class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_243 hitVec) {
        this.cb((class_1922)worldIn, pos).clicked(playerIn, hand, hitVec);
    }

    @Override
    public class_1269 onActivated(class_1937 w, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        class_243 hitVec = hit.method_17784();
        class_243 hitInBlock = new class_243(hitVec.field_1352 - (double)pos.method_10263(), hitVec.field_1351 - (double)pos.method_10264(), hitVec.field_1350 - (double)pos.method_10260());
        return this.cb((class_1922)w, pos).activate(player, hand, hitInBlock) ? class_1269.field_5812 : class_1269.field_5811;
    }

    public boolean recolorBlock(class_1922 world, class_2338 pos, class_2350 side, class_1767 color, class_1657 who) {
        try {
            return this.cb(world, pos).recolourBlock(side, AEColor.values()[color.ordinal()], who);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void method_9578(class_1761 group, class_2371<class_1799> list) {
    }

    @Override
    public class_2680 getFacadeState(class_1922 world, class_2338 pos, class_2350 side) {
        IFacadePart facade;
        IFacadeContainer container;
        if (side != null && (container = this.fc(world, pos)) != null && (facade = container.getFacade(AEPartLocation.fromFacing(side))) != null) {
            return facade.getBlockState();
        }
        return world.method_8320(pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 w, class_2338 pos, class_3726 context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(w, pos);
        if (te == null) {
            return class_259.method_1073();
        }
        return te.getCableBus().getOutlineShape();
    }

    public class_265 method_9549(class_2680 state, class_1922 w, class_2338 pos, class_3726 context) {
        CableBusBlockEntity te = (CableBusBlockEntity)this.getBlockEntity(w, pos);
        if (te == null) {
            return class_259.method_1073();
        }
        class_1297 entity = null;
        return te.getCableBus().getCollisionShape(entity);
    }

    @Override
    protected class_2680 updateBlockStateFromTileEntity(class_2680 currentState, CableBusBlockEntity te) {
        if (currentState.method_26204() != this) {
            return currentState;
        }
        int lightLevel = te.getCableBus().getLightValue();
        return (class_2680)super.updateBlockStateFromTileEntity(currentState, te).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
    }

    static {
        ClientPickBlockGatherCallback.EVENT.register((player, result) -> {
            if (result instanceof class_3965) {
                class_3965 blockResult = (class_3965)result;
                class_2680 blockState = player.field_6002.method_8320(((class_3965)result).method_17777());
                if (blockState.method_26204() instanceof CableBusBlock) {
                    CableBusBlock cableBus = (CableBusBlock)blockState.method_26204();
                    return cableBus.getPickBlock(blockState, result, (class_1922)player.field_6002, blockResult.method_17777(), player);
                }
            }
            return class_1799.field_8037;
        });
    }
}

