/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.qnb.QnbFormedState;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.core.Api;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

class QnbFormedBakedModel
implements class_1087,
FabricBakedModel {
    private static final class_4730 TEXTURE_LINK = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "block/quantum_link"));
    private static final class_4730 TEXTURE_RING = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "block/quantum_ring"));
    private static final class_4730 TEXTURE_RING_LIGHT = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "block/quantum_ring_light"));
    private static final class_4730 TEXTURE_RING_LIGHT_CORNER = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "block/quantum_ring_light_corner"));
    private static final class_4730 TEXTURE_CABLE_GLASS = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "part/cable/glass/transparent"));
    private static final class_4730 TEXTURE_COVERED_CABLE = new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", "part/cable/covered/transparent"));
    private static final float DEFAULT_RENDER_MIN = 2.0f;
    private static final float DEFAULT_RENDER_MAX = 14.0f;
    private static final float CORNER_POWERED_RENDER_MIN = 3.9f;
    private static final float CORNER_POWERED_RENDER_MAX = 12.1f;
    private static final float CENTER_POWERED_RENDER_MIN = -0.01f;
    private static final float CENTER_POWERED_RENDER_MAX = 16.01f;
    private final class_1087 baseModel;
    private final class_2248 linkBlock;
    private final class_1058 linkTexture;
    private final class_1058 ringTexture;
    private final class_1058 glassCableTexture;
    private final class_1058 coveredCableTexture;
    private final class_1058 lightTexture;
    private final class_1058 lightCornerTexture;

    public QnbFormedBakedModel(class_1087 baseModel, Function<class_4730, class_1058> bakedTextureGetter) {
        this.baseModel = baseModel;
        this.linkTexture = bakedTextureGetter.apply(TEXTURE_LINK);
        this.ringTexture = bakedTextureGetter.apply(TEXTURE_RING);
        this.glassCableTexture = bakedTextureGetter.apply(TEXTURE_CABLE_GLASS);
        this.coveredCableTexture = bakedTextureGetter.apply(TEXTURE_COVERED_CABLE);
        this.lightTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT);
        this.lightCornerTexture = bakedTextureGetter.apply(TEXTURE_RING_LIGHT_CORNER);
        this.linkBlock = Api.instance().definitions().blocks().quantumLink().maybeBlock().orElse(null);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        QnbFormedState formedState = QnbFormedBakedModel.getState(blockView, pos);
        if (formedState == null) {
            context.fallbackConsumer().accept(this.baseModel);
            return;
        }
        this.buildQuads(context.getEmitter(), formedState, state);
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, Random random) {
        return this.baseModel.method_4707(state, face, random);
    }

    private static QnbFormedState getState(class_1920 view, class_2338 pos) {
        if (!(view instanceof RenderAttachedBlockView)) {
            return null;
        }
        Object attachment = ((RenderAttachedBlockView)view).getBlockEntityRenderAttachment(pos);
        if (attachment instanceof QnbFormedState) {
            return (QnbFormedState)attachment;
        }
        return null;
    }

    private void buildQuads(QuadEmitter emitter, QnbFormedState formedState, class_2680 state) {
        CubeBuilder builder = new CubeBuilder(emitter);
        if (state.method_26204() == this.linkBlock) {
            Set<class_2350> sides = formedState.getAdjacentQuantumBridges();
            this.renderCableAt(builder, 1.76f, this.glassCableTexture, 2.256f, sides);
            this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 3.0f, sides);
            builder.setTexture(this.linkTexture);
            builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
        } else if (formedState.isCorner()) {
            this.renderCableAt(builder, 3.008f, this.coveredCableTexture, 0.8f, formedState.getAdjacentQuantumBridges());
            builder.setTexture(this.ringTexture);
            builder.addCube(2.0f, 2.0f, 2.0f, 14.0f, 14.0f, 14.0f);
            if (formedState.isPowered()) {
                builder.setTexture(this.lightCornerTexture);
                builder.setEmissiveMaterial(true);
                for (class_2350 facing : class_2350.values()) {
                    float xOffset = Math.abs((float)facing.method_10148() * 0.01f);
                    float yOffset = Math.abs((float)facing.method_10164() * 0.01f);
                    float zOffset = Math.abs((float)facing.method_10165() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(2.0f - xOffset, 2.0f - yOffset, 2.0f - zOffset, 14.0f + xOffset, 14.0f + yOffset, 14.0f + zOffset);
                }
                builder.setEmissiveMaterial(false);
            }
        } else {
            builder.setTexture(this.ringTexture);
            builder.addCube(0.0f, 2.0f, 2.0f, 16.0f, 14.0f, 14.0f);
            builder.addCube(2.0f, 0.0f, 2.0f, 14.0f, 16.0f, 14.0f);
            builder.addCube(2.0f, 2.0f, 0.0f, 14.0f, 14.0f, 16.0f);
            if (formedState.isPowered()) {
                builder.setTexture(this.lightTexture);
                builder.setEmissiveMaterial(true);
                for (class_2350 facing : class_2350.values()) {
                    float xOffset = Math.abs((float)facing.method_10148() * 0.01f);
                    float yOffset = Math.abs((float)facing.method_10164() * 0.01f);
                    float zOffset = Math.abs((float)facing.method_10165() * 0.01f);
                    builder.setDrawFaces(EnumSet.of(facing));
                    builder.addCube(-xOffset, -yOffset, -zOffset, 16.0f + xOffset, 16.0f + yOffset, 16.0f + zOffset);
                }
            }
        }
    }

    private void renderCableAt(CubeBuilder builder, float thickness, class_1058 texture, float pull, Set<class_2350> connections) {
        builder.setTexture(texture);
        if (connections.contains(class_2350.field_11039)) {
            builder.addCube(0.0f, 8.0f - thickness, 8.0f - thickness, 8.0f - thickness - pull, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(class_2350.field_11034)) {
            builder.addCube(8.0f + thickness + pull, 8.0f - thickness, 8.0f - thickness, 16.0f, 8.0f + thickness, 8.0f + thickness);
        }
        if (connections.contains(class_2350.field_11043)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 0.0f, 8.0f + thickness, 8.0f + thickness, 8.0f - thickness - pull);
        }
        if (connections.contains(class_2350.field_11035)) {
            builder.addCube(8.0f - thickness, 8.0f - thickness, 8.0f + thickness + pull, 8.0f + thickness, 8.0f + thickness, 16.0f);
        }
        if (connections.contains(class_2350.field_11033)) {
            builder.addCube(8.0f - thickness, 0.0f, 8.0f - thickness, 8.0f + thickness, 8.0f - thickness - pull, 8.0f + thickness);
        }
        if (connections.contains(class_2350.field_11036)) {
            builder.addCube(8.0f - thickness, 8.0f + thickness + pull, 8.0f - thickness, 8.0f + thickness, 16.0f, 8.0f + thickness);
        }
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public boolean method_4708() {
        return this.baseModel.method_4708();
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.baseModel.method_4711();
    }

    public class_806 method_4710() {
        return this.baseModel.method_4710();
    }

    public static List<class_4730> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_LINK, (Object)TEXTURE_RING, (Object)TEXTURE_CABLE_GLASS, (Object)TEXTURE_COVERED_CABLE, (Object)TEXTURE_RING_LIGHT, (Object)TEXTURE_RING_LIGHT_CORNER);
    }
}

