/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.SkyChestContainer;
import appeng.tile.storage.SkyChestBlockEntity;
import appeng.util.Platform;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class SkyChestBlock
extends AEBaseTileBlock<SkyChestBlockEntity> {
    private static final double AABB_OFFSET_BOTTOM = 0.0;
    private static final double AABB_OFFSET_SIDES = 0.06;
    private static final double AABB_OFFSET_TOP = 0.0625;
    private static final Map<class_2350, class_265> SHAPES = new EnumMap<class_2350, class_265>(class_2350.class);
    public final SkyChestType type;

    public SkyChestBlock(SkyChestType type, class_4970.class_2251 props) {
        super(props);
        this.type = type;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public boolean method_9579(class_2680 state, class_1922 reader, class_2338 pos) {
        return true;
    }

    @Override
    public class_1269 onActivated(class_1937 w, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        if (Platform.isServer()) {
            SkyChestBlockEntity tile = (SkyChestBlockEntity)this.getBlockEntity((class_1922)w, pos);
            if (tile == null) {
                return class_1269.field_5811;
            }
            ContainerOpener.openContainer(SkyChestContainer.TYPE, player, ContainerLocator.forTileEntity(tile));
        }
        return class_1269.field_5812;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        SkyChestBlockEntity sk = (SkyChestBlockEntity)this.getBlockEntity(worldIn, pos);
        class_2350 up = sk != null ? sk.getUp() : class_2350.field_11036;
        return SHAPES.get(up);
    }

    private static class_238 computeAABB(class_2350 up) {
        double offsetX = up.method_10148() == 0 ? 0.06 : 0.0;
        double offsetY = up.method_10164() == 0 ? 0.06 : 0.0;
        double offsetZ = up.method_10165() == 0 ? 0.06 : 0.0;
        double minX = Math.max(0.0, offsetX + (up.method_10148() < 0 ? 0.0 : (double)up.method_10148() * 0.0625));
        double minY = Math.max(0.0, offsetY + (up.method_10164() < 0 ? 0.0625 : (double)up.method_10164() * 0.0));
        double minZ = Math.max(0.0, offsetZ + (up.method_10165() < 0 ? 0.0 : (double)up.method_10165() * 0.0625));
        double maxX = Math.min(1.0, 1.0 - offsetX - (up.method_10148() < 0 ? 0.0625 : (double)up.method_10148() * 0.0));
        double maxY = Math.min(1.0, 1.0 - offsetY - (up.method_10164() < 0 ? 0.0 : (double)up.method_10164() * 0.0625));
        double maxZ = Math.min(1.0, 1.0 - offsetZ - (up.method_10165() < 0 ? 0.0625 : (double)up.method_10165() * 0.0));
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    static {
        for (class_2350 up : class_2350.values()) {
            class_238 aabb = SkyChestBlock.computeAABB(up);
            SHAPES.put(up, class_259.method_1078((class_238)aabb));
        }
    }

    public static enum SkyChestType {
        STONE,
        BLOCK;

    }
}

