/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.definitions.IBlockDefinition;
import appeng.api.features.AEFeature;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseBlockItemChargeable;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.BlockRendering;
import appeng.bootstrap.BlockRenderingCustomizer;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.components.IClientSetupComponent;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.AppEng;
import appeng.core.CreativeTab;
import appeng.core.features.BlockDefinition;
import appeng.core.features.TileDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

class BlockDefinitionBuilder
implements IBlockBuilder {
    private final FeatureFactory factory;
    private final class_2960 id;
    private final Supplier<? extends class_2248> blockSupplier;
    private final List<BiFunction<class_2248, class_1792, IBootstrapComponent>> bootstrapComponents = new ArrayList<BiFunction<class_2248, class_1792, IBootstrapComponent>>();
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private class_1761 itemGroup = CreativeTab.INSTANCE;
    private TileEntityDefinition tileEntityDefinition;
    private boolean disableItem = false;
    private BiFunction<class_2248, class_1792.class_1793, class_1747> itemFactory;
    @Environment(value=EnvType.CLIENT)
    private BlockRendering blockRendering;
    @Environment(value=EnvType.CLIENT)
    private ItemRendering itemRendering;

    BlockDefinitionBuilder(FeatureFactory factory, String id, Supplier<? extends class_2248> blockSupplier) {
        this.factory = factory;
        this.id = new class_2960("appliedenergistics2", id);
        this.blockSupplier = blockSupplier;
        if (Platform.hasClientClasses()) {
            this.blockRendering = new BlockRendering(this.id);
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public BlockDefinitionBuilder bootstrap(BiFunction<class_2248, class_1792, IBootstrapComponent> callback) {
        this.bootstrapComponents.add(callback);
        return this;
    }

    @Override
    public IBlockBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IBlockBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public BlockDefinitionBuilder rendering(BlockRenderingCustomizer callback) {
        if (Platform.hasClientClasses()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IBlockBuilder tileEntity(TileEntityDefinition tileEntityDefinition) {
        this.tileEntityDefinition = tileEntityDefinition;
        return this;
    }

    @Override
    public IBlockBuilder item(BiFunction<class_2248, class_1792.class_1793, class_1747> factory) {
        this.itemFactory = factory;
        return this;
    }

    @Override
    public IBlockBuilder disableItem() {
        this.disableItem = true;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    private void customizeForClient(BlockRenderingCustomizer callback) {
        callback.customize(this.blockRendering, this.itemRendering);
    }

    @Override
    public <T extends IBlockDefinition> T build() {
        class_2248 block = this.blockSupplier.get();
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)this.id, (Object)block);
        final class_1747 item = this.constructItemFromBlock(block);
        if (item != null) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)this.id, (Object)item);
        }
        if (item instanceof AEBaseBlockItemChargeable) {
            final AEBaseBlockItemChargeable chargeable = (AEBaseBlockItemChargeable)item;
            this.factory.addBootstrapComponent(new IClientSetupComponent(){

                @Override
                @Environment(value=EnvType.CLIENT)
                public void setup() {
                    FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)AppEng.makeId("fill_level"), (is, world, entity) -> {
                        double curPower = chargeable.getAECurrentPower(is);
                        double maxPower = chargeable.getAEMaxPower(is);
                        return (int)Math.round(100.0 * curPower / maxPower);
                    });
                }
            });
        }
        this.bootstrapComponents.forEach(component -> this.factory.addBootstrapComponent((IBootstrapComponent)component.apply(block, item)));
        if (this.tileEntityDefinition != null) {
            this.tileEntityDefinition.addBlock(block);
        }
        if (Platform.hasClientClasses()) {
            this.blockRendering.apply(this.factory, block);
            if (item != null) {
                this.itemRendering.apply(this.factory, (class_1792)item);
            }
        }
        BlockDefinition definition = block instanceof AEBaseTileBlock ? new TileDefinition(this.id.method_12832(), (AEBaseTileBlock)block, item, (Set<AEFeature>)this.features) : new BlockDefinition(this.id.method_12832(), block, item, this.features);
        if (this.itemGroup == CreativeTab.INSTANCE) {
            CreativeTab.add(definition);
        }
        return (T)definition;
    }

    @Nullable
    private class_1747 constructItemFromBlock(class_2248 block) {
        if (this.disableItem) {
            return null;
        }
        class_1792.class_1793 itemProperties = new class_1792.class_1793();
        if (this.itemGroup != null) {
            itemProperties.method_7892(this.itemGroup);
        }
        if (this.itemFactory != null) {
            return this.itemFactory.apply(block, itemProperties);
        }
        if (block instanceof AEBaseBlock) {
            return new AEBaseBlockItem(block, itemProperties);
        }
        return new class_1747(block, itemProperties);
    }
}

