/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.TileEntityRendering;
import appeng.bootstrap.TileEntityRenderingCustomizer;
import appeng.bootstrap.components.BlockEntityRendererComponent;
import appeng.bootstrap.definitions.TileEntityDefinition;
import appeng.core.AppEng;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockStackSrc;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public class BlockEntityBuilder<T extends AEBaseBlockEntity> {
    private final FeatureFactory factory;
    private final class_2960 id;
    private final Class<T> tileClass;
    private class_2591<T> type;
    private final Function<class_2591<T>, T> supplier;
    private TileEntityRendering<T> tileEntityRendering;
    private final List<class_2248> blocks = new ArrayList<class_2248>();
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);

    public BlockEntityBuilder(FeatureFactory factory, String id, Class<T> tileClass, Function<class_2591<T>, T> supplier) {
        this.factory = factory;
        this.id = AppEng.makeId(id);
        this.tileClass = tileClass;
        this.supplier = supplier;
        if (Platform.hasClientClasses()) {
            this.tileEntityRendering = new TileEntityRendering();
        }
    }

    public BlockEntityBuilder<T> features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    public BlockEntityBuilder<T> addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    public BlockEntityBuilder<T> rendering(TileEntityRenderingCustomizer<T> customizer) {
        customizer.customize(this.tileEntityRendering);
        return this;
    }

    public TileEntityDefinition build() {
        this.factory.addBootstrapComponent(() -> {
            if (this.blocks.isEmpty()) {
                throw new IllegalStateException("No blocks make use of this block entity: " + this.tileClass);
            }
            Supplier<AEBaseBlockEntity> factory = () -> (AEBaseBlockEntity)this.supplier.apply(this.type);
            this.type = class_2591.class_2592.method_20528(factory, (class_2248[])this.blocks.toArray(new class_2248[0])).method_11034(null);
            class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)this.id, this.type);
            AEBaseBlockEntity.registerTileItem(this.tileClass, new BlockStackSrc(this.blocks.get(0), ActivityState.Enabled));
            for (class_2248 block : this.blocks) {
                if (!(block instanceof AEBaseTileBlock)) continue;
                AEBaseTileBlock baseTileBlock = (AEBaseTileBlock)block;
                baseTileBlock.setTileEntity(this.tileClass, factory);
            }
            if (Platform.hasClientClasses()) {
                this.buildClient();
            }
        });
        return new TileEntityDefinition(this::addBlock);
    }

    @Environment(value=EnvType.CLIENT)
    private void buildClient() {
        if (this.tileEntityRendering.tileEntityRenderer != null) {
            this.factory.addBootstrapComponent(new BlockEntityRendererComponent<T>(this.type, this.tileEntityRendering.tileEntityRenderer));
        }
    }

    private void addBlock(class_2248 block) {
        Preconditions.checkState((this.type == null ? 1 : 0) != 0, (Object)"No more blocks can be added after registration completed.");
        this.blocks.add(block);
    }
}

