/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.bootstrap.BlockDefinitionBuilder;
import appeng.bootstrap.BlockEntityBuilder;
import appeng.bootstrap.EntityBuilder;
import appeng.bootstrap.IBlockBuilder;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemDefinitionBuilder;
import appeng.bootstrap.components.ModelOverrideComponent;
import appeng.tile.AEBaseBlockEntity;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public class FeatureFactory {
    private final AEFeature[] defaultFeatures;
    private final Map<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>> bootstrapComponents;
    @Environment(value=EnvType.CLIENT)
    private ModelOverrideComponent modelOverrideComponent;

    public FeatureFactory() {
        this.defaultFeatures = new AEFeature[]{AEFeature.CORE};
        this.bootstrapComponents = new HashMap<Class<? extends IBootstrapComponent>, List<IBootstrapComponent>>();
        if (Platform.hasClientClasses()) {
            this.modelOverrideComponent = new ModelOverrideComponent();
            this.addBootstrapComponent(this.modelOverrideComponent);
        }
    }

    private FeatureFactory(FeatureFactory parent, AEFeature ... defaultFeatures) {
        this.defaultFeatures = (AEFeature[])defaultFeatures.clone();
        this.bootstrapComponents = parent.bootstrapComponents;
        if (Platform.hasClientClasses()) {
            this.modelOverrideComponent = parent.modelOverrideComponent;
        }
    }

    public IBlockBuilder block(String id, Supplier<class_2248> block) {
        return new BlockDefinitionBuilder(this, id, block).features(this.defaultFeatures);
    }

    public IItemBuilder item(String id, Function<class_1792.class_1793, class_1792> itemFactory) {
        return new ItemDefinitionBuilder(this, id, itemFactory).features(this.defaultFeatures);
    }

    public <T extends class_1297> EntityBuilder<T> entity(String id, class_1299.class_4049<T> factory, class_1311 classification) {
        return new EntityBuilder<T>(this, id, factory, classification).features(this.defaultFeatures);
    }

    public <T extends AEBaseBlockEntity> BlockEntityBuilder<T> tileEntity(String id, Class<T> teClass, Function<class_2591<T>, T> factory) {
        return new BlockEntityBuilder<T>(this, id, teClass, factory).features(this.defaultFeatures);
    }

    public FeatureFactory features(AEFeature ... features) {
        return new FeatureFactory(this, features);
    }

    public void addBootstrapComponent(IBootstrapComponent component) {
        Arrays.stream(component.getClass().getInterfaces()).filter(i -> IBootstrapComponent.class.isAssignableFrom((Class<?>)i)).forEach(i -> this.addBootstrapComponent((Class<? extends IBootstrapComponent>)i, (IBootstrapComponent)component));
    }

    private <T extends IBootstrapComponent> void addBootstrapComponent(Class<? extends IBootstrapComponent> eventType, T component) {
        this.bootstrapComponents.computeIfAbsent(eventType, c -> new ArrayList()).add(component);
    }

    @Environment(value=EnvType.CLIENT)
    void addModelOverride(String resourcePath, BiFunction<class_2960, class_1087, class_1087> customizer) {
        this.modelOverrideComponent.addOverride(resourcePath, customizer);
    }

    public <T extends IBootstrapComponent> Iterator<T> getBootstrapComponents(Class<T> eventType) {
        return this.bootstrapComponents.getOrDefault(eventType, Collections.emptyList()).iterator();
    }
}

