/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.api.features.AEFeature;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.core.AppEng;
import appeng.core.CreativeTab;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

class ItemDefinitionBuilder
implements IItemBuilder {
    private final FeatureFactory factory;
    private final class_2960 id;
    private final Function<class_1792.class_1793, class_1792> itemFactory;
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private final List<Function<class_1792, IBootstrapComponent>> boostrapComponents = new ArrayList<Function<class_1792, IBootstrapComponent>>();
    private final class_1792.class_1793 props = new class_1792.class_1793();
    private Supplier<class_2357> dispenserBehaviorSupplier;
    @Environment(value=EnvType.CLIENT)
    private ItemRendering itemRendering;
    private class_1761 itemGroup = CreativeTab.INSTANCE;

    ItemDefinitionBuilder(FeatureFactory factory, String id, Function<class_1792.class_1793, class_1792> itemFactory) {
        this.factory = factory;
        this.id = AppEng.makeId(id);
        this.itemFactory = itemFactory;
        if (Platform.hasClientClasses()) {
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public IItemBuilder bootstrap(Function<class_1792, IBootstrapComponent> component) {
        this.boostrapComponents.add(component);
        return this;
    }

    @Override
    public IItemBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IItemBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public IItemBuilder itemGroup(class_1761 itemGroup) {
        this.itemGroup = itemGroup;
        return this;
    }

    @Override
    public IItemBuilder props(Consumer<class_1792.class_1793> consumer) {
        consumer.accept(this.props);
        return this;
    }

    @Override
    public IItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.hasClientClasses()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IItemBuilder dispenserBehavior(Supplier<class_2357> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize(this.itemRendering);
    }

    @Override
    public ItemDefinition build() {
        this.props.method_7892(this.itemGroup);
        class_1792 item = this.itemFactory.apply(this.props);
        ItemDefinition definition = new ItemDefinition(this.id.method_12832(), item, this.features);
        this.boostrapComponents.forEach(component -> this.factory.addBootstrapComponent((IBootstrapComponent)component.apply(item)));
        if (this.dispenserBehaviorSupplier != null) {
            this.factory.addBootstrapComponent(() -> {
                class_2357 behavior = this.dispenserBehaviorSupplier.get();
                class_2315.method_10009((class_1935)item, (class_2357)behavior);
            });
        }
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)this.id, (Object)item);
        if (Platform.hasClientClasses()) {
            this.itemRendering.apply(this.factory, item);
        }
        if (this.itemGroup == CreativeTab.INSTANCE) {
            CreativeTab.add(definition);
        }
        return definition;
    }
}

