/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.paint.PaintSplotchesModel;
import appeng.block.qnb.QnbFormedModel;
import appeng.bootstrap.ModelsReloadCallback;
import appeng.bootstrap.components.IClientSetupComponent;
import appeng.bootstrap.components.IItemColorRegistrationComponent;
import appeng.bootstrap.components.IModelBakeComponent;
import appeng.client.ActionKey;
import appeng.client.EffectType;
import appeng.client.gui.implementations.CellWorkbenchScreen;
import appeng.client.gui.implementations.ChestScreen;
import appeng.client.gui.implementations.CondenserScreen;
import appeng.client.gui.implementations.CraftAmountScreen;
import appeng.client.gui.implementations.CraftConfirmScreen;
import appeng.client.gui.implementations.CraftingCPUScreen;
import appeng.client.gui.implementations.CraftingStatusScreen;
import appeng.client.gui.implementations.CraftingTermScreen;
import appeng.client.gui.implementations.DriveScreen;
import appeng.client.gui.implementations.FormationPlaneScreen;
import appeng.client.gui.implementations.GrinderScreen;
import appeng.client.gui.implementations.IOPortScreen;
import appeng.client.gui.implementations.InscriberScreen;
import appeng.client.gui.implementations.InterfaceScreen;
import appeng.client.gui.implementations.InterfaceTerminalScreen;
import appeng.client.gui.implementations.LevelEmitterScreen;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.implementations.MEPortableCellScreen;
import appeng.client.gui.implementations.MolecularAssemblerScreen;
import appeng.client.gui.implementations.NetworkStatusScreen;
import appeng.client.gui.implementations.NetworkToolScreen;
import appeng.client.gui.implementations.PatternTermScreen;
import appeng.client.gui.implementations.PriorityScreen;
import appeng.client.gui.implementations.QNBScreen;
import appeng.client.gui.implementations.QuartzKnifeScreen;
import appeng.client.gui.implementations.SecurityStationScreen;
import appeng.client.gui.implementations.SkyChestScreen;
import appeng.client.gui.implementations.SpatialIOPortScreen;
import appeng.client.gui.implementations.StorageBusScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.implementations.VibrationChamberScreen;
import appeng.client.gui.implementations.WirelessScreen;
import appeng.client.gui.implementations.WirelessTermScreen;
import appeng.client.render.FacadeItemModel;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.cablebus.CableBusModelLoader;
import appeng.client.render.cablebus.P2PTunnelFrequencyModel;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.effects.ChargedOreFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.MatterCannonFX;
import appeng.client.render.effects.ParticleTypes;
import appeng.client.render.effects.VibrantFX;
import appeng.client.render.model.BiometricCardModel;
import appeng.client.render.model.ColorApplicatorModel;
import appeng.client.render.model.DriveModel;
import appeng.client.render.model.GlassModel;
import appeng.client.render.model.MemoryCardModel;
import appeng.client.render.model.SkyCompassModel;
import appeng.client.render.spatial.SpatialPylonModel;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.tesr.SkyChestTESR;
import appeng.container.implementations.CellWorkbenchContainer;
import appeng.container.implementations.ChestContainer;
import appeng.container.implementations.CondenserContainer;
import appeng.container.implementations.CraftAmountContainer;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.container.implementations.CraftingStatusContainer;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.DriveContainer;
import appeng.container.implementations.FormationPlaneContainer;
import appeng.container.implementations.GrinderContainer;
import appeng.container.implementations.IOPortContainer;
import appeng.container.implementations.InscriberContainer;
import appeng.container.implementations.InterfaceContainer;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.MEPortableCellContainer;
import appeng.container.implementations.MolecularAssemblerContainer;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.container.implementations.NetworkToolContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.PriorityContainer;
import appeng.container.implementations.QNBContainer;
import appeng.container.implementations.QuartzKnifeContainer;
import appeng.container.implementations.SecurityStationContainer;
import appeng.container.implementations.SkyChestContainer;
import appeng.container.implementations.SpatialIOPortContainer;
import appeng.container.implementations.StorageBusContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.container.implementations.VibrationChamberContainer;
import appeng.container.implementations.WirelessContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.ApiDefinitions;
import appeng.core.AppEng;
import appeng.core.AppEngBase;
import appeng.core.features.registries.PartModels;
import appeng.core.sync.network.ClientNetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.entity.ChargedQuartzEntity;
import appeng.entity.GrowingCrystalEntity;
import appeng.entity.SingularityEntity;
import appeng.entity.TinyTNTPrimedEntity;
import appeng.entity.TinyTNTPrimedRenderer;
import appeng.fluids.client.gui.FluidFormationPlaneScreen;
import appeng.fluids.client.gui.FluidIOScreen;
import appeng.fluids.client.gui.FluidInterfaceScreen;
import appeng.fluids.client.gui.FluidLevelEmitterScreen;
import appeng.fluids.client.gui.FluidStorageBusScreen;
import appeng.fluids.client.gui.FluidTerminalScreen;
import appeng.fluids.container.FluidFormationPlaneContainer;
import appeng.fluids.container.FluidIOContainer;
import appeng.fluids.container.FluidInterfaceContainer;
import appeng.fluids.container.FluidLevelEmitterContainer;
import appeng.fluids.container.FluidStorageBusContainer;
import appeng.fluids.container.FluidTerminalContainer;
import appeng.hooks.ClientTickHandler;
import appeng.parts.automation.PlaneModel;
import appeng.tile.crafting.MolecularAssemblerRenderer;
import appeng.util.Platform;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_746;
import net.minecraft.class_916;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public final class AppEngClient
extends AppEngBase {
    private static final String KEY_CATEGORY = "key.appliedenergistics2.category";
    private final class_310 client = class_310.method_1551();
    private final ClientNetworkHandler networkHandler = new ClientNetworkHandler();
    private final ClientTickHandler tickHandler = new ClientTickHandler();
    private final EnumMap<ActionKey, class_304> bindings;

    public static AppEngClient instance() {
        return (AppEngClient)AppEng.instance();
    }

    public AppEngClient() {
        ModelsReloadCallback.EVENT.register(this::onModelsReloaded);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> this.callDeferredBootstrapComponents(IClientSetupComponent.class, IClientSetupComponent::setup));
        this.registerModelProviders();
        this.registerParticleRenderers();
        this.registerEntityRenderers();
        this.registerItemColors();
        this.registerTextures();
        this.registerScreens();
        ServerLifecycleEvents.SERVER_STARTING.register(WorldData::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(WorldData::onServerStoppped);
        this.bindings = new EnumMap(ActionKey.class);
        for (ActionKey key : ActionKey.values()) {
            class_304 binding = new class_304(key.getTranslationKey(), key.getDefaultKey(), KEY_CATEGORY);
            KeyBindingHelper.registerKeyBinding((class_304)binding);
            this.bindings.put(key, binding);
        }
    }

    @Override
    public MinecraftServer getServer() {
        class_1132 server = this.client.method_1576();
        if (server != null) {
            return server;
        }
        throw new IllegalStateException("No server is currently running.");
    }

    @Override
    public boolean isOnServerThread() {
        class_1132 server = this.client.method_1576();
        return server != null && server.method_18854();
    }

    @Override
    public Stream<? extends class_1657> getPlayers() {
        return Stream.empty();
    }

    @Override
    public void spawnEffect(EffectType effect, class_1937 world, double posX, double posY, double posZ, Object extra) {
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        switch (this.client.field_1690.field_1882) {
            default: {
                return true;
            }
            case field_18198: {
                return r.nextBoolean();
            }
            case field_18199: 
        }
        return false;
    }

    @Override
    public class_239 getRTR() {
        return this.client.field_1765;
    }

    @Override
    public void postInit() {
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        if (Platform.isServer()) {
            return super.getCableRenderMode();
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        return this.getCableRenderModeForPlayer((class_1657)player);
    }

    public void triggerUpdates() {
        if (this.client.field_1724 == null || this.client.field_1687 == null) {
            return;
        }
        class_746 player = this.client.field_1724;
        int x = (int)player.method_23317();
        int y = (int)player.method_23318();
        int z = (int)player.method_23321();
        int range = 256;
        this.client.field_1769.method_18146(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public void setPartInteractionPlayer(class_1657 player) {
    }

    @Override
    public boolean isActionKey(@Nonnull ActionKey key, int keyCode, int scanCode) {
        return this.bindings.get((Object)key).method_1417(keyCode, scanCode);
    }

    protected void registerParticleRenderers() {
        ParticleFactoryRegistry particles = ParticleFactoryRegistry.getInstance();
        particles.register((class_2396)ParticleTypes.CHARGED_ORE, ChargedOreFX.Factory::new);
        particles.register((class_2396)ParticleTypes.CRAFTING, CraftingFx.Factory::new);
        particles.register(ParticleTypes.ENERGY, EnergyFx.Factory::new);
        particles.register(ParticleTypes.LIGHTNING_ARC, LightningArcFX.Factory::new);
        particles.register((class_2396)ParticleTypes.LIGHTNING, LightningFX.Factory::new);
        particles.register((class_2396)ParticleTypes.MATTER_CANNON, MatterCannonFX.Factory::new);
        particles.register((class_2396)ParticleTypes.VIBRANT, VibrantFX.Factory::new);
    }

    protected void registerEntityRenderers() {
        EntityRendererRegistry registry = EntityRendererRegistry.INSTANCE;
        registry.register(TinyTNTPrimedEntity.TYPE, (dispatcher, context) -> new TinyTNTPrimedRenderer(dispatcher));
        EntityRendererRegistry.Factory itemEntityFactory = (dispatcher, context) -> new class_916(dispatcher, context.getItemRenderer());
        registry.register(SingularityEntity.TYPE, itemEntityFactory);
        registry.register(GrowingCrystalEntity.TYPE, itemEntityFactory);
        registry.register(ChargedQuartzEntity.TYPE, itemEntityFactory);
    }

    protected void registerItemColors() {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IItemColorRegistrationComponent.class).forEachRemaining(IItemColorRegistrationComponent::register);
    }

    protected void onModelsReloaded(Map<class_2960, class_1087> loadedModels) {
        ApiDefinitions definitions = Api.INSTANCE.definitions();
        definitions.getRegistry().getBootstrapComponents(IModelBakeComponent.class).forEachRemaining(c -> c.onModelsReloaded(loadedModels));
    }

    public void registerTextures() {
        Stream<Collection> sprites = Stream.of(SkyChestTESR.SPRITES, InscriberTESR.SPRITES);
        Map<class_2960, List<class_4730>> groupedByAtlas = sprites.flatMap(Collection::stream).collect(Collectors.groupingBy(class_4730::method_24144));
        for (Map.Entry<class_2960, List<class_4730>> entry : groupedByAtlas.entrySet()) {
            ClientSpriteRegistryCallback.event((class_2960)entry.getKey()).register((spriteAtlasTexture, registry) -> {
                for (class_4730 spriteIdentifier : (List)entry.getValue()) {
                    registry.register(spriteIdentifier.method_24147());
                }
            });
        }
    }

    private void registerModelProviders() {
        ModelLoadingRegistry.INSTANCE.registerAppender((resourceManager, consumer) -> consumer.accept(MolecularAssemblerRenderer.LIGHTS_MODEL));
        ModelLoadingRegistry.INSTANCE.registerVariantProvider(resourceManager -> (modelIdentifier, modelProviderContext) -> {
            if (MolecularAssemblerRenderer.LIGHTS_MODEL.equals((Object)modelIdentifier)) {
                return modelProviderContext.loadModel(new class_2960(modelIdentifier.method_12836(), modelIdentifier.method_12832()));
            }
            return null;
        });
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(rm -> new CableBusModelLoader((PartModels)Api.INSTANCE.registries().partModels()));
        AppEngClient.addBuiltInModel("block/quartz_glass", GlassModel::new);
        AppEngClient.addBuiltInModel("block/sky_compass", SkyCompassModel::new);
        AppEngClient.addBuiltInModel("item/sky_compass", SkyCompassModel::new);
        AppEngClient.addBuiltInModel("item/memory_card", MemoryCardModel::new);
        AppEngClient.addBuiltInModel("item/biometric_card", BiometricCardModel::new);
        AppEngClient.addBuiltInModel("block/drive", DriveModel::new);
        AppEngClient.addBuiltInModel("color_applicator", ColorApplicatorModel::new);
        AppEngClient.addBuiltInModel("block/spatial_pylon", SpatialPylonModel::new);
        AppEngClient.addBuiltInModel("block/paint", PaintSplotchesModel::new);
        AppEngClient.addBuiltInModel("block/qnb/qnb_formed", QnbFormedModel::new);
        AppEngClient.addBuiltInModel("part/p2p/p2p_tunnel_frequency", P2PTunnelFrequencyModel::new);
        AppEngClient.addBuiltInModel("item/facade", FacadeItemModel::new);
        AppEngClient.addPlaneModel("part/annihilation_plane", "part/annihilation_plane");
        AppEngClient.addPlaneModel("part/annihilation_plane_on", "part/annihilation_plane_on");
        AppEngClient.addPlaneModel("part/identity_annihilation_plane", "part/identity_annihilation_plane");
        AppEngClient.addPlaneModel("part/identity_annihilation_plane_on", "part/identity_annihilation_plane_on");
        AppEngClient.addPlaneModel("part/fluid_annihilation_plane", "part/fluid_annihilation_plane");
        AppEngClient.addPlaneModel("part/fluid_annihilation_plane_on", "part/fluid_annihilation_plane_on");
        AppEngClient.addPlaneModel("part/fluid_formation_plane", "part/fluid_formation_plane");
        AppEngClient.addPlaneModel("part/fluid_formation_plane_on", "part/fluid_formation_plane_on");
        AppEngClient.addPlaneModel("part/formation_plane", "part/formation_plane");
        AppEngClient.addPlaneModel("part/formation_plane_on", "part/formation_plane_on");
        AppEngClient.addBuiltInModel("block/crafting/1k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_1K));
        AppEngClient.addBuiltInModel("block/crafting/4k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_4K));
        AppEngClient.addBuiltInModel("block/crafting/16k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_16K));
        AppEngClient.addBuiltInModel("block/crafting/64k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_64K));
        AppEngClient.addBuiltInModel("block/crafting/accelerator_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR));
        AppEngClient.addBuiltInModel("block/crafting/monitor_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.MONITOR));
        AppEngClient.addBuiltInModel("block/crafting/unit_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.UNIT));
    }

    private static void addPlaneModel(String planeName, String frontTexture) {
        class_2960 frontTextureId = AppEng.makeId(frontTexture);
        class_2960 sidesTextureId = AppEng.makeId("part/plane_sides");
        class_2960 backTextureId = AppEng.makeId("part/transition_plane_back");
        AppEngClient.addBuiltInModel(planeName, () -> new PlaneModel(frontTextureId, sidesTextureId, backTextureId));
    }

    private static <T extends class_1100> void addBuiltInModel(String id, Supplier<T> modelFactory) {
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(resourceManager -> new SimpleModelLoader(AppEng.makeId(id), modelFactory));
    }

    private void registerScreens() {
        ScreenRegistry.register(GrinderContainer.TYPE, GrinderScreen::new);
        ScreenRegistry.register(QNBContainer.TYPE, QNBScreen::new);
        ScreenRegistry.register(SkyChestContainer.TYPE, SkyChestScreen::new);
        ScreenRegistry.register(ChestContainer.TYPE, ChestScreen::new);
        ScreenRegistry.register(WirelessContainer.TYPE, WirelessScreen::new);
        ScreenRegistry.register(MEMonitorableContainer.TYPE, MEMonitorableScreen::new);
        ScreenRegistry.register(MEPortableCellContainer.TYPE, MEPortableCellScreen::new);
        ScreenRegistry.register(WirelessTermContainer.TYPE, WirelessTermScreen::new);
        ScreenRegistry.register(NetworkStatusContainer.TYPE, NetworkStatusScreen::new);
        ScreenRegistry.register(CraftingCPUContainer.TYPE, CraftingCPUScreen::new);
        ScreenRegistry.register(NetworkToolContainer.TYPE, NetworkToolScreen::new);
        ScreenRegistry.register(QuartzKnifeContainer.TYPE, QuartzKnifeScreen::new);
        ScreenRegistry.register(DriveContainer.TYPE, DriveScreen::new);
        ScreenRegistry.register(VibrationChamberContainer.TYPE, VibrationChamberScreen::new);
        ScreenRegistry.register(CondenserContainer.TYPE, CondenserScreen::new);
        ScreenRegistry.register(InterfaceContainer.TYPE, InterfaceScreen::new);
        ScreenRegistry.register(FluidInterfaceContainer.TYPE, FluidInterfaceScreen::new);
        ScreenRegistry.register(UpgradeableContainer.TYPE, UpgradeableScreen::new);
        ScreenRegistry.register(FluidIOContainer.TYPE, FluidIOScreen::new);
        ScreenRegistry.register(IOPortContainer.TYPE, IOPortScreen::new);
        ScreenRegistry.register(StorageBusContainer.TYPE, StorageBusScreen::new);
        ScreenRegistry.register(FluidStorageBusContainer.TYPE, FluidStorageBusScreen::new);
        ScreenRegistry.register(FormationPlaneContainer.TYPE, FormationPlaneScreen::new);
        ScreenRegistry.register(FluidFormationPlaneContainer.TYPE, FluidFormationPlaneScreen::new);
        ScreenRegistry.register(PriorityContainer.TYPE, PriorityScreen::new);
        ScreenRegistry.register(SecurityStationContainer.TYPE, SecurityStationScreen::new);
        ScreenRegistry.register(CraftingTermContainer.TYPE, CraftingTermScreen::new);
        ScreenRegistry.register(PatternTermContainer.TYPE, PatternTermScreen::new);
        ScreenRegistry.register(FluidTerminalContainer.TYPE, FluidTerminalScreen::new);
        ScreenRegistry.register(LevelEmitterContainer.TYPE, LevelEmitterScreen::new);
        ScreenRegistry.register(FluidLevelEmitterContainer.TYPE, FluidLevelEmitterScreen::new);
        ScreenRegistry.register(SpatialIOPortContainer.TYPE, SpatialIOPortScreen::new);
        ScreenRegistry.register(InscriberContainer.TYPE, InscriberScreen::new);
        ScreenRegistry.register(CellWorkbenchContainer.TYPE, CellWorkbenchScreen::new);
        ScreenRegistry.register(MolecularAssemblerContainer.TYPE, MolecularAssemblerScreen::new);
        ScreenRegistry.register(CraftAmountContainer.TYPE, CraftAmountScreen::new);
        ScreenRegistry.register(CraftConfirmContainer.TYPE, CraftConfirmScreen::new);
        ScreenRegistry.register(InterfaceTerminalContainer.TYPE, InterfaceTerminalScreen::new);
        ScreenRegistry.register(CraftingStatusContainer.TYPE, CraftingStatusScreen::new);
    }
}

