/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import alexiil.mc.lib.attributes.fluid.render.FluidRenderFace;
import alexiil.mc.lib.attributes.fluid.render.FluidVolumeRenderer;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.Size1Slot;
import appeng.client.gui.widgets.CustomSlotWidget;
import appeng.client.gui.widgets.ITickingWidget;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotDisconnected;
import appeng.client.me.SlotME;
import appeng.client.render.StackSizeRenderer;
import appeng.container.AEBaseContainer;
import appeng.container.slot.AppEngCraftingSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.container.slot.DisabledSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlot;
import appeng.container.slot.InaccessibleSlot;
import appeng.container.slot.OutputSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.core.sync.packets.SwapSlotsPacket;
import appeng.fluids.client.render.FluidStackSizeRenderer;
import appeng.fluids.container.slots.IMEFluidSlot;
import appeng.helpers.InventoryAction;
import appeng.mixins.SlotMixin;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public abstract class AEBaseScreen<T extends AEBaseContainer>
extends class_465<T> {
    public static final int COLOR_DARK_GRAY = 0x404040;
    private final List<InternalSlotME> meSlots = new ArrayList<InternalSlotME>();
    private final Set<class_1735> drag_click = new HashSet<class_1735>();
    private final StackSizeRenderer stackSizeRenderer = new StackSizeRenderer();
    private final FluidStackSizeRenderer fluidStackSizeRenderer = new FluidStackSizeRenderer();
    private Scrollbar myScrollBar = null;
    private boolean disableShiftClick = false;
    private Stopwatch dbl_clickTimer = Stopwatch.createStarted();
    private class_1799 dbl_whichItem = class_1799.field_8037;
    private class_1735 bl_clicked;
    private boolean handlingRightClick;
    protected final List<CustomSlotWidget> guiSlots = new ArrayList<CustomSlotWidget>();
    private static final class_2583 TOOLTIP_HEADER = class_2583.field_24360.method_10977(class_124.field_1068);
    private static final class_2583 TOOLTIP_BODY = class_2583.field_24360.method_10977(class_124.field_1080);

    public AEBaseScreen(T container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    public class_310 getClient() {
        return (class_310)Preconditions.checkNotNull((Object)this.field_22787);
    }

    public int getX() {
        return this.field_2776;
    }

    public int getY() {
        return this.field_2800;
    }

    public void method_25426() {
        super.method_25426();
        List<class_1735> slots = this.getInventorySlots();
        slots.removeIf(slot -> slot instanceof SlotME);
        for (InternalSlotME me : this.meSlots) {
            slots.add(new SlotME(me));
        }
    }

    private List<class_1735> getInventorySlots() {
        return ((AEBaseContainer)this.field_2797).field_7761;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        super.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_2776, (float)this.field_2800, (float)0.0f);
        RenderSystem.enableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            this.drawGuiSlot(matrices, c, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableDepthTest();
        for (CustomSlotWidget c : this.guiSlots) {
            this.drawTooltip(matrices, c, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
        this.method_2380(matrices, mouseX, mouseY);
        for (CustomSlotWidget c : this.field_22791) {
            if (!(c instanceof ITooltip)) continue;
            this.drawTooltip(matrices, c, mouseX, mouseY);
        }
    }

    protected void drawGuiSlot(class_4587 matrices, CustomSlotWidget slot, int mouseX, int mouseY, float partialTicks) {
        if (slot.isSlotEnabled()) {
            int left = slot.getTooltipAreaX();
            int top = slot.getTooltipAreaY();
            int right = left + slot.getTooltipAreaWidth();
            int bottom = top + slot.getTooltipAreaHeight();
            slot.drawContent(this.getClient(), mouseX, mouseY, partialTicks);
            if (this.method_2378(left, top, slot.getTooltipAreaWidth(), slot.getTooltipAreaHeight(), mouseX, mouseY) && slot.canClick((class_1657)this.getPlayer())) {
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.method_25296(matrices, left, top, right, bottom, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
    }

    private void drawTooltip(class_4587 matrices, ITooltip tooltip, int mouseX, int mouseY) {
        int x = tooltip.getTooltipAreaX();
        int y = tooltip.getTooltipAreaY();
        if (x < mouseX && x + tooltip.getTooltipAreaWidth() > mouseX && tooltip.isTooltipAreaVisible() && y < mouseY && y + tooltip.getTooltipAreaHeight() > mouseY) {
            if (y < 15) {
                y = 15;
            }
            class_2561 msg = tooltip.getTooltipMessage();
            this.drawTooltip(matrices, x + 11, y + 4, msg);
        }
    }

    protected void drawTooltip(class_4587 matrices, int x, int y, class_2561 message) {
        String tooltipText = message.getString();
        if (!tooltipText.isEmpty()) {
            String[] lines = tooltipText.split("\n");
            List<class_2561> textLines = Arrays.stream(lines).map(class_2585::new).collect(Collectors.toList());
            this.drawTooltip(matrices, x, y, textLines);
        }
    }

    protected void drawTooltip(class_4587 matrices, int x, int y, List<class_2561> lines) {
        if (lines.isEmpty()) {
            return;
        }
        ArrayList<class_5250> styledLines = new ArrayList<class_5250>(lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            class_2583 style = i == 0 ? TOOLTIP_HEADER : TOOLTIP_BODY;
            styledLines.add(lines.get(i).method_27662().method_27694(s -> style));
        }
        this.method_30901(matrices, styledLines, x, y);
    }

    protected final void method_2388(class_4587 matrices, int x, int y) {
        int ox = this.field_2776;
        int oy = this.field_2800;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getScrollBar() != null) {
            this.getScrollBar().draw(matrices, this);
        }
        this.drawFG(matrices, ox, oy, x, y);
    }

    public abstract void drawFG(class_4587 var1, int var2, int var3, int var4, int var5);

    protected final void method_2389(class_4587 matrices, float f, int x, int y) {
        int ox = this.field_2776;
        int oy = this.field_2800;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(matrices, ox, oy, x, y, f);
        List<class_1735> slots = this.getInventorySlots();
        for (class_1735 class_17352 : slots) {
            IOptionalSlot optionalSlot;
            if (!(class_17352 instanceof IOptionalSlot) || !(optionalSlot = (IOptionalSlot)class_17352).isRenderDisabled()) continue;
            AppEngSlot aeSlot = (AppEngSlot)class_17352;
            if (aeSlot.isSlotEnabled()) {
                this.method_25302(matrices, ox + aeSlot.field_7873 - 1, oy + aeSlot.field_7872 - 1, optionalSlot.getSourceX() - 1, optionalSlot.getSourceY() - 1, 18, 18);
                continue;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            RenderSystem.enableBlend();
            this.method_25302(matrices, ox + aeSlot.field_7873 - 1, oy + aeSlot.field_7872 - 1, optionalSlot.getSourceX() - 1, optionalSlot.getSourceY() - 1, 18, 18);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (CustomSlotWidget customSlotWidget : this.guiSlots) {
            customSlotWidget.drawBackground(matrices, ox, oy, this.method_25305());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        this.drag_click.clear();
        if (btn == 1) {
            this.handlingRightClick = true;
            try {
                for (CustomSlotWidget o : this.field_22791) {
                    class_339 widget = (class_339)o;
                    if (!widget.method_25405(xCoord, yCoord)) continue;
                    boolean bl = super.method_25402(xCoord, yCoord, 0);
                    return bl;
                }
            }
            finally {
                this.handlingRightClick = false;
            }
        }
        for (CustomSlotWidget slot : this.guiSlots) {
            if (!this.method_2378(slot.getTooltipAreaX(), slot.getTooltipAreaY(), slot.getTooltipAreaWidth(), slot.getTooltipAreaHeight(), xCoord, yCoord) || !slot.canClick((class_1657)this.getPlayer())) continue;
            slot.slotClicked(this.getPlayer().field_7514.method_7399(), btn);
        }
        if (btn == 0 && this.getScrollBar() != null && this.getScrollBar().mouseDown(xCoord - (double)this.field_2776, yCoord - (double)this.field_2800)) {
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.getScrollBar() != null && this.getScrollBar().mouseUp(mouseX - (double)this.field_2776, mouseY - (double)this.field_2800)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        class_1735 slot = this.getSlot((int)mouseX, (int)mouseY);
        class_1799 itemstack = this.getPlayer().field_7514.method_7399();
        if (this.getScrollBar() != null) {
            this.getScrollBar().mouseDragged((int)mouseX - this.field_2776, (int)mouseY - this.field_2800);
        }
        if (slot instanceof FakeSlot && !itemstack.method_7960()) {
            this.drag_click.add(slot);
            if (this.drag_click.size() > 1) {
                for (class_1735 dr : this.drag_click) {
                    InventoryActionPacket p = new InventoryActionPacket(mouseButton == 0 ? InventoryAction.PICKUP_OR_SET_DOWN : InventoryAction.PLACE_SINGLE, dr.field_7874, 0L);
                    NetworkHandler.instance().sendToServer(p);
                }
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    protected void method_2383(class_1735 slot, int slotIdx, int mouseButton, class_1713 clickType) {
        class_746 player = this.getPlayer();
        if (slot instanceof FakeSlot) {
            InventoryAction action;
            InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
            if (this.drag_click.size() > 1) {
                return;
            }
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof PatternTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            NetworkHandler.instance().sendToServer(((PatternTermSlot)slot).getRequest(AEBaseScreen.method_25442()));
        } else if (slot instanceof CraftingTermSlot) {
            if (mouseButton == 6) {
                return;
            }
            InventoryAction action = AEBaseScreen.method_25442() ? InventoryAction.CRAFT_SHIFT : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM);
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)32) && this.enableSpaceClicking()) {
            IAEItemStack stack = null;
            if (slot instanceof SlotME) {
                stack = ((SlotME)slot).getAEStack();
            }
            int slotNum = this.getInventorySlots().size();
            if (!(slot instanceof SlotME) && slot != null) {
                slotNum = slot.field_7874;
            }
            ((AEBaseContainer)this.field_2797).setTargetStack(stack);
            InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slotNum, 0L);
            NetworkHandler.instance().sendToServer(p);
            return;
        }
        if (slot instanceof SlotDisconnected) {
            InventoryAction action = null;
            switch (clickType) {
                case field_7790: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case field_7796: {
                    if (!player.method_7337()) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, this.getSlotIndex(slot), ((SlotDisconnected)slot).getSlot().getId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        if (slot instanceof SlotME) {
            InventoryAction action = null;
            IAEItemStack stack = null;
            switch (clickType) {
                case field_7790: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack == null || action != InventoryAction.PICKUP_OR_SET_DOWN || stack.getStackSize() != 0L || !player.field_7514.method_7399().method_7960()) break;
                    action = InventoryAction.AUTO_CRAFT;
                    break;
                }
                case field_7794: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    stack = ((SlotME)slot).getAEStack();
                    break;
                }
                case field_7796: {
                    IAEItemStack slotItem;
                    stack = ((SlotME)slot).getAEStack();
                    if (stack != null && stack.isCraftable()) {
                        action = InventoryAction.AUTO_CRAFT;
                        break;
                    }
                    if (!player.method_7337() || (slotItem = ((SlotME)slot).getAEStack()) == null) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((AEBaseContainer)this.field_2797).setTargetStack(stack);
                InventoryActionPacket p = new InventoryActionPacket(action, this.getInventorySlots().size(), 0L);
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        if (!this.disableShiftClick && AEBaseScreen.method_25442() && mouseButton == 0) {
            this.disableShiftClick = true;
            if (this.dbl_whichItem.method_7960() || this.bl_clicked != slot || this.dbl_clickTimer.elapsed(TimeUnit.MILLISECONDS) > 250L) {
                this.bl_clicked = slot;
                this.dbl_clickTimer = Stopwatch.createStarted();
                this.dbl_whichItem = slot != null ? (slot.method_7681() ? slot.method_7677().method_7972() : class_1799.field_8037) : class_1799.field_8037;
            } else if (!this.dbl_whichItem.method_7960()) {
                List<class_1735> slots = this.getInventorySlots();
                for (class_1735 inventorySlot : slots) {
                    if (inventorySlot == null || !inventorySlot.method_7674((class_1657)this.getPlayer()) || !inventorySlot.method_7681() || inventorySlot.field_7871 != slot.field_7871 || !class_1703.method_7592((class_1735)inventorySlot, (class_1799)this.dbl_whichItem, (boolean)true)) continue;
                    this.method_2383(inventorySlot, inventorySlot.field_7874, 0, class_1713.field_7794);
                }
                this.dbl_whichItem = class_1799.field_8037;
            }
            this.disableShiftClick = false;
        }
        super.method_2383(slot, slotIdx, mouseButton, clickType);
    }

    protected class_746 getPlayer() {
        return (class_746)Preconditions.checkNotNull((Object)this.getClient().field_1724);
    }

    protected int getSlotIndex(class_1735 slot) {
        return ((SlotMixin)slot).getIndex();
    }

    protected boolean checkHotbarKeys(int keyCode, int scanCode) {
        class_1735 theSlot = this.field_2787;
        if (this.getPlayer().field_7514.method_7399().method_7960() && theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (!this.getClient().field_1690.field_1852[j].method_1417(keyCode, scanCode)) continue;
                List<class_1735> slots = this.getInventorySlots();
                for (class_1735 s : slots) {
                    if (this.getSlotIndex(s) != j || s.field_7871 != ((AEBaseContainer)this.field_2797).getPlayerInv() || s.method_7674(((AEBaseContainer)this.field_2797).getPlayerInv().field_7546)) continue;
                    return false;
                }
                if (theSlot.method_7675() == 64) {
                    this.method_2383(theSlot, theSlot.field_7874, j, class_1713.field_7791);
                    return true;
                }
                for (class_1735 s : slots) {
                    if (this.getSlotIndex(s) != j || s.field_7871 != ((AEBaseContainer)this.field_2797).getPlayerInv()) continue;
                    NetworkHandler.instance().sendToServer(new SwapSlotsPacket(s.field_7874, theSlot.field_7874));
                    return true;
                }
            }
        }
        return false;
    }

    public void method_25432() {
        super.method_25432();
    }

    protected class_1735 getSlot(int mouseX, int mouseY) {
        List<class_1735> slots = this.getInventorySlots();
        for (class_1735 slot : slots) {
            if (!this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public abstract void drawBG(class_4587 var1, int var2, int var3, int var4, int var5, float var6);

    public boolean method_25401(double x, double y, double wheelDelta) {
        if (wheelDelta != 0.0 && AEBaseScreen.method_25442()) {
            this.mouseWheelEvent(x, y, wheelDelta / Math.abs(wheelDelta));
            return true;
        }
        if (wheelDelta != 0.0 && this.getScrollBar() != null) {
            this.getScrollBar().wheel(wheelDelta);
            return true;
        }
        return false;
    }

    private void mouseWheelEvent(double x, double y, double wheel) {
        IAEItemStack item;
        class_1735 slot = this.getSlot((int)x, (int)y);
        if (slot instanceof SlotME && (item = ((SlotME)slot).getAEStack()) != null) {
            ((AEBaseContainer)this.field_2797).setTargetStack(item);
            InventoryAction direction = wheel > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheel);
            int inventorySize = this.getInventorySlots().size();
            for (int h = 0; h < times; ++h) {
                InventoryActionPacket p = new InventoryActionPacket(direction, inventorySize, 0L);
                NetworkHandler.instance().sendToServer(p);
            }
        }
    }

    protected boolean enableSpaceClicking() {
        return true;
    }

    public void bindTexture(String base, String file) {
        class_2960 loc = new class_2960(base, "textures/" + file);
        this.getClient().method_1531().method_22813(loc);
    }

    protected void drawItem(int x, int y, class_1799 is) {
        this.field_22788.field_4730 = 100.0f;
        this.field_22788.method_4023(is, x, y);
        this.field_22788.field_4730 = 0.0f;
    }

    protected class_2561 getGuiDisplayName(class_2561 in) {
        return this.field_22785.getString().isEmpty() ? in : this.field_22785;
    }

    public void method_2385(class_4587 matrices, class_1735 s) {
        if (s instanceof SlotME) {
            try {
                if (!this.isPowered()) {
                    AEBaseScreen.method_25294((class_4587)matrices, (int)s.field_7873, (int)s.field_7872, (int)(16 + s.field_7873), (int)(16 + s.field_7872), (int)0x66111111);
                }
                super.method_2385(matrices, (class_1735)new Size1Slot((SlotME)s));
                this.stackSizeRenderer.renderStackSize(this.field_22793, ((SlotME)s).getAEStack(), s.field_7873, s.field_7872);
            }
            catch (Exception err) {
                AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            }
            return;
        }
        if (s instanceof IMEFluidSlot && ((IMEFluidSlot)s).shouldRenderAsFluid()) {
            IMEFluidSlot slot = (IMEFluidSlot)s;
            IAEFluidStack fs = slot.getAEFluidStack();
            if (fs != null && this.isPowered()) {
                ArrayList<FluidRenderFace> faces = new ArrayList<FluidRenderFace>();
                faces.add(FluidRenderFace.createFlatFaceZ((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.0, (double)0.0625, (boolean)false, (boolean)false));
                matrices.method_22903();
                matrices.method_22904((double)s.field_7873, (double)s.field_7872, 0.0);
                FluidVolume fluidStack = fs.getFluidStack();
                fluidStack.render(faces, (class_4597)FluidVolumeRenderer.VCPS, matrices);
                RenderSystem.runAsFancy(() -> ((FluidVolumeRenderer.ExpandingVcp)FluidVolumeRenderer.VCPS).draw());
                matrices.method_22909();
                this.fluidStackSizeRenderer.renderStackSize(this.field_22793, fs, s.field_7873, s.field_7872);
            } else if (!this.isPowered()) {
                AEBaseScreen.method_25294((class_4587)matrices, (int)s.field_7873, (int)s.field_7872, (int)(16 + s.field_7873), (int)(16 + s.field_7872), (int)0x66111111);
            }
            return;
        }
        try {
            AppEngSlot aes;
            class_1799 is = s.method_7677();
            if (s instanceof AppEngSlot && (((AppEngSlot)s).renderIconWithItem() || is.method_7960()) && ((AppEngSlot)s).shouldDisplay() && (aes = (AppEngSlot)s).getIcon() >= 0) {
                this.bindTexture("guis/states.png");
                try {
                    int uv_y = aes.getIcon() / 16;
                    int uv_x = aes.getIcon() - uv_y * 16;
                    RenderSystem.enableBlend();
                    RenderSystem.enableTexture();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float par1 = aes.field_7873;
                    float par2 = aes.field_7872;
                    float par3 = uv_x * 16;
                    float par4 = uv_y * 16;
                    class_289 tessellator = class_289.method_1348();
                    class_287 vb = tessellator.method_1349();
                    vb.method_1328(7, class_290.field_20887);
                    float f1 = 0.00390625f;
                    float f = 0.00390625f;
                    float par6 = 16.0f;
                    vb.method_22912((double)(par1 + 0.0f), (double)(par2 + 16.0f), (double)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).method_22913((par3 + 0.0f) * 0.00390625f, (par4 + 16.0f) * 0.00390625f).method_1344();
                    float par5 = 16.0f;
                    vb.method_22912((double)(par1 + 16.0f), (double)(par2 + 16.0f), (double)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).method_22913((par3 + 16.0f) * 0.00390625f, (par4 + 16.0f) * 0.00390625f).method_1344();
                    vb.method_22912((double)(par1 + 16.0f), (double)(par2 + 0.0f), (double)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).method_22913((par3 + 16.0f) * 0.00390625f, (par4 + 0.0f) * 0.00390625f).method_1344();
                    vb.method_22912((double)(par1 + 0.0f), (double)(par2 + 0.0f), (double)this.method_25305()).method_22915(1.0f, 1.0f, 1.0f, aes.getOpacityOfIcon()).method_22913((par3 + 0.0f) * 0.00390625f, (par4 + 0.0f) * 0.00390625f).method_1344();
                    tessellator.method_1350();
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
            if (!is.method_7960() && s instanceof AppEngSlot) {
                AppEngSlot aeSlot = (AppEngSlot)s;
                if (aeSlot.getIsValid() == AppEngSlot.CalculatedValidity.NotAvailable) {
                    boolean isValid;
                    boolean bl = isValid = s.method_7680(is) || s instanceof OutputSlot || s instanceof AppEngCraftingSlot || s instanceof DisabledSlot || s instanceof InaccessibleSlot || s instanceof FakeSlot || s instanceof RestrictedInputSlot || s instanceof SlotDisconnected;
                    if (isValid && s instanceof RestrictedInputSlot) {
                        try {
                            isValid = ((RestrictedInputSlot)s).isValid(is, (class_1937)this.getClient().field_1687);
                        }
                        catch (Exception err) {
                            AELog.debug(err);
                        }
                    }
                    aeSlot.setIsValid(isValid ? AppEngSlot.CalculatedValidity.Valid : AppEngSlot.CalculatedValidity.Invalid);
                }
                if (aeSlot.getIsValid() == AppEngSlot.CalculatedValidity.Invalid) {
                    this.method_25304(100);
                    this.field_22788.field_4730 = 100.0f;
                    AEBaseScreen.method_25294((class_4587)matrices, (int)s.field_7873, (int)s.field_7872, (int)(16 + s.field_7873), (int)(16 + s.field_7872), (int)0x66FF6666);
                    this.method_25304(0);
                    this.field_22788.field_4730 = 0.0f;
                }
            }
            if (s instanceof AppEngSlot) {
                ((AppEngSlot)s).setDisplay(true);
                super.method_2385(matrices, s);
            } else {
                super.method_2385(matrices, s);
            }
            return;
        }
        catch (Exception err) {
            AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err.toString(), new Object[0]);
            super.method_2385(matrices, s);
            return;
        }
    }

    protected boolean isPowered() {
        return true;
    }

    public void bindTexture(String file) {
        class_2960 loc = new class_2960("appliedenergistics2", "textures/" + file);
        this.getClient().method_1531().method_22813(loc);
    }

    public void bindTexture(class_2960 loc) {
        this.getClient().method_1531().method_22813(loc);
    }

    protected Scrollbar getScrollBar() {
        return this.myScrollBar;
    }

    protected void setScrollBar(Scrollbar myScrollBar) {
        this.myScrollBar = myScrollBar;
    }

    protected List<InternalSlotME> getMeSlots() {
        return this.meSlots;
    }

    public void method_25393() {
        super.method_25393();
        if (this.getScrollBar() != null) {
            this.getScrollBar().tick();
        }
        for (class_364 child : this.field_22786) {
            if (!(child instanceof ITickingWidget)) continue;
            ((ITickingWidget)child).tick();
        }
    }

    public boolean isHandlingRightClick() {
        return this.handlingRightClick;
    }

    public List<Rectangle> getExclusionZones() {
        return Lists.newArrayList((Object[])new Rectangle[]{new Rectangle(this.field_2776, this.field_2800, this.field_2792, this.field_2779)});
    }
}

