/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.ChestContainer;
import appeng.container.implementations.CraftingTermContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.implementations.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.IPriorityHost;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import appeng.tile.storage.ChestBlockEntity;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_918;

final class AESubScreen {
    private final AEBaseScreen<?> gui;
    private final class_3917<?> previousContainerType;
    private final class_1799 previousContainerIcon;

    public AESubScreen(AEBaseScreen<?> gui, Object containerTarget) {
        this.gui = gui;
        IDefinitions definitions = Api.instance().definitions();
        IParts parts = definitions.parts();
        if (containerTarget instanceof ChestBlockEntity) {
            IPriorityHost priorityHost = (IPriorityHost)containerTarget;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = ChestContainer.TYPE;
        } else if (containerTarget instanceof IPriorityHost) {
            IPriorityHost priorityHost = (IPriorityHost)containerTarget;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = priorityHost.getContainerType();
        } else if (containerTarget instanceof WirelessTerminalGuiObject) {
            this.previousContainerIcon = definitions.items().wirelessTerminal().maybeStack(1).orElse(class_1799.field_8037);
            this.previousContainerType = WirelessTermContainer.TYPE;
        } else if (containerTarget instanceof TerminalPart) {
            this.previousContainerIcon = parts.terminal().maybeStack(1).orElse(class_1799.field_8037);
            this.previousContainerType = MEMonitorableContainer.TYPE;
        } else if (containerTarget instanceof CraftingTerminalPart) {
            this.previousContainerIcon = parts.craftingTerminal().maybeStack(1).orElse(class_1799.field_8037);
            this.previousContainerType = CraftingTermContainer.TYPE;
        } else if (containerTarget instanceof PatternTerminalPart) {
            this.previousContainerIcon = parts.patternTerminal().maybeStack(1).orElse(class_1799.field_8037);
            this.previousContainerType = PatternTermContainer.TYPE;
        } else {
            this.previousContainerIcon = null;
            this.previousContainerType = null;
        }
    }

    public final TabButton addBackButton(Consumer<TabButton> buttonAdder, int x, int y) {
        return this.addBackButton(buttonAdder, x, y, null);
    }

    public final TabButton addBackButton(Consumer<TabButton> buttonAdder, int x, int y, @Nullable class_2561 label) {
        if (this.previousContainerType != null && !this.previousContainerIcon.method_7960()) {
            if (label == null) {
                label = this.previousContainerIcon.method_7964();
            }
            class_918 itemRenderer = this.gui.getClient().method_1480();
            TabButton button = new TabButton(this.gui.getX() + x, this.gui.getY() + y, this.previousContainerIcon, label, itemRenderer, btn -> this.goBack());
            buttonAdder.accept(button);
            return button;
        }
        return null;
    }

    public final void goBack() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(this.previousContainerType));
    }
}

