/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.implementations.CraftConfirmContainer;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.util.Platform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmContainer> {
    private final AESubScreen subGui;
    private final int rows = 5;
    private final IItemList<IAEItemStack> storage = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IItemList<IAEItemStack> pending = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final IItemList<IAEItemStack> missing = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private class_4185 start;
    private class_4185 selectCPU;
    private int tooltip = -1;

    public CraftConfirmScreen(CraftConfirmContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.subGui = new AESubScreen(this, container.getTarget());
        this.field_2792 = 238;
        this.field_2779 = 206;
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.start = new class_4185(this.field_2776 + 162, this.field_2800 + this.field_2779 - 25, 50, 20, GuiText.Start.text(), btn -> this.start());
        this.start.field_22763 = false;
        this.method_25411((class_339)this.start);
        this.selectCPU = new class_4185(this.field_2776 + 19, this.field_2800 + this.field_2779 - 68, 180, 20, this.getNextCpuButtonLabel(), btn -> this.selectNextCpu());
        this.selectCPU.field_22763 = false;
        this.method_25411((class_339)this.selectCPU);
        this.method_25411((class_339)new class_4185(this.field_2776 + 6, this.field_2800 + this.field_2779 - 25, 50, 20, GuiText.Cancel.text(), btn -> this.subGui.goBack()));
        this.setScrollBar();
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float btn) {
        this.updateCPUButtonText();
        this.start.field_22763 = !((CraftConfirmContainer)this.field_2797).hasNoCPU() && !this.isSimulation();
        this.selectCPU.field_22763 = !this.isSimulation();
        int gx = (this.field_22789 - this.field_2792) / 2;
        int gy = (this.field_22790 - this.field_2779) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        super.method_25394(matrices, mouseX, mouseY, btn);
    }

    private void updateCPUButtonText() {
        this.selectCPU.method_25355(this.getNextCpuButtonLabel());
    }

    private class_2561 getNextCpuButtonLabel() {
        if (((CraftConfirmContainer)this.field_2797).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        class_2561 cpuName = ((CraftConfirmContainer)this.field_2797).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmContainer)this.field_2797).cpuName;
        return GuiText.CraftingCPU.withSuffix(": ").method_10852(cpuName);
    }

    private boolean isSimulation() {
        return ((CraftConfirmContainer)this.field_2797).isSimulation();
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        long BytesUsed = ((CraftConfirmContainer)this.field_2797).getUsedBytes();
        String byteUsed = NumberFormat.getInstance().format(BytesUsed);
        class_2561 Add = BytesUsed > 0L ? new class_2585(byteUsed + " ").method_10852(GuiText.BytesUsed.text()) : GuiText.CalculatingWait.text();
        this.field_22793.method_30883(matrices, (class_2561)GuiText.CraftingPlan.withSuffix(" - ").method_10852(Add), 8.0f, 7.0f, 0x404040);
        Object dsp = this.isSimulation() ? GuiText.Simulation.text() : (((CraftConfirmContainer)this.field_2797).getCpuAvailableBytes() > 0L ? GuiText.Bytes.withSuffix(": " + ((CraftConfirmContainer)this.field_2797).getCpuAvailableBytes() + " : ").method_10852(GuiText.CoProcessors.text()).method_27693(": " + ((CraftConfirmContainer)this.field_2797).getCpuCoProcessors()) : GuiText.Bytes.withSuffix(": N/A : ").method_10852(GuiText.CoProcessors.text()).method_27693(": N/A"));
        int offset = (219 - this.field_22793.method_27525((class_5348)dsp)) / 2;
        this.field_22793.method_30883(matrices, dsp, (float)offset, 165.0f, 0x404040);
        int sectionLength = 67;
        int x = 0;
        int y = 0;
        int xo = 9;
        int yo = 22;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 3 * this.rows;
        ArrayList<class_2561> dspToolTip = new ArrayList<class_2561>();
        ArrayList<class_5250> lineList = new ArrayList<class_5250>();
        int toolPosX = 0;
        int toolPosY = 0;
        int offY = 23;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            IAEItemStack stored = this.storage.findPrecise(refStack);
            IAEItemStack pendingStack = this.pending.findPrecise(refStack);
            IAEItemStack missingStack = this.missing.findPrecise(refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                ++lines;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = Long.toString(stored.getStackSize());
                if (stored.getStackSize() >= 10000L) {
                    str = Long.toString(stored.getStackSize() / 1000L) + 'k';
                }
                if (stored.getStackSize() >= 10000000L) {
                    str = Long.toString(stored.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.FromStorage.getLocal() + ": " + str;
                int w2 = 4 + this.field_22793.method_1727(str);
                this.field_22793.method_1729(matrices, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w2 * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.FromStorage.withSuffix(": " + stored.getStackSize()));
                }
                downY += 5;
            }
            boolean red = false;
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                String str = Long.toString(missingStack.getStackSize());
                if (missingStack.getStackSize() >= 10000L) {
                    str = Long.toString(missingStack.getStackSize() / 1000L) + 'k';
                }
                if (missingStack.getStackSize() >= 10000000L) {
                    str = Long.toString(missingStack.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.Missing.getLocal() + ": " + str;
                w = 4 + this.field_22793.method_1727(str);
                this.field_22793.method_1729(matrices, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Missing.withSuffix(": " + missingStack.getStackSize()));
                }
                red = true;
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = Long.toString(pendingStack.getStackSize());
                if (pendingStack.getStackSize() >= 10000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000L) + 'k';
                }
                if (pendingStack.getStackSize() >= 10000000L) {
                    str = Long.toString(pendingStack.getStackSize() / 1000000L) + 'm';
                }
                str = GuiText.ToCraft.getLocal() + ": " + str;
                w = 4 + this.field_22793.method_1727(str);
                this.field_22793.method_1729(matrices, str, (float)((int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 23 + 22 + 6 - negY + downY) * 2), 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.ToCraft.withSuffix(": " + pendingStack.getStackSize()));
                }
            }
            RenderSystem.popMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            class_1799 is = refStack.asItemStackRepresentation();
            if (this.tooltip == z - viewStart) {
                dspToolTip.add(Platform.getItemDisplayName(refStack));
                if (lineList.size() > 0) {
                    dspToolTip.addAll(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
            }
            this.drawItem(posX, posY, is);
            if (red) {
                int startX = x * 68 + 9;
                int startY = posY - 4;
                CraftConfirmScreen.method_25294((class_4587)matrices, (int)startX, (int)startY, (int)(startX + 67), (int)(startY + 23), (int)452919296);
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && !dspToolTip.isEmpty()) {
            this.drawTooltip(matrices, toolPosX, toolPosY + 10, dspToolTip);
        }
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.setScrollBar();
        this.bindTexture("guis/craftingreport.png");
        this.method_25302(matrices, offsetX, offsetY, 0, 0, this.field_2792, this.field_2779);
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(114);
        this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.missing, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = s.findPrecise(l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add(l.copy());
                a = s.findPrecise(l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = this.storage.findPrecise(is);
        IAEItemStack c = this.pending.findPrecise(is);
        IAEItemStack m = this.missing.findPrecise(is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        if (m != null) {
            total += m.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(keyCode, scanCode) || keyCode != 257 && keyCode != 335)) {
            this.start();
            return true;
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Cpu", backwards ? "Prev" : "Next"));
    }

    private void start() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Start", "Start"));
    }
}

