/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import alexiil.mc.lib.attributes.Simulation;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.container.implementations.InterfaceTerminalContainer;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class InterfaceTerminalScreen
extends AEBaseScreen<InterfaceTerminalContainer> {
    private static final int LINES_ON_PAGE = 6;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private AETextField searchField;

    public InterfaceTerminalScreen(InterfaceTerminalContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.setScrollBar(new Scrollbar().setLeft(175).setTop(18).setHeight(106));
        this.field_2792 = 195;
        this.field_2779 = 222;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.searchField = new AETextField(this.field_22793, this.field_2776 + 104, this.field_2800 + 4, 65, 12);
        this.searchField.method_1858(false);
        this.searchField.method_1880(25);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1862(true);
        this.searchField.method_1863(str -> this.refreshList());
        this.method_25429((class_364)this.searchField);
        this.method_25407(true);
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.getGuiDisplayName(GuiText.InterfaceTerminal.text()), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, GuiText.inventory.text(), 8.0f, (float)(this.field_2779 - 96 + 3), 0x404040);
        int ex = this.getScrollBar().getCurrentScroll();
        ((InterfaceTerminalContainer)this.field_2797).field_7761.removeIf(slot -> slot instanceof SlotDisconnected);
        int offset = 17;
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().getSlotCount(); ++z) {
                    ((InterfaceTerminalContainer)this.field_2797).field_7761.add(new SlotDisconnected(inv, z, z * 18 + 8, 1 + offset));
                }
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                if (rows > 1) {
                    name = name + " (" + rows + ')';
                }
                while (name.length() > 2 && this.field_22793.method_1727(name) > 155) {
                    name = name.substring(0, name.length() - 1);
                }
                this.field_22793.method_1729(matrices, name, 10.0f, (float)(6 + offset), 0x404040);
            }
            offset += 18;
        }
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.method_25405(xCoord, yCoord)) {
            this.searchField.method_1852("");
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/interfaceterminal.png");
        this.method_25302(matrices, offsetX, offsetY, 0, 0, this.field_2792, this.field_2779);
        int offset = 17;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < 6 && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.getInventory().getSlotCount() * 18;
                this.method_25302(matrices, offsetX + 7, offsetY + offset, 7, 139, width, 18);
            }
            offset += 18;
        }
        if (this.searchField != null) {
            this.searchField.method_25394(matrices, mouseX, mouseY, partialTicks);
        }
    }

    public boolean method_25400(char character, int key) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        return super.method_25400(character, key);
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode != 256) {
            if (AppEng.instance().isActionKey(ActionKey.TOGGLE_FOCUS, keyCode, scanCode)) {
                this.searchField.method_25365(!this.searchField.method_25370());
                return true;
            }
            if (this.searchField.method_25370()) {
                if (keyCode == 257) {
                    this.searchField.method_25365(false);
                    return true;
                }
                this.searchField.method_25404(keyCode, scanCode, p_keyPressed_3_);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    public void postUpdate(class_2487 in) {
        if (in.method_10577("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.method_10541()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                class_2487 invData = in.method_10562(key);
                class_5250 un = class_2561.class_2562.method_10877((String)invData.method_10558("un"));
                ClientDCInternalInv current = this.getById(id, invData.method_10537("sortBy"), (class_2561)un);
                for (int x = 0; x < current.getInventory().getSlotCount(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.method_10545(which)) continue;
                    current.getInventory().setInvStack(x, class_1799.method_7915((class_2487)invData.method_10562(which)), Simulation.ACTION);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.method_1882().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found && !searchFilterLowerCase.isEmpty()) {
                class_1799 itemStack;
                Iterator<class_1799> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getFormattedName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - 6, 2);
    }

    private boolean itemStackMatchesSearchTerm(class_1799 itemStack, String searchTerm) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_2487 encodedValue = itemStack.method_7969();
        if (encodedValue == null) {
            return false;
        }
        class_2499 outTag = encodedValue.method_10554("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            class_1799 parsedItemStack = class_1799.method_7915((class_2487)outTag.method_10602(i));
            if (parsedItemStack.method_7960() || !(displayName = Platform.getItemDisplayName(Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(parsedItemStack)).getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, class_2561 name) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, name);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

