/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.PowerUnits;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.implementations.NumberEntryWidget;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.implementations.LevelEmitterContainer;
import appeng.core.localization.GuiText;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class LevelEmitterScreen
extends UpgradeableScreen<LevelEmitterContainer> {
    private NumberEntryWidget level;
    private SettingToggleButton<LevelType> levelMode;
    private SettingToggleButton<YesNo> craftingMode;

    public LevelEmitterScreen(LevelEmitterContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.level = new NumberEntryWidget(this, 20, 17, 138, 62, NumberEntryType.LEVEL_ITEM_COUNT);
        this.level.setTextFieldBounds(25, 44, 75);
        this.level.addButtons(this.field_22786::add, arg_0 -> ((LevelEmitterScreen)this).method_25411(arg_0));
        this.level.setValue(((LevelEmitterContainer)this.field_2797).getReportingValue());
        this.level.setOnChange(this::saveReportingValue);
        this.level.setOnConfirm(() -> ((LevelEmitterScreen)this).method_25419());
        this.method_25407(true);
    }

    private void saveReportingValue() {
        this.level.getLongValue().ifPresent(((LevelEmitterContainer)this.field_2797)::setReportingValue);
    }

    @Override
    protected void addButtons() {
        this.levelMode = new ServerSettingToggleButton<LevelType>(this.field_2776 - 18, this.field_2800 + 8, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_2776 - 18, this.field_2800 + 28, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_2776 - 18, this.field_2800 + 48, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftingMode = new ServerSettingToggleButton<YesNo>(this.field_2776 - 18, this.field_2800 + 48, Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        this.method_25411((class_339)this.levelMode);
        this.method_25411((class_339)this.redstoneMode);
        this.method_25411((class_339)this.craftingMode);
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        boolean notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        this.level.setActive(notCraftingMode);
        this.levelMode.field_22763 = notCraftingMode;
        this.redstoneMode.field_22763 = notCraftingMode;
        super.drawFG(matrices, offsetX, offsetY, mouseX, mouseY);
        if (this.craftingMode != null) {
            this.craftingMode.set(this.cvb.getCraftingMode());
        }
        if (this.levelMode != null) {
            LevelType currentLevelMode = ((LevelEmitterContainer)this.cvb).getLevelMode();
            this.levelMode.set(currentLevelMode);
            if (notCraftingMode && currentLevelMode == LevelType.ENERGY_LEVEL) {
                this.field_22793.method_1729(matrices, PowerUnits.AE.textComponent().getString(), 110.0f, 44.0f, 0x404040);
            }
        }
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrices, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.level.render(matrices, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void handleButtonVisibility() {
        this.craftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
    }

    @Override
    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    @Override
    protected GuiText getName() {
        return GuiText.LevelEmitter;
    }
}

