/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.ActionKey;
import appeng.client.gui.AEBaseMEScreen;
import appeng.client.gui.implementations.MEPortableCellScreen;
import appeng.client.gui.implementations.SecurityStationScreen;
import appeng.client.gui.implementations.WirelessTermScreen;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.me.InternalSlotME;
import appeng.client.me.ItemRepo;
import appeng.client.render.StackSizeRenderer;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.CraftingStatusContainer;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.integration.abstraction.ReiFacade;
import appeng.mixins.SlotMixin;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.tile.misc.SecurityStationBlockEntity;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.List;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class MEMonitorableScreen<T extends MEMonitorableContainer>
extends AEBaseMEScreen<T>
implements ISortSource,
IConfigManagerHost {
    private static int craftingGridOffsetX;
    private static int craftingGridOffsetY;
    private static String memoryText;
    private final ItemRepo repo;
    private final int offsetX = 9;
    private final int lowerTextureOffset = 0;
    private final IConfigManager configSrc;
    private final boolean viewCell;
    private final class_1799[] myCurrentViewCells = new class_1799[5];
    private TabButton craftingStatusBtn;
    private AETextField searchField;
    private GuiText myName;
    private int perRow = 9;
    private int reservedSpace = 0;
    private boolean customSortOrder = true;
    private int rows = 0;
    private int maxRows = Integer.MAX_VALUE;
    private int standardSize;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private SettingToggleButton<SortDir> sortDirToggle;
    private boolean isAutoFocus = false;
    private int currentMouseX = 0;
    private int currentMouseY = 0;

    public MEMonitorableScreen(T container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.setScrollBar();
        this.field_2792 = 185;
        this.field_2779 = 204;
        Object te = ((AEBaseContainer)((Object)container)).getTarget();
        if (te instanceof IViewCellStorage) {
            this.field_2792 += 33;
        }
        this.standardSize = this.field_2792;
        this.configSrc = ((IConfigurableObject)this.field_2797).getConfigManager();
        ((MEMonitorableContainer)this.field_2797).setGui(this);
        this.viewCell = te instanceof IViewCellStorage;
        if (te instanceof SecurityStationBlockEntity) {
            this.myName = GuiText.Security;
        } else if (te instanceof WirelessTerminalGuiObject) {
            this.myName = GuiText.WirelessTerminal;
        } else if (te instanceof IPortableCell) {
            this.myName = GuiText.PortableCell;
        } else if (te instanceof IMEChest) {
            this.myName = GuiText.Chest;
        } else if (te instanceof AbstractTerminalPart) {
            this.myName = GuiText.Terminal;
        } else {
            throw new IllegalArgumentException("Invalid GUI target given: " + te);
        }
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, (this.repo.size() + this.perRow - 1) / this.perRow - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(CraftingStatusContainer.TYPE));
    }

    @Override
    public void method_25426() {
        this.getClient().field_1774.method_1462(true);
        this.maxRows = this.getMaxRows();
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.perRow = terminalStyle != TerminalStyle.FULL ? 9 : 9 + (this.field_22789 - this.standardSize) / 18;
        this.field_2792 = this.standardSize + (this.perRow - 9) * 18;
        int magicNumber = 115;
        int extraSpace = this.field_22790 - 115 - this.reservedSpace;
        this.rows = extraSpace / 18;
        if (this.rows > this.maxRows) {
            this.rows = this.maxRows;
        }
        if (this.rows < 3) {
            this.rows = 3;
        }
        this.field_2779 = 115 + this.rows * 18 + this.reservedSpace;
        this.getMeSlots().clear();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                this.getMeSlots().add(new InternalSlotME(this.repo, x + y * this.perRow, this.offsetX + x * 18, 18 + y * 18));
            }
        }
        super.method_25426();
        int offset = this.field_2800 + 8;
        if (this.customSortOrder) {
            this.sortByToggle = (SettingToggleButton)this.method_25411((class_339)new SettingToggleButton<SortOrder>(this.field_2776 - 18, offset, Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
            offset += 20;
        }
        if (this.viewCell || this instanceof WirelessTermScreen) {
            this.viewModeToggle = (SettingToggleButton)this.method_25411((class_339)new SettingToggleButton<ViewItems>(this.field_2776 - 18, offset, Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
            offset += 20;
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(this.field_2776 - 18, offset, Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.method_25411((class_339)this.sortDirToggle);
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.method_25411((class_339)new SettingToggleButton<SearchBoxMode>(this.field_2776 - 18, offset += 20, Settings.SEARCH_MODE, searchMode, Platform::isSearchModeAvailable, this::toggleTerminalSearchMode));
        offset += 20;
        if (!(this instanceof MEPortableCellScreen) || this instanceof WirelessTermScreen) {
            this.method_25411((class_339)new SettingToggleButton<TerminalStyle>(this.field_2776 - 18, offset, Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        }
        this.searchField = new AETextField(this.field_22793, this.field_2776 + Math.max(80, this.offsetX), this.field_2800 + 4, 90, 12);
        this.searchField.method_1858(false);
        this.searchField.method_1880(25);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.setSelectionColor(-16744448);
        this.searchField.method_1862(true);
        if (this.viewCell || this instanceof WirelessTermScreen) {
            this.craftingStatusBtn = (TabButton)this.method_25411((class_339)new TabButton(this.field_2776 + 170, this.field_2800 - 4, 178, GuiText.CraftingStatus.text(), this.field_22788, btn -> this.showCraftingStatus()));
            this.craftingStatusBtn.setHideEdge(true);
        }
        this.isAutoFocus = SearchBoxMode.AUTOSEARCH == searchMode || SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode;
        boolean isKeepFilter = SearchBoxMode.AUTOSEARCH_KEEP == searchMode || SearchBoxMode.JEI_AUTOSEARCH_KEEP == searchMode || SearchBoxMode.MANUAL_SEARCH_KEEP == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH_KEEP == searchMode;
        boolean isJEIEnabled = SearchBoxMode.JEI_AUTOSEARCH == searchMode || SearchBoxMode.JEI_MANUAL_SEARCH == searchMode;
        this.searchField.method_25365(this.isAutoFocus);
        if (isJEIEnabled) {
            memoryText = ReiFacade.instance().getSearchText();
        }
        if (isKeepFilter && memoryText != null && !memoryText.isEmpty()) {
            this.searchField.method_1852(memoryText);
            this.searchField.selectAll();
            this.repo.setSearchString(memoryText);
            this.repo.updateView();
            this.setScrollBar();
        }
        craftingGridOffsetX = Integer.MAX_VALUE;
        craftingGridOffsetY = Integer.MAX_VALUE;
        for (class_1735 s : ((MEMonitorableContainer)this.field_2797).field_7761) {
            if (s instanceof AppEngSlot && s.field_7873 < 197) {
                this.repositionSlot((AppEngSlot)s);
            }
            if (!(s instanceof CraftingMatrixSlot) && !(s instanceof FakeCraftingMatrixSlot) || s.field_7873 <= 0 || s.field_7872 <= 0) continue;
            craftingGridOffsetX = Math.min(craftingGridOffsetX, s.field_7873);
            craftingGridOffsetY = Math.min(craftingGridOffsetY, s.field_7872);
        }
        craftingGridOffsetX -= 25;
        craftingGridOffsetY -= 6;
        this.setScrollBar();
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.getGuiDisplayName(this.myName.text()), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, GuiText.inventory.text(), 8.0f, (float)(this.field_2779 - 96 + 3), 0x404040);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        if (this.craftingStatusBtn != null && ((MEMonitorableContainer)this.field_2797).activeCraftingJobs != -1) {
            int x = this.craftingStatusBtn.field_22760 + (this.craftingStatusBtn.method_25368() - 16) / 2;
            int y = this.craftingStatusBtn.field_22761 + (this.craftingStatusBtn.method_25364() - 16) / 2;
            StackSizeRenderer.renderSizeLabel(this.field_22793, x - this.field_2776, y - this.field_2800, (class_2561)new class_2585(String.valueOf(((MEMonitorableContainer)this.field_2797).activeCraftingJobs)));
        }
    }

    @Override
    public boolean method_25402(double xCoord, double yCoord, int btn) {
        if (this.searchField.method_25402(xCoord, yCoord, btn)) {
            return true;
        }
        if (this.searchField.method_25405(xCoord, yCoord) && btn == 1) {
            this.searchField.method_1852("");
            this.repo.setSearchString("");
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return super.method_25402(xCoord, yCoord, btn);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        this.getClient().field_1774.method_1462(false);
        memoryText = this.searchField.method_1882();
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.method_25302(matrices, offsetX, offsetY, 0, 0, 197, 18);
        if (this.viewCell || this instanceof SecurityStationScreen) {
            this.method_25302(matrices, offsetX + 197, offsetY, 197, 0, 46, 128);
        }
        for (int x = 0; x < this.rows; ++x) {
            this.method_25302(matrices, offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.method_25302(matrices, offsetX, offsetY + 16 + this.rows * 18 + this.lowerTextureOffset, 0, 70, 197, 99 + this.reservedSpace - this.lowerTextureOffset);
        if (this.viewCell) {
            boolean update = false;
            for (int i = 0; i < 5; ++i) {
                if (this.myCurrentViewCells[i] == ((MEMonitorableContainer)this.field_2797).getCellViewSlot(i).method_7677()) continue;
                update = true;
                this.myCurrentViewCells[i] = ((MEMonitorableContainer)this.field_2797).getCellViewSlot(i).method_7677();
            }
            if (update) {
                this.repo.setViewCell(this.myCurrentViewCells);
            }
        }
        if (this.searchField != null) {
            this.searchField.method_25394(matrices, mouseX, mouseY, partialTicks);
        }
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    int getMaxRows() {
        return AEConfig.instance().getTerminalStyle() == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    protected void repositionSlot(AppEngSlot s) {
        ((SlotMixin)((Object)s)).setY(s.getY() + this.field_2779 - 78 - 5);
    }

    public boolean method_25400(char character, int p_charTyped_2_) {
        if (character == ' ' && this.searchField.method_1882().isEmpty()) {
            return true;
        }
        if (this.isAutoFocus && !this.searchField.method_25370() && this.isHovered()) {
            this.searchField.method_25365(true);
        }
        if (this.searchField.method_25370() && this.searchField.method_25400(character, p_charTyped_2_)) {
            this.repo.setSearchString(this.searchField.method_1882());
            this.repo.updateView();
            this.setScrollBar();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode != 256 && !this.checkHotbarKeys(keyCode, scanCode)) {
            if (AppEng.instance().isActionKey(ActionKey.TOGGLE_FOCUS, keyCode, scanCode)) {
                this.searchField.method_25365(!this.searchField.method_25370());
                return true;
            }
            if (!this.searchField.method_25370() && this.isAutoFocus && this.isHovered()) {
                this.searchField.method_25365(true);
            }
            if (this.searchField.method_25370()) {
                if (keyCode == 257) {
                    this.searchField.method_25365(false);
                    return true;
                }
                if (this.searchField.method_25404(keyCode, scanCode, p_keyPressed_3_)) {
                    this.repo.setSearchString(this.searchField.method_1882());
                    this.repo.updateView();
                    this.setScrollBar();
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.method_2378(0, 0, this.field_2792, this.field_2779, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void method_25393() {
        this.repo.setPower(((MEMonitorableContainer)this.field_2797).isPowered());
        super.method_25393();
    }

    @Override
    public SortOrder getSortBy() {
        return (SortOrder)this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return (SortDir)this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return (ViewItems)this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public void updateSetting(IConfigManager manager, Settings settingName, Enum<?> newValue) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        this.repo.updateView();
    }

    int getReservedSpace() {
        return this.reservedSpace;
    }

    void setReservedSpace(int reservedSpace) {
        this.reservedSpace = reservedSpace;
    }

    public boolean isCustomSortOrder() {
        return this.customSortOrder;
    }

    void setCustomSortOrder(boolean customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public int getStandardSize() {
        return this.standardSize;
    }

    void setStandardSize(int standardSize) {
        this.standardSize = standardSize;
    }

    private void toggleTerminalSearchMode(SettingToggleButton<SearchBoxMode> btn, boolean backwards) {
        SearchBoxMode next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalSearchMode(next);
        btn.set(next);
        this.reinitalize();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <S extends Enum<S>> void toggleServerSetting(SettingToggleButton<S> btn, boolean backwards) {
        S next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting().name(), ((Enum)next).name()));
        btn.set(next);
    }

    private void reinitalize() {
        this.field_22786.removeAll(this.field_22791);
        this.field_22791.clear();
        this.method_25426();
    }

    @Override
    public List<Rectangle> getExclusionZones() {
        List<Rectangle> zones = super.getExclusionZones();
        zones.add(new Rectangle(this.field_2776 - 18, this.field_2800 + 8, 18, 160));
        zones.add(new Rectangle(this.field_2776 + 197, this.field_2800, 46, 128));
        return zones;
    }

    static {
        memoryText = "";
    }
}

