/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.me.ItemRepo;
import appeng.client.me.SlotME;
import appeng.container.implementations.NetworkStatusContainer;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class NetworkStatusScreen
extends AEBaseScreen<NetworkStatusContainer>
implements ISortSource {
    private final ItemRepo repo;
    private final int rows = 4;
    private int tooltip = -1;

    public NetworkStatusScreen(NetworkStatusContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        Scrollbar scrollbar = new Scrollbar();
        this.setScrollBar(scrollbar);
        this.repo = new ItemRepo(scrollbar, this);
        this.field_2779 = 153;
        this.field_2792 = 195;
        this.repo.setRowSize(5);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.method_25411((class_339)CommonButtons.togglePowerUnit(this.field_2776 - 18, this.field_2800 + 8));
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float btn) {
        int gx = (this.field_22789 - this.field_2792) / 2;
        int gy = (this.field_22790 - this.field_2779) / 2;
        this.tooltip = -1;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 14 + x * 31;
            int minY = gy + 41 + y * 18;
            if (minX < mouseX && minX + 28 > mouseX && minY < mouseY && minY + 20 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        super.method_25394(matrices, mouseX, mouseY, btn);
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, GuiText.NetworkDetails.text(), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, (class_2561)GuiText.StoredPower.withSuffix(": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_2797).getCurrentPower(), false)), 13.0f, 16.0f, 0x404040);
        this.field_22793.method_30883(matrices, (class_2561)GuiText.MaxPower.withSuffix(": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_2797).getMaxPower(), false)), 13.0f, 26.0f, 0x404040);
        this.field_22793.method_30883(matrices, (class_2561)GuiText.PowerInputRate.withSuffix(": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_2797).getAverageAddition(), true)), 13.0f, 133.0f, 0x404040);
        this.field_22793.method_30883(matrices, (class_2561)GuiText.PowerUsageRate.withSuffix(": " + Platform.formatPowerLong(((NetworkStatusContainer)this.field_2797).getPowerUsage(), true)), 13.0f, 123.0f, 0x404040);
        int sectionLength = 30;
        int x = 0;
        int y = 0;
        int xo = 12;
        int yo = 42;
        boolean viewStart = false;
        int viewEnd = 20;
        ArrayList<class_2561> toolTip = new ArrayList<class_2561>();
        int toolPosX = 0;
        int toolPosY = 0;
        for (int z = 0; z < Math.min(20, this.repo.size()); ++z) {
            IAEItemStack refStack = this.repo.getReferenceItem(z);
            if (refStack == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            String str = Long.toString(refStack.getStackSize());
            if (refStack.getStackSize() >= 10000L) {
                str = Long.toString(refStack.getStackSize() / 1000L) + 'k';
            }
            int w = this.field_22793.method_1727(str);
            this.field_22793.method_1729(matrices, str, (float)((int)(((double)(x * 30 + 12 + 30 - 19) - (double)w * 0.5) * 2.0)), (float)((y * 18 + 42 + 6) * 2), 0x404040);
            RenderSystem.popMatrix();
            int posX = x * 30 + 12 + 30 - 18;
            int posY = y * 18 + 42;
            if (this.tooltip == z - 0) {
                toolTip.add(Platform.getItemDisplayName(refStack));
                toolTip.add((class_2561)GuiText.Installed.withSuffix(": " + refStack.getStackSize()));
                if (refStack.getCountRequestable() > 0L) {
                    toolTip.add((class_2561)GuiText.EnergyDrain.withSuffix(": " + Platform.formatPowerLong(refStack.getCountRequestable(), true)));
                }
                toolPosX = x * 30 + 12 + 30 - 8;
                toolPosY = y * 18 + 42;
            }
            this.drawItem(posX, posY, refStack.asItemStackRepresentation());
            if (++x <= 4) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && toolTip.isEmpty()) {
            this.drawTooltip(matrices, toolPosX, toolPosY + 10, toolTip);
        }
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/networkstatus.png");
        this.method_25302(matrices, offsetX, offsetY, 0, 0, this.field_2792, this.field_2779);
    }

    public void postUpdate(List<IAEItemStack> list) {
        this.repo.clear();
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        int size = this.repo.size();
        this.getScrollBar().setTop(39).setLeft(175).setHeight(78);
        this.getScrollBar().setRange(0, (size + 4) / 5 - this.rows, 1);
    }

    protected void method_25409(class_4587 matrices, class_1799 stack, int x, int y) {
        class_1735 s = this.getSlot(x, y);
        if (s instanceof SlotME && !stack.method_7960()) {
            IAEItemStack myStack = null;
            try {
                SlotME theSlotField = (SlotME)s;
                myStack = theSlotField.getAEStack();
            }
            catch (Throwable theSlotField) {
                // empty catch block
            }
            if (myStack != null) {
                List currentToolTip = this.method_25408(stack);
                while (currentToolTip.size() > 1) {
                    currentToolTip.remove(1);
                }
                currentToolTip.add(GuiText.Installed.withSuffix(": " + myStack.getStackSize()));
                currentToolTip.add(GuiText.EnergyDrain.withSuffix(": " + Platform.formatPowerLong(myStack.getCountRequestable(), true)));
                this.drawTooltip(matrices, x, y, currentToolTip);
            }
        }
        super.method_25409(matrices, stack, x, y);
    }

    @Override
    public SortOrder getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public SortDir getSortDir() {
        return SortDir.ASCENDING;
    }

    @Override
    public ViewItems getSortDisplay() {
        return ViewItems.ALL;
    }
}

