/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import appeng.core.AEConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class NumberEntryWidget
extends class_332 {
    private static final class_2561 INVALID_NUMBER = new class_2588("gui.appliedenergistics2.validation.InvalidNumber");
    private static final String NUMBER_LESS_THAN_MIN_VALUE = "gui.appliedenergistics2.validation.NumberLessThanMinValue";
    private static final class_2561 PLUS = class_2561.method_30163((String)"+");
    private static final class_2561 MINUS = class_2561.method_30163((String)"-");
    private static final int TEXT_COLOR_ERROR = 16718080;
    private static final int TEXT_COLOR_NORMAL = 0xFFFFFF;
    private final AEBaseScreen<?> parent;
    private final int x;
    private final int y;
    private final ConfirmableTextField textField;
    private final NumberEntryType type;
    private List<class_4185> buttons;
    private long minValue;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;

    public NumberEntryWidget(AEBaseScreen<?> parent, int x, int y, int width, int height, NumberEntryType type) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.type = type;
        class_327 font = parent.getClient().field_1772;
        int inputX = parent.getX() + x;
        int inputY = parent.getY() + y;
        font.getClass();
        this.textField = new ConfirmableTextField(font, inputX, inputY, width, 9, class_2585.field_24366);
        this.textField.method_1858(false);
        this.textField.method_1880(16);
        this.textField.method_1868(0xFFFFFF);
        this.textField.method_1862(true);
        this.textField.method_1876(true);
        parent.method_20085((class_364)this.textField);
        this.textField.method_1863(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.field_22763 = active;
        this.buttons.forEach(b -> {
            b.field_22763 = active;
        });
    }

    public void setTextFieldBounds(int x, int y, int width) {
        this.textField.field_22760 = this.parent.getX() + x;
        this.textField.field_22761 = this.parent.getY() + y;
        this.textField.method_25358(width);
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void addButtons(Consumer<class_364> addChildren, Consumer<class_4185> addButton) {
        int[] steps = AEConfig.instance().getNumberEntrySteps(this.type);
        int a = steps[0];
        int b = steps[1];
        int c = steps[2];
        int d = steps[3];
        int left = this.parent.getX() + this.x;
        int top = this.parent.getY() + this.y;
        ArrayList<class_4185> buttons = new ArrayList<class_4185>(9);
        buttons.add(new class_4185(left, top, 22, 20, this.makeLabel(PLUS, a), btn -> this.addQty(a)));
        buttons.add(new class_4185(left + 28, top, 28, 20, this.makeLabel(PLUS, b), btn -> this.addQty(b)));
        buttons.add(new class_4185(left + 62, top, 32, 20, this.makeLabel(PLUS, c), btn -> this.addQty(c)));
        buttons.add(new class_4185(left + 100, top, 38, 20, this.makeLabel(PLUS, d), btn -> this.addQty(d)));
        buttons.forEach(addButton);
        addChildren.accept((class_364)this.textField);
        buttons.add(new class_4185(left, top + 42, 22, 20, this.makeLabel(MINUS, a), btn -> this.addQty(-a)));
        buttons.add(new class_4185(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, b), btn -> this.addQty(-b)));
        buttons.add(new class_4185(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, c), btn -> this.addQty(-c)));
        buttons.add(new class_4185(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, d), btn -> this.addQty(-d)));
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon(left + 104, top + 27);
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addButton);
        this.buttons = buttons;
        this.validate();
    }

    public OptionalInt getIntValue() {
        String text = this.textField.method_1882().trim();
        try {
            int value = Integer.parseInt(text, 10);
            if ((long)value < this.minValue) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalInt.empty();
        }
    }

    public OptionalLong getLongValue() {
        String text = this.textField.method_1882().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalLong.empty();
        }
    }

    public void setValue(long value) {
        this.textField.method_1852(String.valueOf(Math.max(this.minValue, value)));
        this.textField.method_1872();
        this.textField.method_1875(0);
        this.validate();
    }

    private void addQty(long i) {
        this.getLongValue().ifPresent(currentValue -> this.setValue(currentValue + i));
    }

    public void render(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        this.textField.method_25394(matrices, mouseX, mouseY, partialTicks);
    }

    private void validate() {
        ArrayList<class_2561> validationErrors = new ArrayList<class_2561>();
        String text = this.textField.method_1882().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                validationErrors.add((class_2561)new class_2588(NUMBER_LESS_THAN_MIN_VALUE, new Object[]{this.minValue}));
            }
        }
        catch (NumberFormatException ignored) {
            validationErrors.add(INVALID_NUMBER);
        }
        boolean valid = validationErrors.isEmpty();
        this.textField.method_1868(valid ? 0xFFFFFF : 16718080);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(validationErrors);
        }
    }

    private class_2561 makeLabel(class_2561 prefix, int amount) {
        return prefix.method_27662().method_27693(String.valueOf(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }
}

