/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.client.gui.implementations.MEMonitorableScreen;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.PatternTermContainer;
import appeng.container.slot.AppEngSlot;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.mixins.SlotMixin;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class PatternTermScreen
extends MEMonitorableScreen<PatternTermContainer> {
    private static final String BACKGROUND_CRAFTING_MODE = "guis/pattern.png";
    private static final String BACKGROUND_PROCESSING_MODE = "guis/pattern2.png";
    private static final String SUBSITUTION_DISABLE = "0";
    private static final String SUBSITUTION_ENABLE = "1";
    private static final String CRAFTMODE_CRFTING = "1";
    private static final String CRAFTMODE_PROCESSING = "0";
    private TabButton tabCraftButton;
    private TabButton tabProcessButton;
    private ActionButton substitutionsEnabledBtn;
    private ActionButton substitutionsDisabledBtn;

    public PatternTermScreen(PatternTermContainer container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.setReservedSpace(81);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.tabCraftButton = new TabButton(this.field_2776 + 173, this.field_2800 + this.field_2779 - 177, new class_1799((class_1935)class_2246.field_9980), GuiText.CraftingPattern.text(), this.field_22788, btn -> this.toggleCraftMode("0"));
        this.method_25411((class_339)this.tabCraftButton);
        this.tabProcessButton = new TabButton(this.field_2776 + 173, this.field_2800 + this.field_2779 - 177, new class_1799((class_1935)class_2246.field_10181), GuiText.ProcessingPattern.text(), this.field_22788, btn -> this.toggleCraftMode("1"));
        this.method_25411((class_339)this.tabProcessButton);
        this.substitutionsEnabledBtn = new ActionButton(this.field_2776 + 84, this.field_2800 + this.field_2779 - 163, ActionItems.ENABLE_SUBSTITUTION, act -> this.toggleSubstitutions("0"));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.method_25411((class_339)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(this.field_2776 + 84, this.field_2800 + this.field_2779 - 163, ActionItems.DISABLE_SUBSTITUTION, act -> this.toggleSubstitutions("1"));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.method_25411((class_339)this.substitutionsDisabledBtn);
        ActionButton clearBtn = new ActionButton(this.field_2776 + 74, this.field_2800 + this.field_2779 - 163, ActionItems.CLOSE, act -> this.clear());
        clearBtn.setHalfSize(true);
        this.method_25411((class_339)clearBtn);
        ActionButton encodeBtn = new ActionButton(this.field_2776 + 147, this.field_2800 + this.field_2779 - 142, ActionItems.ENCODE, act -> this.encode());
        this.method_25411((class_339)encodeBtn);
    }

    private void toggleCraftMode(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.CraftMode", mode));
    }

    private void toggleSubstitutions(String mode) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Substitute", mode));
    }

    private void encode() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Encode", "1"));
    }

    private void clear() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("PatternTerminal.Clear", "1"));
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (((PatternTermContainer)this.field_2797).isCraftingMode()) {
            this.tabCraftButton.field_22764 = true;
            this.tabProcessButton.field_22764 = false;
            if (((PatternTermContainer)this.field_2797).substitute) {
                this.substitutionsEnabledBtn.field_22764 = true;
                this.substitutionsDisabledBtn.field_22764 = false;
            } else {
                this.substitutionsEnabledBtn.field_22764 = false;
                this.substitutionsDisabledBtn.field_22764 = true;
            }
        } else {
            this.tabCraftButton.field_22764 = false;
            this.tabProcessButton.field_22764 = true;
            this.substitutionsEnabledBtn.field_22764 = false;
            this.substitutionsDisabledBtn.field_22764 = false;
        }
        super.drawFG(matrices, offsetX, offsetY, mouseX, mouseY);
        this.field_22793.method_30883(matrices, GuiText.PatternTerminal.text(), 8.0f, (float)(this.field_2779 - 96 + 2 - this.getReservedSpace()), 0x404040);
    }

    @Override
    protected String getBackground() {
        if (((PatternTermContainer)this.field_2797).isCraftingMode()) {
            return BACKGROUND_CRAFTING_MODE;
        }
        return BACKGROUND_PROCESSING_MODE;
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        int offsetPlayerSide = s.isPlayerSide() ? 5 : 3;
        ((SlotMixin)((Object)s)).setY(s.getY() + this.field_2779 - 78 - offsetPlayerSide);
    }
}

