/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.UpgradeableContainer;
import appeng.core.localization.GuiText;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.ImportBusPart;
import java.util.List;
import me.shedaniel.math.Rectangle;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class UpgradeableScreen<T extends UpgradeableContainer>
extends AEBaseScreen<T> {
    protected final UpgradeableContainer cvb;
    protected final IUpgradeableHost bc;
    protected SettingToggleButton<RedstoneMode> redstoneMode;
    protected SettingToggleButton<FuzzyMode> fuzzyMode;
    protected SettingToggleButton<YesNo> craftMode;
    protected SettingToggleButton<SchedulingMode> schedulingMode;

    public UpgradeableScreen(T container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        this.cvb = container;
        this.bc = (IUpgradeableHost)((AEBaseContainer)((Object)container)).getTarget();
        this.field_2792 = this.hasToolbox() ? 246 : 211;
        this.field_2779 = 184;
    }

    protected boolean hasToolbox() {
        return ((UpgradeableContainer)this.field_2797).hasToolbox();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.addButtons();
    }

    protected void addButtons() {
        this.redstoneMode = new ServerSettingToggleButton<RedstoneMode>(this.field_2776 - 18, this.field_2800 + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.method_25411((class_339)this.redstoneMode);
        this.fuzzyMode = new ServerSettingToggleButton<FuzzyMode>(this.field_2776 - 18, this.field_2800 + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.method_25411((class_339)this.fuzzyMode);
        this.craftMode = new ServerSettingToggleButton<YesNo>(this.field_2776 - 18, this.field_2800 + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.method_25411((class_339)this.craftMode);
        this.schedulingMode = new ServerSettingToggleButton<SchedulingMode>(this.field_2776 - 18, this.field_2800 + 68, Settings.SCHEDULING_MODE, SchedulingMode.DEFAULT);
        this.method_25411((class_339)this.schedulingMode);
    }

    @Override
    public void drawFG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.getGuiDisplayName(this.getName().text()), 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(matrices, GuiText.inventory.text(), 8.0f, (float)(this.field_2779 - 96 + 3), 0x404040);
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.getRedStoneMode());
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.getCraftingMode());
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.set(this.cvb.getSchedulingMode());
        }
    }

    @Override
    public void drawBG(class_4587 matrices, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.method_25302(matrices, offsetX, offsetY, 0, 0, 177, this.field_2779);
        if (this.drawUpgrades()) {
            this.method_25302(matrices, offsetX + 177, offsetY, 177, 0, 35, 14 + this.cvb.availableUpgrades() * 18);
        }
        if (this.hasToolbox()) {
            this.method_25302(matrices, offsetX + 178, offsetY + this.field_2779 - 90, 178, this.field_2779 - 90, 68, 68);
        }
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
        if (this.schedulingMode != null) {
            this.schedulingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CAPACITY) > 0 && this.bc instanceof ExportBusPart);
        }
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected GuiText getName() {
        return this.bc instanceof ImportBusPart ? GuiText.ImportBus : GuiText.ExportBus;
    }

    @Override
    public List<Rectangle> getExclusionZones() {
        List<Rectangle> zones = super.getExclusionZones();
        zones.add(new Rectangle(this.field_2776 - 18, this.field_2800 + 8, 18, 60));
        return zones;
    }
}

