/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.fluids.util.FluidSorters;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;

public class FluidRepo {
    private final IItemList<IAEFluidStack> list = Api.instance().storage().getStorageChannel(IFluidStorageChannel.class).createList();
    private final ArrayList<IAEFluidStack> view = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private IPartitionList<IAEFluidStack> myPartitionList;
    private boolean hasPower;

    public FluidRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public void updateView() {
        Pattern m;
        this.view.clear();
        this.view.ensureCapacity(this.list.size());
        String innerSearch = this.searchString;
        boolean searchMod = false;
        if (innerSearch.startsWith("@")) {
            searchMod = true;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Exception ignore1) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Exception ignore2) {
                return;
            }
        }
        ViewItems viewMode = this.sortSrc.getSortDisplay();
        boolean needsZeroCopy = viewMode == ViewItems.CRAFTABLE;
        boolean terminalSearchToolTips = AEConfig.instance().getSearchTooltips() != YesNo.NO;
        boolean notDone = false;
        for (IAEFluidStack fs : this.list) {
            if (this.myPartitionList != null && !this.myPartitionList.isListed(fs) || viewMode == ViewItems.CRAFTABLE && !fs.isCraftable() || viewMode == ViewItems.STORED && fs.getStackSize() == 0L) continue;
            String dspName = searchMod ? Platform.getModId(fs) : Platform.getFluidDisplayName(fs).getString();
            boolean foundMatchingFluidStack = false;
            notDone = true;
            if (m.matcher(dspName.toLowerCase()).find()) {
                notDone = false;
                foundMatchingFluidStack = true;
            }
            if (terminalSearchToolTips && notDone && !searchMod) {
                List<class_2561> tooltip = Platform.getTooltip(fs);
                for (class_2561 line : tooltip) {
                    if (!m.matcher(line.getString()).find()) continue;
                    foundMatchingFluidStack = true;
                    break;
                }
            }
            if (!foundMatchingFluidStack) continue;
            if (needsZeroCopy) {
                fs = fs.copy();
                fs.setStackSize(0L);
            }
            this.view.add(fs);
        }
        SortOrder sortBy = this.sortSrc.getSortBy();
        SortDir sortDir = this.sortSrc.getSortDir();
        FluidSorters.setDirection(sortDir);
        if (sortBy == SortOrder.MOD) {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (sortBy == SortOrder.AMOUNT) {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else {
            Collections.sort(this.view, FluidSorters.CONFIG_BASED_SORT_BY_NAME);
        }
    }

    public void postUpdate(IAEFluidStack is) {
        IAEFluidStack st = this.list.findPrecise(is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
    }

    public IAEFluidStack getReferenceFluid(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

