/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.me;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.core.Api;
import appeng.integration.abstraction.ReiFacade;
import appeng.items.storage.ViewCellItem;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ItemRepo {
    private final IItemList<IAEItemStack> list = Api.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();
    private final ArrayList<IAEItemStack> view = new ArrayList();
    private final IScrollSource src;
    private final ISortSource sortSrc;
    private int rowSize = 9;
    private String searchString = "";
    private IPartitionList<IAEItemStack> myPartitionList;
    private String innerSearch = "";
    private boolean hasPower;

    public ItemRepo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public IAEItemStack getReferenceItem(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    void setSearch(String search) {
        this.searchString = search == null ? "" : search;
    }

    public void postUpdate(IAEItemStack is) {
        IAEItemStack st = this.list.findPrecise(is);
        if (st != null) {
            st.reset();
            st.add(is);
        } else {
            this.list.add(is);
        }
    }

    public void setViewCell(class_1799[] list) {
        this.myPartitionList = ViewCellItem.createFilter(list);
        this.updateView();
    }

    public void updateView() {
        boolean needsZeroCopy;
        this.view.clear();
        this.view.ensureCapacity(this.list.size());
        ViewItems viewMode = this.sortSrc.getSortDisplay();
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        boolean bl = needsZeroCopy = viewMode == ViewItems.CRAFTABLE;
        if (searchMode == SearchBoxMode.JEI_AUTOSEARCH || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH || searchMode == SearchBoxMode.JEI_AUTOSEARCH_KEEP || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH_KEEP) {
            this.updateJEI(this.searchString);
        }
        this.innerSearch = this.searchString;
        boolean terminalSearchToolTips = AEConfig.instance().getSearchTooltips() != YesNo.NO;
        boolean searchMod = false;
        if (this.innerSearch.startsWith("@")) {
            searchMod = true;
            this.innerSearch = this.innerSearch.substring(1);
        }
        Pattern m = null;
        try {
            m = Pattern.compile(this.innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(this.innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        boolean notDone = false;
        for (IAEItemStack is : this.list) {
            if (this.myPartitionList != null && !this.myPartitionList.isListed(is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable() || viewMode == ViewItems.STORED && is.getStackSize() == 0L) continue;
            String dspName = searchMod ? Platform.getModId(is) : Platform.getItemDisplayName(is).getString();
            boolean foundMatchingItemStack = false;
            notDone = true;
            if (m.matcher(dspName.toLowerCase()).find()) {
                notDone = false;
                foundMatchingItemStack = true;
            }
            if (terminalSearchToolTips && notDone && !searchMod) {
                List<class_2561> tooltip = Platform.getTooltip(is);
                for (class_2561 line : tooltip) {
                    if (!m.matcher(line.getString()).find()) continue;
                    foundMatchingItemStack = true;
                    notDone = false;
                    break;
                }
            }
            if (!foundMatchingItemStack) continue;
            if (needsZeroCopy) {
                is = is.copy();
                is.setStackSize(0L);
            }
            this.view.add(is);
        }
        SortOrder SortBy = this.sortSrc.getSortBy();
        SortDir SortDir2 = this.sortSrc.getSortDir();
        ItemSorters.setDirection(SortDir2);
        if (SortBy == SortOrder.MOD) {
            Collections.sort(this.view, ItemSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (SortBy == SortOrder.AMOUNT) {
            Collections.sort(this.view, ItemSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else {
            Collections.sort(this.view, ItemSorters.CONFIG_BASED_SORT_BY_NAME);
        }
    }

    private void updateJEI(String filter) {
        ReiFacade.instance().setSearchText(filter);
    }

    public int size() {
        return this.view.size();
    }

    public void clear() {
        this.list.resetStatus();
    }

    public boolean hasPower() {
        return this.hasPower;
    }

    public void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }
}

