/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.ISlimReadableNumberConverter;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.ReadableNumberConverter;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_327;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

public class StackSizeRenderer {
    private static final ISlimReadableNumberConverter SLIM_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final IWideReadableNumberConverter WIDE_CONVERTER = ReadableNumberConverter.INSTANCE;

    public void renderStackSize(class_327 fontRenderer, IAEItemStack aeStack, int xPos, int yPos) {
        if (aeStack != null) {
            if (aeStack.getStackSize() == 0L && aeStack.isCraftable()) {
                class_2561 craftLabelText = AEConfig.instance().isUseLargeFonts() ? GuiText.LargeFontCraft.text() : GuiText.SmallFontCraft.text();
                StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, craftLabelText);
            }
            if (aeStack.getStackSize() > 0L) {
                String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
                StackSizeRenderer.renderSizeLabel(fontRenderer, xPos, yPos, (class_2561)new class_2585(stackSize));
            }
        }
    }

    public static void renderSizeLabel(class_327 fontRenderer, float xPos, float yPos, class_2561 text) {
        float scaleFactor = AEConfig.instance().isUseLargeFonts() ? 0.85f : 0.5f;
        float inverseScaleFactor = 1.0f / scaleFactor;
        int offset = AEConfig.instance().isUseLargeFonts() ? 0 : -1;
        class_4590 tm = new class_4590(new class_1160(0.0f, 0.0f, 300.0f), null, new class_1160(scaleFactor, scaleFactor, scaleFactor), null);
        RenderSystem.disableBlend();
        int X = (int)((xPos + (float)offset + 16.0f - (float)fontRenderer.method_27525((class_5348)text) * scaleFactor) * inverseScaleFactor);
        int Y = (int)((yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
        class_4597.class_4598 buffer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        fontRenderer.method_30882(text, (float)X, (float)Y, 0xFFFFFF, true, tm.method_22936(), (class_4597)buffer, false, 0, 0xF000F0);
        buffer.method_22993();
        RenderSystem.enableBlend();
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().isUseLargeFonts()) {
            return SLIM_CONVERTER.toSlimReadableForm(originalSize);
        }
        return WIDE_CONVERTER.toWideReadableForm(originalSize);
    }
}

