/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.client.render.cablebus.SmartCableTextures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

@Environment(value=EnvType.CLIENT)
class CableBuilder {
    private final EnumMap<CableCoreType, EnumMap<AEColor, class_1058>> coreTextures = new EnumMap(CableCoreType.class);
    public final EnumMap<AECableType, EnumMap<AEColor, class_1058>> connectionTextures;
    private final SmartCableTextures smartCableTextures;

    CableBuilder(Function<class_4730, class_1058> bakedTextureGetter) {
        EnumMap<AEColor, class_1058> colorTextures;
        for (CableCoreType cableCoreType : CableCoreType.values()) {
            colorTextures = new EnumMap<AEColor, class_1058>(AEColor.class);
            for (AEColor color : AEColor.values()) {
                colorTextures.put(color, bakedTextureGetter.apply(cableCoreType.getTexture(color)));
            }
            this.coreTextures.put(cableCoreType, colorTextures);
        }
        this.connectionTextures = new EnumMap(AECableType.class);
        for (Enum enum_ : AECableType.VALIDCABLES) {
            colorTextures = new EnumMap(AEColor.class);
            for (AEColor color : AEColor.values()) {
                colorTextures.put(color, bakedTextureGetter.apply(CableBuilder.getConnectionTexture((AECableType)enum_, color)));
            }
            this.connectionTextures.put((AECableType)enum_, colorTextures);
        }
        this.smartCableTextures = new SmartCableTextures(bakedTextureGetter);
    }

    static class_4730 getConnectionTexture(AECableType cableType, AEColor color) {
        String textureFolder;
        switch (cableType) {
            case GLASS: {
                textureFolder = "part/cable/glass/";
                break;
            }
            case COVERED: {
                textureFolder = "part/cable/covered/";
                break;
            }
            case SMART: {
                textureFolder = "part/cable/smart/";
                break;
            }
            case DENSE_COVERED: {
                textureFolder = "part/cable/dense_covered/";
                break;
            }
            case DENSE_SMART: {
                textureFolder = "part/cable/dense_smart/";
                break;
            }
            default: {
                throw new IllegalStateException("Cable type " + (Object)((Object)cableType) + " does not support connections.");
            }
        }
        return new class_4730(class_1059.field_5275, new class_2960("appliedenergistics2", textureFolder + color.name().toLowerCase(Locale.ROOT)));
    }

    public void addCableCore(AECableType cableType, AEColor color, QuadEmitter emitter) {
        switch (cableType) {
            case GLASS: {
                this.addCableCore(CableCoreType.GLASS, color, emitter);
                break;
            }
            case COVERED: 
            case SMART: {
                this.addCableCore(CableCoreType.COVERED, color, emitter);
                break;
            }
            case DENSE_COVERED: 
            case DENSE_SMART: {
                this.addCableCore(CableCoreType.DENSE, color, emitter);
                break;
            }
        }
    }

    public void addCableCore(CableCoreType coreType, AEColor color, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.coreTextures.get((Object)coreType).get((Object)color);
        cubeBuilder.setTexture(texture);
        switch (coreType) {
            case GLASS: {
                cubeBuilder.addCube(6.0f, 6.0f, 6.0f, 10.0f, 10.0f, 10.0f);
                break;
            }
            case COVERED: {
                cubeBuilder.addCube(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
                break;
            }
            case DENSE: {
                cubeBuilder.addCube(3.0f, 3.0f, 3.0f, 13.0f, 13.0f, 13.0f);
            }
        }
    }

    public void addGlassConnection(class_2350 facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, QuadEmitter emitter) {
        class_1058 texture;
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
            cubeBuilder.setTexture(texture);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
        }
        texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(10.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 6.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(6.0f, 10.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addStraightGlassConnection(class_2350 facing, AEColor cableColor, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing, facing.method_10153())));
        class_1058 texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case field_11033: 
            case field_11036: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case field_11043: 
            case field_11035: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case field_11034: 
            case field_11039: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addConstrainedGlassConnection(class_2350 facing, AEColor cableColor, int distanceFromEdge, QuadEmitter emitter) {
        if (distanceFromEdge >= 6) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.GLASS).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(6.0f, distanceFromEdge, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(10.0f, 6.0f, 6.0f, 16 - distanceFromEdge, 10.0f, 10.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(6.0f, 6.0f, distanceFromEdge, 10.0f, 10.0f, 6.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16 - distanceFromEdge);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(6.0f, 10.0f, 6.0f, 10.0f, 16 - distanceFromEdge, 10.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(distanceFromEdge, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
            }
        }
    }

    public void addCoveredConnection(class_2350 facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        class_1058 texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
        }
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
    }

    public void addStraightCoveredConnection(class_2350 facing, AEColor cableColor, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
    }

    private static void setStraightCableUVs(CubeBuilder cubeBuilder, class_2350 facing, int x, int y) {
        switch (facing) {
            case field_11033: 
            case field_11036: {
                cubeBuilder.setCustomUv(class_2350.field_11043, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(class_2350.field_11034, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(class_2350.field_11035, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(class_2350.field_11039, x, 0.0f, y, x);
                break;
            }
            case field_11034: 
            case field_11039: {
                cubeBuilder.setCustomUv(class_2350.field_11036, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(class_2350.field_11033, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(class_2350.field_11043, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(class_2350.field_11035, 0.0f, x, x, y);
                break;
            }
            case field_11043: 
            case field_11035: {
                cubeBuilder.setCustomUv(class_2350.field_11036, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(class_2350.field_11033, x, 0.0f, y, x);
                cubeBuilder.setCustomUv(class_2350.field_11034, 0.0f, x, x, y);
                cubeBuilder.setCustomUv(class_2350.field_11039, 0.0f, x, x, y);
            }
        }
    }

    public void addConstrainedCoveredConnection(class_2350 facing, AEColor cableColor, int distanceFromEdge, QuadEmitter emitter) {
        if (distanceFromEdge >= 5) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
    }

    public void addSmartConnection(class_2350 facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, int channels, QuadEmitter emitter) {
        if (connectionType == AECableType.COVERED || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        class_1058 texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        class_1058 oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        class_1058 evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        if (connectionType != AECableType.GLASS && !cableBusAdjacent) {
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setEmissiveMaterial(true);
            cubeBuilder.setTexture(oddChannel);
            cubeBuilder.setColorRGB(cableColor.blackVariant);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setTexture(evenChannel);
            cubeBuilder.setColorRGB(cableColor.whiteVariant);
            this.addBigCoveredCableSizedCube(facing, cubeBuilder);
            cubeBuilder.setEmissiveMaterial(false);
            cubeBuilder.setTexture(texture);
        }
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
    }

    public void addStraightSmartConnection(class_2350 facing, AEColor cableColor, int channels, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
        class_1058 oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        class_1058 evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setEmissiveMaterial(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addStraightCoveredCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
    }

    public void addConstrainedSmartConnection(class_2350 facing, AEColor cableColor, int distanceFromEdge, int channels, QuadEmitter emitter) {
        if (distanceFromEdge >= 5) {
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
        class_1058 oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        class_1058 evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setEmissiveMaterial(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addCoveredCableSizedCube(facing, distanceFromEdge, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
    }

    public void addDenseCoveredConnection(class_2350 facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, QuadEmitter emitter) {
        if (connectionType == AECableType.COVERED || connectionType == AECableType.SMART || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        class_1058 texture = this.connectionTextures.get((Object)AECableType.DENSE_COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
        cubeBuilder.setTexture(texture);
    }

    public void addDenseSmartConnection(class_2350 facing, AEColor cableColor, AECableType connectionType, boolean cableBusAdjacent, int channels, QuadEmitter emitter) {
        if (connectionType == AECableType.SMART) {
            this.addSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, emitter);
            return;
        }
        if (connectionType == AECableType.COVERED || connectionType == AECableType.GLASS) {
            this.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
            return;
        }
        if (connectionType == AECableType.DENSE_COVERED) {
            this.addDenseCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
            return;
        }
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        cubeBuilder.setDrawFaces(EnumSet.complementOf(EnumSet.of(facing)));
        class_1058 texture = this.connectionTextures.get((Object)AECableType.DENSE_SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        channels = (channels + 3) / 4;
        class_1058 oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        class_1058 evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setEmissiveMaterial(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
        cubeBuilder.setTexture(texture);
    }

    public void addStraightDenseCoveredConnection(class_2350 facing, AEColor cableColor, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.DENSE_COVERED).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
    }

    public void addStraightDenseSmartConnection(class_2350 facing, AEColor cableColor, int channels, QuadEmitter emitter) {
        CubeBuilder cubeBuilder = new CubeBuilder(emitter);
        class_1058 texture = this.connectionTextures.get((Object)AECableType.DENSE_SMART).get((Object)cableColor);
        cubeBuilder.setTexture(texture);
        CableBuilder.setStraightCableUVs(cubeBuilder, facing, 5, 11);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
        channels = (channels + 3) / 4;
        class_1058 oddChannel = this.smartCableTextures.getOddTextureForChannels(channels);
        class_1058 evenChannel = this.smartCableTextures.getEvenTextureForChannels(channels);
        cubeBuilder.setEmissiveMaterial(true);
        cubeBuilder.setTexture(oddChannel);
        cubeBuilder.setColorRGB(cableColor.blackVariant);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setTexture(evenChannel);
        cubeBuilder.setColorRGB(cableColor.whiteVariant);
        CableBuilder.addStraightDenseCableSizedCube(facing, cubeBuilder);
        cubeBuilder.setEmissiveMaterial(false);
    }

    private static void addDenseCableSizedCube(class_2350 facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(4.0f, 0.0f, 4.0f, 12.0f, 5.0f, 12.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(11.0f, 4.0f, 4.0f, 16.0f, 12.0f, 12.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(4.0f, 4.0f, 0.0f, 12.0f, 12.0f, 5.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(4.0f, 4.0f, 11.0f, 12.0f, 12.0f, 16.0f);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(4.0f, 11.0f, 4.0f, 12.0f, 16.0f, 12.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(0.0f, 4.0f, 4.0f, 5.0f, 12.0f, 12.0f);
            }
        }
    }

    private static void addStraightDenseCableSizedCube(class_2350 facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: 
            case field_11036: {
                cubeBuilder.setUvRotation(class_2350.field_11034, 3);
                cubeBuilder.addCube(3.0f, 0.0f, 3.0f, 13.0f, 16.0f, 13.0f);
                cubeBuilder.setUvRotation(class_2350.field_11034, 0);
                break;
            }
            case field_11034: 
            case field_11039: {
                cubeBuilder.setUvRotation(class_2350.field_11035, 3);
                cubeBuilder.setUvRotation(class_2350.field_11043, 3);
                cubeBuilder.addCube(0.0f, 3.0f, 3.0f, 16.0f, 13.0f, 13.0f);
                cubeBuilder.setUvRotation(class_2350.field_11035, 0);
                cubeBuilder.setUvRotation(class_2350.field_11043, 0);
                break;
            }
            case field_11043: 
            case field_11035: {
                cubeBuilder.setUvRotation(class_2350.field_11034, 3);
                cubeBuilder.setUvRotation(class_2350.field_11039, 3);
                cubeBuilder.addCube(3.0f, 3.0f, 0.0f, 13.0f, 13.0f, 16.0f);
                cubeBuilder.setUvRotation(class_2350.field_11034, 0);
                cubeBuilder.setUvRotation(class_2350.field_11039, 0);
            }
        }
    }

    private static void addCoveredCableSizedCube(class_2350 facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
            }
        }
    }

    private static void addStraightCoveredCableSizedCube(class_2350 facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: 
            case field_11036: {
                cubeBuilder.setUvRotation(class_2350.field_11034, 3);
                cubeBuilder.addCube(5.0f, 0.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                cubeBuilder.setUvRotation(class_2350.field_11034, 0);
                break;
            }
            case field_11034: 
            case field_11039: {
                cubeBuilder.setUvRotation(class_2350.field_11035, 3);
                cubeBuilder.setUvRotation(class_2350.field_11043, 3);
                cubeBuilder.addCube(0.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                cubeBuilder.setUvRotation(class_2350.field_11035, 0);
                cubeBuilder.setUvRotation(class_2350.field_11043, 0);
                break;
            }
            case field_11043: 
            case field_11035: {
                cubeBuilder.setUvRotation(class_2350.field_11034, 3);
                cubeBuilder.setUvRotation(class_2350.field_11039, 3);
                cubeBuilder.addCube(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 16.0f);
                cubeBuilder.setUvRotation(class_2350.field_11034, 0);
                cubeBuilder.setUvRotation(class_2350.field_11039, 0);
            }
        }
    }

    private static void addCoveredCableSizedCube(class_2350 facing, int distanceFromEdge, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(6.0f, distanceFromEdge, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(11.0f, 6.0f, 6.0f, 16 - distanceFromEdge, 10.0f, 10.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(6.0f, 6.0f, distanceFromEdge, 10.0f, 10.0f, 5.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16 - distanceFromEdge);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(6.0f, 11.0f, 6.0f, 10.0f, 16 - distanceFromEdge, 10.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(distanceFromEdge, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
            }
        }
    }

    private void addBigCoveredCableSizedCube(class_2350 facing, CubeBuilder cubeBuilder) {
        switch (facing) {
            case field_11033: {
                cubeBuilder.addCube(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                break;
            }
            case field_11034: {
                cubeBuilder.addCube(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                break;
            }
            case field_11043: {
                cubeBuilder.addCube(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                break;
            }
            case field_11035: {
                cubeBuilder.addCube(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                break;
            }
            case field_11036: {
                cubeBuilder.addCube(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                break;
            }
            case field_11039: {
                cubeBuilder.addCube(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
            }
        }
    }

    public static List<class_4730> getTextures() {
        ArrayList<class_4730> locations = new ArrayList<class_4730>();
        for (CableCoreType cableCoreType : CableCoreType.values()) {
            for (AEColor color : AEColor.values()) {
                locations.add(cableCoreType.getTexture(color));
            }
        }
        for (Enum enum_ : AECableType.VALIDCABLES) {
            for (AEColor color : AEColor.values()) {
                locations.add(CableBuilder.getConnectionTexture((AECableType)enum_, color));
            }
        }
        Collections.addAll(locations, SmartCableTextures.SMART_CHANNELS_TEXTURES);
        return locations;
    }

    public class_1058 getCoreTexture(CableCoreType coreType, AEColor color) {
        return this.coreTextures.get((Object)coreType).get((Object)color);
    }
}

