/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.IDynamicPartBakedModel;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.client.render.cablebus.QuadRotator;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

@Environment(value=EnvType.CLIENT)
public class CableBusBakedModel
implements class_1087,
FabricBakedModel {
    private static final Mesh EMPTY_MESH = consumer -> {};
    private static final Renderer RENDERER = RendererAccess.INSTANCE.getRenderer();
    private static final int CACHE_MESH_COUNT = 100;
    private final LoadingCache<CableBusRenderState, Mesh> cableModelCache;
    private final CableBuilder cableBuilder;
    private final FacadeBuilder facadeBuilder;
    private final Map<class_2960, class_1087> partModels;
    private final class_1058 particleTexture;

    CableBusBakedModel(CableBuilder cableBuilder, FacadeBuilder facadeBuilder, Map<class_2960, class_1087> partModels, class_1058 particleTexture) {
        this.cableBuilder = cableBuilder;
        this.facadeBuilder = facadeBuilder;
        this.partModels = partModels;
        this.particleTexture = particleTexture;
        this.cableModelCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<CableBusRenderState, Mesh>(){

            public Mesh load(CableBusRenderState renderState) {
                Mesh mesh = CableBusBakedModel.this.buildCableModel(renderState);
                return mesh != null ? mesh : EMPTY_MESH;
            }
        });
    }

    public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
    }

    private CableBusRenderState getRenderState(class_1920 blockView, class_2338 pos) {
        RenderAttachedBlockView renderAttachedBlockView = (RenderAttachedBlockView)blockView;
        Object renderAttachment = renderAttachedBlockView.getBlockEntityRenderAttachment(pos);
        if (renderAttachment instanceof CableBusRenderState) {
            return (CableBusRenderState)renderAttachment;
        }
        return null;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        CableBusRenderState renderState = this.getRenderState(blockView, pos);
        if (renderState == null) {
            return;
        }
        Mesh cableModel = (Mesh)this.cableModelCache.getUnchecked((Object)renderState);
        if (cableModel != EMPTY_MESH) {
            context.meshConsumer().accept(cableModel);
        }
        for (class_2350 facing : class_2350.values()) {
            IPartModel partModel = renderState.getAttachments().get(facing);
            if (partModel == null) continue;
            Object partModelData = renderState.getPartModelData().get(facing);
            for (class_2960 model : partModel.getModels()) {
                class_1087 bakedModel = this.partModels.get(model);
                if (bakedModel == null) {
                    throw new IllegalStateException("Trying to use an unregistered part model: " + model);
                }
                context.pushTransform(QuadRotator.get(facing, class_2350.field_11036));
                if (bakedModel instanceof IDynamicPartBakedModel) {
                    ((IDynamicPartBakedModel)bakedModel).emitQuads(blockView, state, pos, randomSupplier, context, facing, partModelData);
                } else if (bakedModel instanceof FabricBakedModel) {
                    ((FabricBakedModel)bakedModel).emitBlockQuads(blockView, state, pos, randomSupplier, context);
                } else {
                    context.fallbackConsumer().accept(bakedModel);
                }
                context.popTransform();
            }
        }
        Mesh mesh = this.facadeBuilder.getFacadeMesh(renderState, randomSupplier, this.partModels::get);
        context.meshConsumer().accept(mesh);
    }

    private static boolean isStraightLine(AECableType cableType, EnumMap<class_2350, AECableType> sides) {
        Iterator<Map.Entry<class_2350, AECableType>> it = sides.entrySet().iterator();
        if (!it.hasNext()) {
            return false;
        }
        Map.Entry<class_2350, AECableType> nextConnection = it.next();
        class_2350 firstSide = nextConnection.getKey();
        AECableType firstType = nextConnection.getValue();
        if (!it.hasNext()) {
            return false;
        }
        if (firstSide.method_10153() != it.next().getKey()) {
            return false;
        }
        if (it.hasNext()) {
            return false;
        }
        AECableType secondType = sides.get(firstSide.method_10153());
        return firstType == secondType && cableType == firstType && cableType == secondType;
    }

    private Mesh buildCableModel(CableBusRenderState renderState) {
        boolean noAttachments;
        AECableType cableType = renderState.getCableType();
        if (cableType == AECableType.NONE) {
            return null;
        }
        AEColor cableColor = renderState.getCableColor();
        EnumMap<class_2350, AECableType> connectionTypes = renderState.getConnectionTypes();
        MeshBuilder builder = RENDERER.meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        boolean bl = noAttachments = !renderState.getAttachments().values().stream().anyMatch(IPartModel::requireCableConnection);
        if (noAttachments && CableBusBakedModel.isStraightLine(cableType, connectionTypes)) {
            class_2350 facing = connectionTypes.keySet().iterator().next();
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addStraightGlassConnection(facing, cableColor, emitter);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addStraightCoveredConnection(facing, cableColor, emitter);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addStraightSmartConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), emitter);
                    break;
                }
                case DENSE_COVERED: {
                    this.cableBuilder.addStraightDenseCoveredConnection(facing, cableColor, emitter);
                    break;
                }
                case DENSE_SMART: {
                    this.cableBuilder.addStraightDenseSmartConnection(facing, cableColor, renderState.getChannelsOnSide().get(facing), emitter);
                    break;
                }
            }
            return builder.build();
        }
        this.cableBuilder.addCableCore(renderState.getCoreType(), cableColor, emitter);
        EnumMap<class_2350, Integer> attachmentConnections = renderState.getAttachmentConnections();
        for (class_2350 class_23502 : attachmentConnections.keySet()) {
            int distance = attachmentConnections.get(class_23502);
            int channels = renderState.getChannelsOnSide().get(class_23502);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addConstrainedGlassConnection(class_23502, cableColor, distance, emitter);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addConstrainedCoveredConnection(class_23502, cableColor, distance, emitter);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addConstrainedSmartConnection(class_23502, cableColor, distance, channels, emitter);
                    break;
                }
                case DENSE_COVERED: 
                case DENSE_SMART: {
                    break;
                }
            }
        }
        for (Map.Entry entry : connectionTypes.entrySet()) {
            class_2350 facing = (class_2350)entry.getKey();
            AECableType connectionType = (AECableType)((Object)entry.getValue());
            boolean cableBusAdjacent = renderState.getCableBusAdjacent().contains(facing);
            int channels = renderState.getChannelsOnSide().get(facing);
            switch (cableType) {
                case GLASS: {
                    this.cableBuilder.addGlassConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
                    break;
                }
                case COVERED: {
                    this.cableBuilder.addCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
                    break;
                }
                case SMART: {
                    this.cableBuilder.addSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, emitter);
                    break;
                }
                case DENSE_COVERED: {
                    this.cableBuilder.addDenseCoveredConnection(facing, cableColor, connectionType, cableBusAdjacent, emitter);
                    break;
                }
                case DENSE_SMART: {
                    this.cableBuilder.addDenseSmartConnection(facing, cableColor, connectionType, cableBusAdjacent, channels, emitter);
                    break;
                }
            }
        }
        return builder.build();
    }

    public List<class_1058> getParticleTextures(CableBusRenderState renderState) {
        CableCoreType coreType = CableCoreType.fromCableType(renderState.getCableType());
        AEColor cableColor = renderState.getCableColor();
        ArrayList<class_1058> result = new ArrayList<class_1058>();
        if (coreType != null) {
            result.add(this.cableBuilder.getCoreTexture(coreType, cableColor));
        }
        for (class_2350 side : renderState.getAttachments().keySet()) {
            IPartModel partModel = renderState.getAttachments().get(side);
            for (class_2960 model : partModel.getModels()) {
                class_1087 bakedModel = this.partModels.get(model);
                if (bakedModel == null) {
                    throw new IllegalStateException("Trying to use an unregistered part model: " + model);
                }
                class_1058 particleTexture = bakedModel.method_4711();
                if (this.isMissingTexture(particleTexture)) continue;
                result.add(particleTexture);
            }
        }
        return result;
    }

    private boolean isMissingTexture(class_1058 particleTexture) {
        return particleTexture instanceof class_1047;
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleTexture;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, Random random) {
        throw new IllegalStateException();
    }
}

