/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.EnumSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_765;

@Environment(value=EnvType.CLIENT)
public class CubeBuilder {
    private final EnumMap<class_2350, class_1058> textures = new EnumMap(class_2350.class);
    private EnumSet<class_2350> drawFaces = EnumSet.allOf(class_2350.class);
    private final EnumMap<class_2350, class_1162> customUv = new EnumMap(class_2350.class);
    private final byte[] uvRotations = new byte[class_2350.values().length];
    private int color = -1;
    private boolean useStandardUV = false;
    private boolean emissiveMaterial;
    private final QuadEmitter emitter;
    private int vertexIndex = 0;

    public CubeBuilder(QuadEmitter emitter) {
        this.emitter = emitter;
    }

    public void addCube(float x1, float y1, float z1, float x2, float y2, float z2) {
        x1 /= 16.0f;
        y1 /= 16.0f;
        z1 /= 16.0f;
        x2 /= 16.0f;
        y2 /= 16.0f;
        z2 /= 16.0f;
        for (class_2350 face : this.drawFaces) {
            this.putFace(face, x1, y1, z1, x2, y2, z2);
        }
    }

    public void addQuad(class_2350 face, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.putFace(face, x1, y1, z1, x2, y2, z2);
    }

    private void putFace(class_2350 face, float x1, float y1, float z1, float x2, float y2, float z2) {
        class_1058 texture = this.textures.get(face);
        QuadEmitter emitter = this.emitter;
        emitter.colorIndex(-1).nominalFace(face);
        UvVector uv = new UvVector();
        class_1162 customUv = this.customUv.get(face);
        if (customUv != null) {
            uv.u1 = texture.method_4580((double)customUv.method_4953());
            uv.v1 = texture.method_4570((double)customUv.method_4956());
            uv.u2 = texture.method_4580((double)customUv.method_4957());
            uv.v2 = texture.method_4570((double)customUv.method_23853());
        } else {
            uv = this.useStandardUV ? this.getStandardUv(face, texture, x1, y1, z1, x2, y2, z2) : this.getDefaultUv(face, texture, x1, y1, z1, x2, y2, z2);
        }
        switch (face) {
            case field_11033: {
                this.putVertexTR(face, x2, y1, z1, uv);
                this.putVertexBR(face, x2, y1, z2, uv);
                this.putVertexBL(face, x1, y1, z2, uv);
                this.putVertexTL(face, x1, y1, z1, uv);
                break;
            }
            case field_11036: {
                this.putVertexTL(face, x1, y2, z1, uv);
                this.putVertexBL(face, x1, y2, z2, uv);
                this.putVertexBR(face, x2, y2, z2, uv);
                this.putVertexTR(face, x2, y2, z1, uv);
                break;
            }
            case field_11043: {
                this.putVertexBR(face, x2, y2, z1, uv);
                this.putVertexTR(face, x2, y1, z1, uv);
                this.putVertexTL(face, x1, y1, z1, uv);
                this.putVertexBL(face, x1, y2, z1, uv);
                break;
            }
            case field_11035: {
                this.putVertexBL(face, x1, y2, z2, uv);
                this.putVertexTL(face, x1, y1, z2, uv);
                this.putVertexTR(face, x2, y1, z2, uv);
                this.putVertexBR(face, x2, y2, z2, uv);
                break;
            }
            case field_11039: {
                this.putVertexTL(face, x1, y1, z1, uv);
                this.putVertexTR(face, x1, y1, z2, uv);
                this.putVertexBR(face, x1, y2, z2, uv);
                this.putVertexBL(face, x1, y2, z1, uv);
                break;
            }
            case field_11034: {
                this.putVertexBR(face, x2, y2, z1, uv);
                this.putVertexBL(face, x2, y2, z2, uv);
                this.putVertexTL(face, x2, y1, z2, uv);
                this.putVertexTR(face, x2, y1, z1, uv);
            }
        }
        if (this.emissiveMaterial) {
            int lightmap = class_765.method_23687((int)15, (int)15);
            emitter.lightmap(lightmap, lightmap, lightmap, lightmap);
        }
        emitter.emit();
        this.vertexIndex = 0;
    }

    private UvVector getDefaultUv(class_2350 face, class_1058 texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case field_11033: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(z1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(z2 * 16.0f));
                break;
            }
            case field_11036: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(z1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(z2 * 16.0f));
                break;
            }
            case field_11043: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11035: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11039: {
                uv.u1 = texture.method_4580((double)(z1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(z2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11034: {
                uv.u1 = texture.method_4580((double)(z2 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(z1 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private UvVector getStandardUv(class_2350 face, class_1058 texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case field_11033: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - z1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - z2 * 16.0f));
                break;
            }
            case field_11036: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(z1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(z2 * 16.0f));
                break;
            }
            case field_11043: {
                uv.u1 = texture.method_4580((double)(16.0f - x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(16.0f - x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11035: {
                uv.u1 = texture.method_4580((double)(x1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(x2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11039: {
                uv.u1 = texture.method_4580((double)(z1 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(z2 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
                break;
            }
            case field_11034: {
                uv.u1 = texture.method_4580((double)(16.0f - z2 * 16.0f));
                uv.v1 = texture.method_4570((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.method_4580((double)(16.0f - z1 * 16.0f));
                uv.v2 = texture.method_4570((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private void putVertexTL(class_2350 face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v1;
            }
        }
        this.putVertex(face, x, y, z, u, v);
    }

    private void putVertexTR(class_2350 face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v2;
            }
        }
        this.putVertex(face, x, y, z, u, v);
    }

    private void putVertexBR(class_2350 face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v2;
            }
        }
        this.putVertex(face, x, y, z, u, v);
    }

    private void putVertexBL(class_2350 face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v1;
            }
        }
        this.putVertex(face, x, y, z, u, v);
    }

    private void putVertex(class_2350 face, float x, float y, float z, float u, float v) {
        this.emitter.pos(this.vertexIndex, x, y, z);
        this.emitter.normal(this.vertexIndex, (float)face.method_10148(), (float)face.method_10164(), (float)face.method_10165());
        this.emitter.spriteColor(this.vertexIndex, 0, this.color);
        this.emitter.sprite(this.vertexIndex, 0, u, v);
        ++this.vertexIndex;
    }

    public void setTexture(class_1058 texture) {
        for (class_2350 face : class_2350.values()) {
            this.textures.put(face, texture);
        }
    }

    public void setTextures(class_1058 up, class_1058 down, class_1058 north, class_1058 south, class_1058 east, class_1058 west) {
        this.textures.put(class_2350.field_11036, up);
        this.textures.put(class_2350.field_11033, down);
        this.textures.put(class_2350.field_11043, north);
        this.textures.put(class_2350.field_11035, south);
        this.textures.put(class_2350.field_11034, east);
        this.textures.put(class_2350.field_11039, west);
    }

    public void setTexture(class_2350 facing, class_1058 sprite) {
        this.textures.put(facing, sprite);
    }

    public void setDrawFaces(EnumSet<class_2350> drawFaces) {
        this.drawFaces = drawFaces;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorRGB(int color) {
        this.setColor(color | 0xFF000000);
    }

    public void setColorRGB(float r, float g, float b) {
        this.setColorRGB((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
    }

    public void setEmissiveMaterial(boolean renderFullBright) {
        this.emissiveMaterial = renderFullBright;
    }

    public void setCustomUv(class_2350 facing, float u1, float v1, float u2, float v2) {
        this.customUv.put(facing, new class_1162(u1, v1, u2, v2));
    }

    public void setUvRotation(class_2350 facing, int rotation) {
        if (rotation == 2) {
            rotation = 3;
        } else if (rotation == 3) {
            rotation = 2;
        }
        Preconditions.checkArgument((rotation >= 0 && rotation <= 3 ? 1 : 0) != 0, (Object)"rotation");
        this.uvRotations[facing.ordinal()] = (byte)rotation;
    }

    public void useStandardUV() {
        this.useStandardUV = true;
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

