/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.LightningArcParticleData;
import appeng.client.render.effects.LightningFX;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

@Environment(value=EnvType.CLIENT)
public class LightningArcFX
extends LightningFX {
    private static final Random RANDOM_GENERATOR = new Random();
    private final double rx;
    private final double ry;
    private final double rz;

    public LightningArcFX(class_638 world, double x, double y, double z, double ex, double ey, double ez, double r, double g, double b) {
        super(world, x, y, z, r, g, b, 6);
        this.rx = ex - x;
        this.ry = ey - y;
        this.rz = ez - z;
        this.regen();
    }

    @Override
    protected void regen() {
        double i = 1.0 / (double)(this.getSteps() - 1);
        double lastDirectionX = this.rx * i;
        double lastDirectionY = this.ry * i;
        double lastDirectionZ = this.rz * i;
        double len = Math.sqrt(lastDirectionX * lastDirectionX + lastDirectionY * lastDirectionY + lastDirectionZ * lastDirectionZ);
        for (int s = 0; s < this.getSteps(); ++s) {
            double[][] localSteps = this.getPrecomputedSteps();
            localSteps[s][0] = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][1] = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][2] = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<LightningArcParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        public class_703 createParticle(LightningArcParticleData effect, class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LightningArcFX lightningFX = new LightningArcFX(world, x, y, z, effect.target.field_1352, effect.target.field_1351, effect.target.field_1350, 0.0, 0.0, 0.0);
            lightningFX.method_18140(this.spriteSet);
            return lightningFX;
        }
    }
}

