/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class LightningFX
extends class_4003 {
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int STEPS = 5;
    private static final int BRIGHTNESS = 208;
    private final double[][] precomputedSteps;
    private final double[] vertices = new double[3];
    private final double[] verticesWithUV = new double[3];
    private boolean hasData = false;

    private LightningFX(class_638 world, double x, double y, double z, double r, double g, double b) {
        this(world, x, y, z, r, g, b, 6);
        this.regen();
    }

    protected LightningFX(class_638 world, double x, double y, double z, double r, double g, double b, int maxAge) {
        super(world, x, y, z, r, g, b);
        this.precomputedSteps = new double[5][3];
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
        this.field_3847 = maxAge;
    }

    protected void regen() {
        double lastDirectionX = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionY = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionZ = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        for (int s = 0; s < 5; ++s) {
            this.precomputedSteps[s][0] = lastDirectionX = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][1] = lastDirectionY = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][2] = lastDirectionZ = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
        }
    }

    protected int getSteps() {
        return 5;
    }

    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }
        this.field_3869 -= 0.04 * (double)this.field_3844;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        this.field_3852 *= (double)0.98f;
        this.field_3869 *= (double)0.98f;
        this.field_3850 *= (double)0.98f;
    }

    public void method_3074(class_4588 buffer, class_4184 camera, float partialTicks) {
        class_243 vec3d = camera.method_19326();
        float centerX = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float centerY = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float centerZ = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        float j = 1.0f;
        float red = this.field_3861 * 1.0f * 0.9f;
        float green = this.field_3842 * 1.0f * 0.95f;
        float blue = this.field_3859 * 1.0f;
        float alpha = this.field_3841;
        if (this.field_3866 == 3) {
            this.regen();
        }
        float u = this.method_18133() + (this.method_18134() - this.method_18133()) / 2.0f;
        float v = this.method_18135() + (this.method_18136() - this.method_18135()) / 2.0f;
        double scale = 0.02;
        double[] a = new double[3];
        double[] b = new double[3];
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        class_746 p = class_310.method_1551().field_1724;
        for (int layer = 0; layer < 2; ++layer) {
            if (layer == 0) {
                scale = 0.04;
                red = this.field_3861 * 1.0f * 0.4f;
                green = this.field_3842 * 1.0f * 0.25f;
                blue = this.field_3859 * 1.0f * 0.45f;
            } else {
                scale = 0.02;
                red = this.field_3861 * 1.0f * 0.9f;
                green = this.field_3842 * 1.0f * 0.65f;
                blue = this.field_3859 * 1.0f * 0.85f;
            }
            for (int cycle = 0; cycle < 3; ++cycle) {
                this.clear();
                double x = centerX;
                double y = centerY;
                double z = centerZ;
                for (int s = 0; s < 5; ++s) {
                    double xN = x + this.precomputedSteps[s][0];
                    double yN = y + this.precomputedSteps[s][1];
                    double zN = z + this.precomputedSteps[s][2];
                    double xD = xN - x;
                    double yD = yN - y;
                    double zD = zN - z;
                    if (cycle == 0) {
                        ox = yD * 0.0 - 1.0 * zD;
                        oy = zD * 0.0 - 0.0 * xD;
                        oz = xD * 1.0 - 0.0 * yD;
                    }
                    if (cycle == 1) {
                        ox = yD * 1.0 - 0.0 * zD;
                        oy = zD * 0.0 - 1.0 * xD;
                        oz = xD * 0.0 - 0.0 * yD;
                    }
                    if (cycle == 2) {
                        ox = yD * 0.0 - 0.0 * zD;
                        oy = zD * 1.0 - 0.0 * xD;
                        oz = xD * 0.0 - 1.0 * yD;
                    }
                    double ss = Math.sqrt(ox * ox + oy * oy + oz * oz) / ((5.0 - (double)s) / 5.0 * scale);
                    a[0] = x + (ox /= ss);
                    a[1] = y + (oy /= ss);
                    a[2] = z + (oz /= ss);
                    b[0] = x;
                    b[1] = y;
                    b[2] = z;
                    this.draw(red, green, blue, buffer, a, b, u, v);
                    x = xN;
                    y = yN;
                    z = zN;
                }
            }
        }
    }

    private void clear() {
        this.hasData = false;
    }

    private void draw(float red, float green, float blue, class_4588 tess, double[] a, double[] b, float u, float v) {
        if (this.hasData) {
            tess.method_22912(a[0], a[1], a[2]).method_22913(u, v).method_22915(red, green, blue, this.field_3841).method_22921(208, 208).method_1344();
            tess.method_22912(this.vertices[0], this.vertices[1], this.vertices[2]).method_22913(u, v).method_22915(red, green, blue, this.field_3841).method_22921(208, 208).method_1344();
            tess.method_22912(this.verticesWithUV[0], this.verticesWithUV[1], this.verticesWithUV[2]).method_22913(u, v).method_22915(red, green, blue, this.field_3841).method_22921(208, 208).method_1344();
            tess.method_22912(b[0], b[1], b[2]).method_22913(u, v).method_22915(red, green, blue, this.field_3841).method_22921(208, 208).method_1344();
        }
        this.hasData = true;
        for (int x = 0; x < 3; ++x) {
            this.vertices[x] = a[x];
            this.verticesWithUV[x] = b[x];
        }
    }

    protected double[][] getPrecomputedSteps() {
        return this.precomputedSteps;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public Factory(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LightningFX lightningFX = new LightningFX(world, x, y, z, xSpeed, ySpeed, zSpeed);
            lightningFX.method_18140(this.spriteSet);
            return lightningFX;
        }
    }
}

